/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.Asn1Object;
import com.intellij.execution.rmi.ssl.DerParser;
import com.intellij.execution.rmi.ssl.SslUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Base64;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PrivateKeyReader {
    public static final String P1_BEGIN_MARKER = "-----BEGIN RSA PRIVATE KEY";
    public static final String P1_END_MARKER = "-----END RSA PRIVATE KEY";
    public static final String P8_BEGIN_MARKER = "-----BEGIN PRIVATE KEY";
    public static final String P8_END_MARKER = "-----END PRIVATE KEY";
    public static final String EP8_BEGIN_MARKER = "-----BEGIN ENCRYPTED PRIVATE KEY";
    public static final String EP8_END_MARKER = "-----END ENCRYPTED PRIVATE KEY";
    public static final String OTHER_BEGIN_MARKER = "-----BEGIN";
    public static final String OTHER_END_MARKER = "-----END";
    private static final Map<String, Pair<PrivateKey, List<X509Certificate>>> keyCache = Collections.synchronizedMap(new HashMap());
    @NotNull
    private final String myFileName;
    @NotNull
    private final char[] myPassword;

    public PrivateKeyReader(@NotNull String fileName, @Nullable char[] password) {
        if (fileName == null) {
            PrivateKeyReader.$$$reportNull$$$0(0);
        }
        this.myFileName = fileName;
        this.myPassword = password;
    }

    @NotNull
    public PrivateKey getPrivateKey() throws IOException {
        PrivateKey privateKey = this.getPrivateKeyAndCertificate().getFirst();
        if (privateKey == null) {
            PrivateKeyReader.$$$reportNull$$$0(1);
        }
        return privateKey;
    }

    @NotNull
    public Pair<PrivateKey, List<X509Certificate>> getPrivateKeyAndCertificate() throws IOException {
        Pair<PrivateKey, List<X509Certificate>> pair = keyCache.get(this.myFileName);
        if (pair != null) {
            Pair<PrivateKey, List<X509Certificate>> pair2 = pair;
            if (pair2 == null) {
                PrivateKeyReader.$$$reportNull$$$0(2);
            }
            return pair2;
        }
        pair = PrivateKeyReader.read(this.myFileName, this.myPassword);
        keyCache.put(this.myFileName, pair);
        Pair<PrivateKey, List<X509Certificate>> pair3 = pair;
        if (pair3 == null) {
            PrivateKeyReader.$$$reportNull$$$0(3);
        }
        return pair3;
    }

    private static Pair<PrivateKey, List<X509Certificate>> read(String fileName, @Nullable char[] password) throws IOException {
        KeyFactory factory;
        try {
            factory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e2) {
            throw new IOException("JCE error: " + e2.getMessage());
        }
        return PrivateKeyReader.readKey(factory, fileName, password);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static Pair<PrivateKey, List<X509Certificate>> readKey(KeyFactory factory, String fileName, char[] password) throws IOException {
        PushbackInputStream stream = new PushbackInputStream(new FileInputStream(fileName));
        int peeked = stream.read();
        stream.unread(peeked);
        if (peeked == 48) {
            Pair<PrivateKey, Object> pair = Pair.create(PrivateKeyReader.readDerKey(factory, stream, password), null);
            Pair<PrivateKey, Object> pair2 = pair;
            if (pair2 == null) {
                PrivateKeyReader.$$$reportNull$$$0(4);
            }
            return pair2;
        }
        Pair<PrivateKey, List<X509Certificate>> pair = PrivateKeyReader.readPemKey(factory, stream, password);
        Pair<PrivateKey, List<X509Certificate>> pair3 = pair;
        if (pair3 == null) {
            PrivateKeyReader.$$$reportNull$$$0(5);
        }
        return pair3;
        finally {
            stream.close();
        }
    }

    @NotNull
    private static PrivateKey readDerKey(KeyFactory factory, InputStream stream, char[] password) throws IOException {
        PrivateKey privateKey;
        byte[] bytes2 = FileUtilRt.loadBytes(stream);
        try {
            privateKey = PrivateKeyReader.generatePrivateKey(factory, new PKCS8EncodedKeySpec(bytes2), "PKCS#8");
        }
        catch (IOException ignored2) {
            PrivateKey privateKey2 = PrivateKeyReader.generatePrivateKey(factory, PrivateKeyReader.createEncryptedKeySpec(bytes2, password), "Encrypted key");
            if (privateKey2 == null) {
                PrivateKeyReader.$$$reportNull$$$0(7);
            }
            return privateKey2;
        }
        if (privateKey == null) {
            PrivateKeyReader.$$$reportNull$$$0(6);
        }
        return privateKey;
    }

    private static Pair<PrivateKey, List<X509Certificate>> readPemKey(KeyFactory factory, InputStream stream, char[] password) throws IOException {
        List<String> lines = FileUtilRt.loadLines(new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)));
        PrivateKey key = null;
        ArrayList certs = new ArrayList();
        int i2 = 0;
        while (i2 < lines.size()) {
            Pair<PrivateKey, Integer> keyAndIdx = PrivateKeyReader.findPrivateKey(factory, lines, i2, password);
            if (keyAndIdx != null) {
                if (key != null) {
                    throw new IOException("Invalid PEM file: multiple keys found");
                }
                key = (PrivateKey)keyAndIdx.first;
                i2 = (Integer)keyAndIdx.second;
                continue;
            }
            Pair<X509Certificate, Integer> certAndIdx = PrivateKeyReader.findCertAndIdx(lines, i2);
            if (certAndIdx != null) {
                certs.add(certAndIdx.first);
                i2 = (Integer)certAndIdx.second;
                continue;
            }
            ++i2;
        }
        if (key != null) {
            return Pair.create(key, certs.isEmpty() ? null : certs);
        }
        throw new IOException("Invalid PEM file: no begin marker");
    }

    @Nullable
    private static Pair<X509Certificate, Integer> findCertAndIdx(List<String> lines, int i2) throws IOException {
        if (!lines.get(i2).startsWith(OTHER_BEGIN_MARKER)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int k2 = i2; k2 < lines.size(); ++k2) {
            String line = lines.get(k2);
            sb.append(line).append('\n');
            if (!line.startsWith(OTHER_END_MARKER)) continue;
            try {
                return Pair.create(SslUtil.readCertificateFromString(sb.toString()), k2 + 1);
            }
            catch (CertificateException e2) {
                throw new IOException("Error reading certificate", e2);
            }
        }
        return null;
    }

    private static PrivateKey generatePrivateKey(KeyFactory factory, KeySpec keySpec, String enc) throws IOException {
        try {
            return factory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e2) {
            throw new IOException("Invalid " + enc + " PEM file: " + e2.getMessage());
        }
    }

    @Nullable
    private static Pair<PrivateKey, Integer> findPrivateKey(KeyFactory factory, List<String> lines, int i2, @Nullable char[] password) throws IOException {
        Pair<? extends KeySpec, Integer> keySpecAndIdx = PrivateKeyReader.findRSAKeySpec(lines, i2);
        String enc = "PKCS#1";
        if (keySpecAndIdx == null) {
            keySpecAndIdx = PrivateKeyReader.findPKCS8EncodedKeySpec(lines, i2);
            enc = "PKCS#8";
        }
        if (keySpecAndIdx == null) {
            keySpecAndIdx = PrivateKeyReader.findEncryptedKeySpec(lines, i2, password);
            enc = "Encrypted key";
        }
        return keySpecAndIdx != null ? Pair.create(PrivateKeyReader.generatePrivateKey(factory, (KeySpec)keySpecAndIdx.first, enc), keySpecAndIdx.second) : null;
    }

    @Nullable
    private static Pair<? extends KeySpec, Integer> findEncryptedKeySpec(List<String> lines, int i2, @Nullable char[] password) throws IOException {
        if (!lines.get(i2).contains(EP8_BEGIN_MARKER)) {
            return null;
        }
        Pair<byte[], Integer> mat = PrivateKeyReader.readKeyMaterial(EP8_END_MARKER, lines, i2 + 1);
        return Pair.create(PrivateKeyReader.createEncryptedKeySpec((byte[])mat.first, password), mat.second);
    }

    private static PKCS8EncodedKeySpec createEncryptedKeySpec(byte[] keyBytes, char[] password) throws IOException {
        EncryptedPrivateKeyInfo encrypted = new EncryptedPrivateKeyInfo(keyBytes);
        PBEKeySpec encryptedKeySpec = new PBEKeySpec(password);
        try {
            SecretKeyFactory pbeKeyFactory = SecretKeyFactory.getInstance(encrypted.getAlgName());
            return encrypted.getKeySpec(pbeKeyFactory.generateSecret(encryptedKeySpec));
        }
        catch (GeneralSecurityException e2) {
            throw new IOException("JCE error: " + e2.getMessage());
        }
    }

    @Nullable
    private static Pair<? extends KeySpec, Integer> findPKCS8EncodedKeySpec(List<String> lines, int i2) throws IOException {
        if (!lines.get(i2).contains(P8_BEGIN_MARKER)) {
            return null;
        }
        Pair<byte[], Integer> mat = PrivateKeyReader.readKeyMaterial(P8_END_MARKER, lines, i2 + 1);
        return Pair.create(new PKCS8EncodedKeySpec((byte[])mat.first), mat.second);
    }

    @Nullable
    private static Pair<? extends KeySpec, Integer> findRSAKeySpec(List<String> lines, int i2) throws IOException {
        if (!lines.get(i2).contains(P1_BEGIN_MARKER)) {
            return null;
        }
        Pair<byte[], Integer> mat = PrivateKeyReader.readKeyMaterial(P1_END_MARKER, lines, i2 + 1);
        return Pair.create(PrivateKeyReader.getRSAKeySpec((byte[])mat.first), mat.second);
    }

    private static Pair<byte[], Integer> readKeyMaterial(String endMarker, List<String> strings2, int start) throws IOException {
        StringBuilder buf = new StringBuilder();
        for (int i2 = start; i2 < strings2.size(); ++i2) {
            String line = strings2.get(i2);
            if (line.contains(endMarker)) {
                return Pair.create(Base64.decode(buf.toString()), i2 + 1);
            }
            buf.append(line.trim());
        }
        throw new IOException("Invalid PEM file: No end marker");
    }

    private static RSAPrivateCrtKeySpec getRSAKeySpec(byte[] keyBytes) throws IOException {
        DerParser parser = new DerParser(keyBytes);
        Asn1Object sequence = parser.read();
        if (sequence.getType() != 16) {
            throw new IOException("Invalid DER: not a sequence");
        }
        parser = sequence.getParser();
        parser.read();
        BigInteger modulus = parser.read().getInteger();
        BigInteger publicExp = parser.read().getInteger();
        BigInteger privateExp = parser.read().getInteger();
        BigInteger prime1 = parser.read().getInteger();
        BigInteger prime2 = parser.read().getInteger();
        BigInteger exp1 = parser.read().getInteger();
        BigInteger exp2 = parser.read().getInteger();
        BigInteger crtCoef = parser.read().getInteger();
        return new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/rmi/ssl/PrivateKeyReader";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/rmi/ssl/PrivateKeyReader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrivateKey";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrivateKeyAndCertificate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readKey";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readDerKey";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

