/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PluginUtilImpl
implements PluginUtil {
    private static final Logger LOG = Logger.getInstance(PluginUtilImpl.class);

    @Override
    @Nullable
    public PluginId getCallerPlugin(int stackFrameCount) {
        Class<?> aClass = ReflectionUtil.getCallerClass(stackFrameCount + 1);
        if (aClass == null) {
            return null;
        }
        ClassLoader classLoader2 = aClass.getClassLoader();
        return classLoader2 instanceof PluginAwareClassLoader ? ((PluginAwareClassLoader)((Object)classLoader2)).getPluginId() : null;
    }

    @Override
    @Nullable
    public PluginId findPluginId(@NotNull Throwable t2) {
        if (t2 == null) {
            PluginUtilImpl.$$$reportNull$$$0(0);
        }
        return PluginUtilImpl.doFindPluginId(t2);
    }

    @Nullable
    public static PluginId doFindPluginId(@NotNull Throwable t2) {
        Throwable cause;
        PluginId id2;
        String s2;
        int pos;
        CharSequence className;
        if (t2 == null) {
            PluginUtilImpl.$$$reportNull$$$0(1);
        }
        if (t2 instanceof PluginException) {
            return ((PluginException)t2).getPluginId();
        }
        PluginId bundledId = null;
        HashSet<String> visitedClassNames = new HashSet<String>();
        for (StackTraceElement element : t2.getStackTrace()) {
            PluginId id3;
            String className2;
            if (element == null || !visitedClassNames.add(className2 = element.getClassName())) continue;
            PluginDescriptor descriptor2 = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(className2);
            PluginId pluginId = id3 = descriptor2 == null ? null : descriptor2.getPluginId();
            if (id3 == null || PluginManagerCore.CORE_ID.equals(id3)) continue;
            if (descriptor2.isBundled()) {
                if (bundledId != null) continue;
                bundledId = id3;
                PluginUtilImpl.logPluginDetection(className2, id3);
                continue;
            }
            PluginUtilImpl.logPluginDetection(className2, id3);
            return id3;
        }
        if (t2 instanceof NoSuchMethodException) {
            if (t2.getMessage() != null) {
                className = new StringBuilder();
                StringTokenizer tok = new StringTokenizer(t2.getMessage(), ".");
                while (tok.hasMoreTokens()) {
                    String token2 = tok.nextToken();
                    if (token2.isEmpty() || !Character.isJavaIdentifierStart(token2.charAt(0))) continue;
                    ((StringBuilder)className).append(token2);
                }
                PluginId pluginId = PluginManager.getPluginByClassNameAsNoAccessToClass(((StringBuilder)className).toString());
                if (pluginId != null) {
                    return pluginId;
                }
            }
        } else if (t2 instanceof ClassNotFoundException) {
            PluginId id4;
            if (t2.getMessage() != null && (id4 = PluginManager.getPluginByClassNameAsNoAccessToClass(t2.getMessage())) != null) {
                return id4;
            }
        } else if (t2 instanceof NoClassDefFoundError && t2.getMessage() != null) {
            PluginId id5;
            className = StringUtil.substringAfterLast(t2.getMessage(), " ");
            if (className == null) {
                className = t2.getMessage();
            }
            if (((String)className).indexOf(47) > 0) {
                className = ((String)className).replace('/', '.');
            }
            if ((id5 = PluginManager.getPluginByClassNameAsNoAccessToClass((String)className)) != null) {
                return PluginManager.getPluginByClassNameAsNoAccessToClass((String)className);
            }
        } else if (t2 instanceof AbstractMethodError && t2.getMessage() != null && (pos = (s2 = t2.getMessage()).indexOf(40)) >= 0 && (pos = (s2 = s2.substring(0, pos)).lastIndexOf(46)) >= 0 && (id2 = PluginManager.getPluginByClassNameAsNoAccessToClass(s2 = s2.substring(0, pos))) != null) {
            return id2;
        }
        PluginId causeId = (cause = t2.getCause()) == null ? null : PluginUtilImpl.doFindPluginId(cause);
        return causeId == null ? bundledId : causeId;
    }

    @Override
    @Nls
    @Nullable
    public String findPluginName(@NotNull PluginId pluginId) {
        IdeaPluginDescriptor plugin;
        if (pluginId == null) {
            PluginUtilImpl.$$$reportNull$$$0(2);
        }
        return (plugin = PluginManagerCore.getPlugin(pluginId)) == null ? null : plugin.getName();
    }

    private static void logPluginDetection(String className, PluginId id2) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        String message2 = "Detected a plugin " + id2 + " by class " + className;
        IdeaPluginDescriptor descriptor2 = PluginManagerCore.getPlugin(id2);
        if (descriptor2 != null) {
            ClassLoader loader2 = descriptor2.getClassLoader();
            message2 = message2 + "; loader=" + loader2 + '/' + loader2.getClass();
            if (loader2 instanceof PluginClassLoader) {
                message2 = message2 + "; loaded class: " + ((PluginClassLoader)loader2).hasLoadedClass(className);
            }
        }
        LOG.debug(message2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/PluginUtilImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findPluginId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doFindPluginId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findPluginName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

