/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lang.impl.PsiBuilderImpl;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;

final class MarkerPool {
    private final PsiBuilderImpl builder;
    private final IntArrayList freeStartMarkers = new IntArrayList();
    private final IntArrayList freeErrorItems = new IntArrayList();
    final ArrayList<PsiBuilderImpl.ProductionMarker> list = new ArrayList();

    MarkerPool(PsiBuilderImpl builder) {
        this.builder = builder;
        this.list.add(null);
    }

    PsiBuilderImpl.StartMarker allocateStartMarker() {
        if (!this.freeStartMarkers.isEmpty()) {
            return (PsiBuilderImpl.StartMarker)this.list.get(this.freeStartMarkers.popInt());
        }
        PsiBuilderImpl.StartMarker marker = new PsiBuilderImpl.StartMarker(this.list.size(), this.builder);
        this.list.add(marker);
        return marker;
    }

    PsiBuilderImpl.ErrorItem allocateErrorItem() {
        if (!this.freeErrorItems.isEmpty()) {
            return (PsiBuilderImpl.ErrorItem)this.list.get(this.freeErrorItems.popInt());
        }
        PsiBuilderImpl.ErrorItem item = new PsiBuilderImpl.ErrorItem(this.list.size(), this.builder);
        this.list.add(item);
        return item;
    }

    void freeMarker(PsiBuilderImpl.ProductionMarker marker) {
        marker.clean();
        (marker instanceof PsiBuilderImpl.StartMarker ? this.freeStartMarkers : this.freeErrorItems).push(marker.markerId);
    }

    PsiBuilderImpl.ProductionMarker get(int index2) {
        return this.list.get(index2);
    }
}

