/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.util;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmTypeDeclaration;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmUtil {
    private static final JvmModifier[] ACCESS_MODIFIERS = new JvmModifier[]{JvmModifier.PRIVATE, JvmModifier.PACKAGE_LOCAL, JvmModifier.PROTECTED, JvmModifier.PUBLIC};

    private JvmUtil() {
    }

    @NotNull
    static Iterable<JvmClass> resolveClasses(JvmReferenceType @NotNull [] types) {
        if (types == null) {
            JvmUtil.$$$reportNull$$$0(0);
        }
        List<JvmClass> list2 = ContainerUtil.mapNotNull(types, JvmUtil::resolveClass);
        if (list2 == null) {
            JvmUtil.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Contract(value="null -> null")
    @Nullable
    public static JvmClass resolveClass(@Nullable JvmReferenceType type) {
        if (type == null) {
            return null;
        }
        JvmTypeDeclaration resolved = type.resolve();
        return resolved instanceof JvmClass ? (JvmClass)resolved : null;
    }

    @PsiModifier.ModifierConstant
    @NotNull
    public static JvmModifier getAccessModifier(@PsiUtil.AccessLevel int accessLevel) {
        assert (accessLevel > 0 && accessLevel <= ACCESS_MODIFIERS.length) : accessLevel;
        JvmModifier jvmModifier = ACCESS_MODIFIERS[accessLevel - 1];
        if (jvmModifier == null) {
            JvmUtil.$$$reportNull$$$0(2);
        }
        return jvmModifier;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/jvm/util/JvmUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/jvm/util/JvmUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveClasses";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessModifier";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveClasses";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

