/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface TokenList {
    public int getTokenCount();

    @NotNull
    public CharSequence getTokenizedText();

    public int getTokenStart(int var1);

    public int getTokenEnd(int var1);

    @NotNull
    default public TextRange getTokenRange(int index2) {
        return new TextRange(this.getTokenStart(index2), this.getTokenEnd(index2));
    }

    public IElementType getTokenType(int var1);

    default public CharSequence getTokenText(int index2) {
        if (index2 < 0 || index2 >= this.getTokenCount()) {
            return null;
        }
        return this.getTokenizedText().subSequence(this.getTokenStart(index2), this.getTokenEnd(index2));
    }

    default public boolean hasType(int index2, @NotNull IElementType type) {
        if (type == null) {
            TokenList.$$$reportNull$$$0(0);
        }
        return this.getTokenType(index2) == type;
    }

    default public boolean hasType(int index2, IElementType ... types) {
        if (types == null) {
            TokenList.$$$reportNull$$$0(1);
        }
        return ArrayUtil.contains(this.getTokenType(index2), types);
    }

    default public boolean hasType(int index2, @NotNull TokenSet types) {
        if (types == null) {
            TokenList.$$$reportNull$$$0(2);
        }
        return types.contains(this.getTokenType(index2));
    }

    default public int backWithBraceMatching(int index2, @NotNull IElementType opening, @NotNull IElementType closing) {
        if (opening == null) {
            TokenList.$$$reportNull$$$0(3);
        }
        if (closing == null) {
            TokenList.$$$reportNull$$$0(4);
        }
        if (this.getTokenType(index2) == closing) {
            int nesting = 1;
            while (nesting > 0 && index2 > 0) {
                IElementType type;
                if ((type = this.getTokenType(--index2)) == closing) {
                    ++nesting;
                    continue;
                }
                if (type != opening) continue;
                --nesting;
            }
        }
        return index2 - 1;
    }

    default public int backWhile(int index2, @NotNull TokenSet toSkip) {
        if (toSkip == null) {
            TokenList.$$$reportNull$$$0(5);
        }
        while (this.hasType(index2, toSkip)) {
            --index2;
        }
        return index2;
    }

    default public int forwardWhile(int index2, @NotNull TokenSet toSkip) {
        if (toSkip == null) {
            TokenList.$$$reportNull$$$0(6);
        }
        while (this.hasType(index2, toSkip)) {
            ++index2;
        }
        return index2;
    }

    @NotNull
    default public Lexer asLexer() {
        return new WrappingLexer(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opening";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closing";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSkip";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lexer/TokenList";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "backWithBraceMatching";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "backWhile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "forwardWhile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class WrappingLexer
    extends LexerBase {
        private final TokenList myTokens;
        private int myIndex;

        WrappingLexer(TokenList tokens) {
            this.myTokens = tokens;
        }

        public TokenList getTokens() {
            return this.myTokens;
        }

        @Override
        public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            if (buffer == null) {
                WrappingLexer.$$$reportNull$$$0(0);
            }
            assert (Comparing.equal(buffer, this.myTokens.getTokenizedText()));
            assert (startOffset == 0);
            assert (endOffset == buffer.length());
            assert (initialState == 0);
            this.myIndex = 0;
        }

        @Override
        public int getState() {
            return this.myIndex;
        }

        @Override
        @Nullable
        public IElementType getTokenType() {
            return this.myTokens.getTokenType(this.myIndex);
        }

        @Override
        public int getTokenStart() {
            return this.myTokens.getTokenStart(this.myIndex);
        }

        @Override
        public int getTokenEnd() {
            return this.myTokens.getTokenEnd(this.myIndex);
        }

        @Override
        public void advance() {
            ++this.myIndex;
        }

        @Override
        @NotNull
        public CharSequence getBufferSequence() {
            CharSequence charSequence = this.myTokens.getTokenizedText();
            if (charSequence == null) {
                WrappingLexer.$$$reportNull$$$0(1);
            }
            return charSequence;
        }

        @Override
        public int getBufferEnd() {
            return this.myTokens.getTokenizedText().length();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lexer/TokenList$WrappingLexer";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lexer/TokenList$WrappingLexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBufferSequence";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "start";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

