/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.psi.impl;

import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReferenceProviderBean;
import com.intellij.model.psi.impl.LanguageReferenceProviders;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ReferenceProviders {
    private static final ExtensionPointName<PsiSymbolReferenceProviderBean> EP_NAME = new ExtensionPointName("com.intellij.psi.symbolReferenceProvider");

    @NotNull
    static LanguageReferenceProviders byLanguage(@NotNull Language language) {
        if (language == null) {
            ReferenceProviders.$$$reportNull$$$0(0);
        }
        LanguageReferenceProviders languageReferenceProviders = EP_NAME.computeIfAbsent(language, ReferenceProviders.class, ReferenceProviders::byLanguageInner);
        if (languageReferenceProviders == null) {
            ReferenceProviders.$$$reportNull$$$0(1);
        }
        return languageReferenceProviders;
    }

    @NotNull
    private static LanguageReferenceProviders byLanguageInner(@NotNull Language language) {
        if (language == null) {
            ReferenceProviders.$$$reportNull$$$0(2);
        }
        ArrayList<PsiSymbolReferenceProviderBean> result2 = new ArrayList<PsiSymbolReferenceProviderBean>();
        for (PsiSymbolReferenceProviderBean bean : EP_NAME.getExtensionList()) {
            Language hostLanguage = bean.getHostLanguage();
            boolean matches2 = hostLanguage instanceof MetaLanguage ? ((MetaLanguage)hostLanguage).matchesLanguage(language) : hostLanguage == Language.ANY || language.isKindOf(hostLanguage);
            if (!matches2) continue;
            result2.add(bean);
        }
        return new LanguageReferenceProviders(result2);
    }

    @NotNull
    public static List<PsiSymbolReferenceProviderBean> byTargetClass(@NotNull Class<? extends Symbol> targetClass) {
        if (targetClass == null) {
            ReferenceProviders.$$$reportNull$$$0(3);
        }
        List<PsiSymbolReferenceProviderBean> list2 = EP_NAME.getByGroupingKey(targetClass, ReferenceProviders.class, bean -> bean.getResolveTargetClass().isAssignableFrom(targetClass) ? targetClass : null);
        if (list2 == null) {
            ReferenceProviders.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/model/psi/impl/ReferenceProviders";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/model/psi/impl/ReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "byLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "byTargetClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "byLanguage";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "byLanguageInner";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "byTargetClass";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

