/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.PathUtilRt;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class AttachmentFactory {
    private static final Logger LOG = Logger.getInstance(AttachmentFactory.class);
    private static final long BIG_FILE_THRESHOLD_BYTES = 51200L;

    /*
     * Loose catch block
     */
    @NotNull
    public static Attachment createAttachment(@NotNull Path file2, boolean isBinary) {
        Attachment attachment;
        InputStream inputStream;
        block10: {
            if (file2 == null) {
                AttachmentFactory.$$$reportNull$$$0(0);
            }
            inputStream = Files.newInputStream(file2, new OpenOption[0]);
            attachment = AttachmentFactory.createAttachment(file2.toString(), inputStream, Files.size(file2), isBinary);
            if (inputStream == null) break block10;
            inputStream.close();
        }
        Attachment attachment2 = attachment;
        if (attachment2 == null) {
            AttachmentFactory.$$$reportNull$$$0(1);
        }
        return attachment2;
        {
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    LOG.warn("failed to create an attachment from " + file2, e2);
                    return new Attachment(file2.toString(), e2);
                }
            }
        }
    }

    public static Attachment createAttachment(String path, InputStream content, long contentLength, boolean isBinary) throws IOException {
        if (contentLength >= 51200L) {
            Path tempFile = FileUtil.createTempFile("ij-attachment-" + PathUtilRt.getFileName(path) + '.', isBinary ? ".bin" : ".txt", true).toPath();
            Files.copy(content, tempFile, StandardCopyOption.REPLACE_EXISTING);
            return new Attachment(path, tempFile, "[File is too big to display]");
        }
        byte[] bytes2 = StreamUtil.readBytes(content);
        String displayText = isBinary ? "[File is binary]" : new String(bytes2, StandardCharsets.UTF_8);
        return new Attachment(path, bytes2, displayText);
    }

    @NotNull
    public static Attachment createContext(@NotNull @NonNls String context2) {
        if (context2 == null) {
            AttachmentFactory.$$$reportNull$$$0(2);
        }
        return new Attachment("current-context.txt", !context2.isEmpty() ? context2 : "(unknown)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/AttachmentFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/AttachmentFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachment";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAttachment";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

