/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LoggerRt {
    private static Factory ourFactory;

    private static synchronized Factory getFactory() {
        if (ourFactory == null) {
            try {
                ourFactory = new IdeaFactory();
            }
            catch (Throwable t2) {
                try {
                    ourFactory = new Slf4JFactory();
                }
                catch (Throwable t22) {
                    ourFactory = new JavaFactory();
                }
            }
        }
        return ourFactory;
    }

    @NotNull
    public static LoggerRt getInstance(@NotNull String category) {
        if (category == null) {
            LoggerRt.$$$reportNull$$$0(0);
        }
        LoggerRt loggerRt = LoggerRt.getFactory().getInstance(category);
        if (loggerRt == null) {
            LoggerRt.$$$reportNull$$$0(1);
        }
        return loggerRt;
    }

    @NotNull
    public static LoggerRt getInstance(@NotNull Class<?> clazz) {
        if (clazz == null) {
            LoggerRt.$$$reportNull$$$0(2);
        }
        return LoggerRt.getInstance('#' + clazz.getName());
    }

    public void info(@Nullable String message2) {
        this.info(message2, null);
    }

    public void info(@NotNull Throwable t2) {
        if (t2 == null) {
            LoggerRt.$$$reportNull$$$0(3);
        }
        this.info(t2.getMessage(), t2);
    }

    public void warn(@Nullable String message2) {
        this.warn(message2, null);
    }

    public void warn(@NotNull Throwable t2) {
        if (t2 == null) {
            LoggerRt.$$$reportNull$$$0(4);
        }
        this.warn(t2.getMessage(), t2);
    }

    public void error(@Nullable String message2) {
        this.error(message2, null);
    }

    public void error(@NotNull Throwable t2) {
        if (t2 == null) {
            LoggerRt.$$$reportNull$$$0(5);
        }
        this.error(t2.getMessage(), t2);
    }

    public abstract void info(@Nullable String var1, @Nullable Throwable var2);

    public abstract void warn(@Nullable String var1, @Nullable Throwable var2);

    public abstract void error(@Nullable String var1, @Nullable Throwable var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/LoggerRt";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/LoggerRt";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "info";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "warn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface Factory {
        public LoggerRt getInstance(String var1);
    }

    private static final class IdeaFactory
    extends ReflectionBasedFactory {
        private final Method myGetInstance;
        private final Method myInfo;
        private final Method myWarn;
        private final Method myError;

        private IdeaFactory() throws Exception {
            Class<?> loggerClass = Class.forName("com.intellij.openapi.diagnostic.Logger");
            this.myGetInstance = loggerClass.getMethod("getInstance", String.class);
            this.myGetInstance.setAccessible(true);
            this.myInfo = loggerClass.getMethod("info", String.class, Throwable.class);
            this.myInfo.setAccessible(true);
            this.myWarn = loggerClass.getMethod("warn", String.class, Throwable.class);
            this.myInfo.setAccessible(true);
            this.myError = loggerClass.getMethod("error", String.class, Throwable.class);
            this.myError.setAccessible(true);
        }

        @Override
        protected void error(@Nullable String message2, @Nullable Throwable t2, Object logger) throws Exception {
            this.myError.invoke(logger, message2, t2);
        }

        @Override
        protected void warn(@Nullable String message2, @Nullable Throwable t2, Object logger) throws Exception {
            this.myWarn.invoke(logger, message2, t2);
        }

        @Override
        protected void info(@Nullable String message2, @Nullable Throwable t2, Object logger) throws Exception {
            this.myInfo.invoke(logger, message2, t2);
        }

        @Override
        protected Object getLogger(String category) throws Exception {
            return this.myGetInstance.invoke(null, category);
        }
    }

    private static final class Slf4JFactory
    extends ReflectionBasedFactory {
        private final Method myGetLogger;
        private final Method myInfo;
        private final Method myWarn;
        private final Method myError;

        private Slf4JFactory() throws Exception {
            Class<?> loggerFactoryClass = Class.forName("org.slf4j.LoggerFactory");
            this.myGetLogger = loggerFactoryClass.getMethod("getLogger", String.class);
            this.myGetLogger.setAccessible(true);
            Class<?> loggerClass = Class.forName("org.slf4j.Logger");
            this.myInfo = loggerClass.getMethod("info", String.class, Throwable.class);
            this.myInfo.setAccessible(true);
            this.myWarn = loggerClass.getMethod("warn", String.class, Throwable.class);
            this.myInfo.setAccessible(true);
            this.myError = loggerClass.getMethod("error", String.class, Throwable.class);
            this.myError.setAccessible(true);
        }

        @Override
        protected void error(@Nullable String message2, @Nullable Throwable t2, Object logger) throws Exception {
            this.myError.invoke(logger, message2, t2);
        }

        @Override
        protected void warn(@Nullable String message2, @Nullable Throwable t2, Object logger) throws Exception {
            this.myWarn.invoke(logger, message2, t2);
        }

        @Override
        protected void info(@Nullable String message2, @Nullable Throwable t2, Object logger) throws Exception {
            this.myInfo.invoke(logger, message2, t2);
        }

        @Override
        protected Object getLogger(String category) throws Exception {
            return this.myGetLogger.invoke(null, category);
        }
    }

    private static class JavaFactory
    implements Factory {
        private JavaFactory() {
        }

        @Override
        public LoggerRt getInstance(String category) {
            final Logger logger = Logger.getLogger(category);
            return new LoggerRt(){

                @Override
                public void info(@Nullable String message2, @Nullable Throwable t2) {
                    logger.log(Level.INFO, message2, t2);
                }

                @Override
                public void warn(@Nullable String message2, @Nullable Throwable t2) {
                    logger.log(Level.WARNING, message2, t2);
                }

                @Override
                public void error(@Nullable String message2, @Nullable Throwable t2) {
                    logger.log(Level.SEVERE, message2, t2);
                }
            };
        }
    }

    private static abstract class ReflectionBasedFactory
    implements Factory {
        private ReflectionBasedFactory() {
        }

        @Override
        public LoggerRt getInstance(String category) {
            try {
                final Object logger = this.getLogger(category);
                return new LoggerRt(){

                    @Override
                    public void info(@Nullable String message2, @Nullable Throwable t2) {
                        try {
                            ReflectionBasedFactory.this.info(message2, t2, logger);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void warn(@Nullable String message2, @Nullable Throwable t2) {
                        try {
                            ReflectionBasedFactory.this.warn(message2, t2, logger);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void error(@Nullable String message2, @Nullable Throwable t2) {
                        try {
                            ReflectionBasedFactory.this.error(message2, t2, logger);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }

        protected abstract void error(@Nullable String var1, @Nullable Throwable var2, Object var3) throws Exception;

        protected abstract void warn(@Nullable String var1, @Nullable Throwable var2, Object var3) throws Exception;

        protected abstract void info(@Nullable String var1, @Nullable Throwable var2, Object var3) throws Exception;

        protected abstract Object getLogger(String var1) throws Exception;
    }
}

