/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.TextChange;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BulkChangesMerger {
    public static final BulkChangesMerger INSTANCE = new BulkChangesMerger();
    private static final Logger LOG = Logger.getInstance(BulkChangesMerger.class);

    public CharSequence mergeToCharSequence(char @NotNull [] text, int textLength, @NotNull List<? extends TextChange> changes) {
        if (changes == null) {
            BulkChangesMerger.$$$reportNull$$$0(0);
        }
        if (text == null) {
            BulkChangesMerger.$$$reportNull$$$0(1);
        }
        return new String(this.mergeToCharArray(text, textLength, changes));
    }

    public char @NotNull [] mergeToCharArray(char @NotNull [] text, int textLength, @NotNull List<? extends TextChange> changes) {
        int n2;
        if (changes == null) {
            BulkChangesMerger.$$$reportNull$$$0(2);
        }
        if (text == null) {
            BulkChangesMerger.$$$reportNull$$$0(3);
        }
        int newLength = textLength;
        for (TextChange textChange : changes) {
            newLength += textChange.getText().length() - (textChange.getEnd() - textChange.getStart());
        }
        char[] data = new char[newLength];
        int n3 = textLength;
        int newEndOffset = data.length;
        for (int i2 = changes.size() - 1; i2 >= 0; --i2) {
            TextChange change = changes.get(i2);
            void symbolsToMoveNumber = n2 - change.getEnd();
            System.arraycopy(text, change.getEnd(), data, newEndOffset - symbolsToMoveNumber, (int)symbolsToMoveNumber);
            newEndOffset -= symbolsToMoveNumber;
            char[] changeSymbols = change.getChars();
            System.arraycopy(changeSymbols, 0, data, newEndOffset -= changeSymbols.length, changeSymbols.length);
            n2 = change.getStart();
        }
        if (n2 > 0) {
            System.arraycopy(text, 0, data, 0, n2);
        }
        if (data == null) {
            BulkChangesMerger.$$$reportNull$$$0(4);
        }
        return data;
    }

    public void mergeInPlace(char @NotNull [] data, int length, @NotNull List<? extends TextChangeImpl> changes) throws IllegalArgumentException {
        if (changes == null) {
            BulkChangesMerger.$$$reportNull$$$0(5);
        }
        if (data == null) {
            BulkChangesMerger.$$$reportNull$$$0(6);
        }
        if (changes.isEmpty()) {
            return;
        }
        int diff = 0;
        for (TextChangeImpl textChangeImpl : changes) {
            diff += textChangeImpl.getDiff();
        }
        if (length + diff > data.length) {
            throw new IllegalArgumentException(String.format("Can't perform in-place changes merge. Reason: data array is not big enough to hold resulting text. Current size: %d, minimum size: %d", data.length, length + diff));
        }
        try {
            Context context2 = new Context(changes, data, length, length + diff);
            while (!context2.isComplete()) {
                if (!context2.startGroup()) {
                    return;
                }
                context2.endGroup();
            }
        }
        catch (RuntimeException e2) {
            StringBuilder stringBuilder = new StringBuilder();
            for (TextChangeImpl textChangeImpl : changes) {
                stringBuilder.append(textChangeImpl.getText().length()).append(":").append(textChangeImpl.getStart()).append("-").append(textChangeImpl.getEnd()).append(",");
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            LOG.error(String.format("Invalid attempt to perform in-place document changes merge detected. Initial text length: %d, data array length: %d, changes: [%s], changes diff: %d", length, data.length, stringBuilder, diff), e2);
            char[] merged = this.mergeToCharArray(data, length, changes);
            System.arraycopy(merged, 0, data, 0, length + diff);
        }
    }

    public int updateOffset(int originalOffset, @NotNull List<? extends TextChange> changes) {
        if (changes == null) {
            BulkChangesMerger.$$$reportNull$$$0(7);
        }
        int offset = originalOffset;
        for (TextChange textChange : changes) {
            if (originalOffset <= textChange.getStart()) continue;
            offset += textChange.getText().length() - (textChange.getEnd() - textChange.getStart());
        }
        return offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/BulkChangesMerger";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/BulkChangesMerger";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeToCharArray";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mergeToCharSequence";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mergeToCharArray";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mergeInPlace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateOffset";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Context {
        private final List<? extends TextChangeImpl> myChanges;
        private final char[] myData;
        private final int myInputLength;
        private final int myOutputLength;
        private int myDataStartOffset;
        private int myDataEndOffset;
        private int myChangeGroupStartIndex;
        private int myChangeGroupEndIndex;
        private int myDiff;
        private int myFirstChangeShift;
        private int myLastChangeShift;

        Context(@NotNull List<? extends TextChangeImpl> changes, char @NotNull [] data, int inputLength, int outputLength) {
            if (changes == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (data == null) {
                Context.$$$reportNull$$$0(1);
            }
            this.myChanges = changes;
            this.myData = data;
            this.myInputLength = inputLength;
            this.myOutputLength = outputLength;
        }

        public boolean startGroup() {
            boolean first2 = true;
            while (this.myDiff == 0 && this.myChangeGroupStartIndex < this.myChanges.size()) {
                TextChangeImpl change = this.myChanges.get(this.myChangeGroupStartIndex);
                this.myDiff = change.getDiff();
                if (first2) {
                    this.myDiff += this.myFirstChangeShift;
                }
                if (this.myDiff != 0) {
                    this.myDataStartOffset = change.getStart();
                    if (!first2) break;
                    this.myDataStartOffset += this.myFirstChangeShift;
                    break;
                }
                int offset = change.getStart() + (first2 ? this.myFirstChangeShift : 0);
                CharArrayUtil.getChars(change.getText(), this.myData, offset);
                ++this.myChangeGroupStartIndex;
                first2 = false;
            }
            return this.myDiff != 0;
        }

        public void endGroup() {
            boolean includeEndChange = false;
            this.myLastChangeShift = 0;
            this.myChangeGroupEndIndex = this.myChangeGroupStartIndex + 1;
            while (this.myChangeGroupEndIndex < this.myChanges.size()) {
                assert (this.myDiff != 0) : String.format("Text: '%s', length: %d, changes: %s, change group indices: %d-%d", Arrays.toString(this.myData), this.myInputLength, this.myChanges, this.myChangeGroupStartIndex, this.myChangeGroupEndIndex);
                TextChangeImpl change = this.myChanges.get(this.myChangeGroupEndIndex);
                int newDiff = this.myDiff + change.getDiff();
                if (newDiff == 0) {
                    this.myDataEndOffset = change.getEnd();
                    includeEndChange = true;
                    break;
                }
                if (this.myDiff > 0 != newDiff > 0) {
                    this.myDataEndOffset = change.getStart() + this.myDiff;
                    this.myLastChangeShift = this.myDiff;
                    break;
                }
                this.myDiff = newDiff;
                ++this.myChangeGroupEndIndex;
            }
            if (this.myChangeGroupEndIndex >= this.myChanges.size()) {
                if (this.myDiff > 0) {
                    this.processLastPositiveGroup();
                } else {
                    this.processLastNegativeGroup();
                }
                this.myChangeGroupStartIndex = this.myChangeGroupEndIndex = this.myChanges.size();
            } else if (this.myDiff > 0) {
                this.processPositiveGroup(includeEndChange);
            } else {
                this.processNegativeGroup(includeEndChange);
            }
            this.myDiff = 0;
            this.myChangeGroupStartIndex = this.myChangeGroupEndIndex;
            if (includeEndChange) {
                ++this.myChangeGroupStartIndex;
            }
            this.myFirstChangeShift = this.myLastChangeShift;
        }

        private void processPositiveGroup(boolean includeEndChange) {
            int outputOffset = this.myDataEndOffset;
            int prevChangeStart = -1;
            for (int i2 = this.myChangeGroupEndIndex; i2 >= this.myChangeGroupStartIndex; --i2) {
                int length;
                TextChangeImpl change = this.myChanges.get(i2);
                if (prevChangeStart >= 0) {
                    length = prevChangeStart - change.getEnd();
                    System.arraycopy(this.myData, change.getEnd(), this.myData, outputOffset - length, length);
                    outputOffset -= length;
                }
                prevChangeStart = change.getStart();
                if (i2 == this.myChangeGroupEndIndex && !includeEndChange || (length = change.getText().length()) <= 0) continue;
                CharArrayUtil.getChars(change.getText(), this.myData, outputOffset - length);
                outputOffset -= length;
            }
        }

        private void processLastPositiveGroup() {
            int end = this.myChanges.get(this.myChanges.size() - 1).getEnd();
            int length = this.myInputLength - end;
            this.myDataEndOffset = this.myOutputLength - length;
            System.arraycopy(this.myData, end, this.myData, this.myDataEndOffset, length);
            this.myChangeGroupEndIndex = this.myChanges.size() - 1;
            this.processPositiveGroup(true);
        }

        private void processNegativeGroup(boolean includeEndChange) {
            int prevChangeEnd = -1;
            for (int i2 = this.myChangeGroupStartIndex; i2 <= this.myChangeGroupEndIndex; ++i2) {
                int length;
                TextChangeImpl change = this.myChanges.get(i2);
                if (prevChangeEnd >= 0) {
                    length = change.getStart() - prevChangeEnd;
                    System.arraycopy(this.myData, prevChangeEnd, this.myData, this.myDataStartOffset, length);
                    this.myDataStartOffset += length;
                }
                prevChangeEnd = change.getEnd();
                if (i2 == this.myChangeGroupEndIndex && !includeEndChange) {
                    return;
                }
                length = change.getText().length();
                if (length <= 0) continue;
                CharArrayUtil.getChars(change.getText(), this.myData, this.myDataStartOffset);
                this.myDataStartOffset += length;
            }
        }

        private void processLastNegativeGroup() {
            this.myChangeGroupEndIndex = this.myChanges.size() - 1;
            this.processNegativeGroup(true);
            int end = this.myChanges.get(this.myChangeGroupEndIndex).getEnd();
            System.arraycopy(this.myData, end, this.myData, this.myDataStartOffset, this.myInputLength - end);
        }

        public boolean isComplete() {
            return this.myChangeGroupStartIndex >= this.myChanges.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "data";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/BulkChangesMerger$Context";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

