/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002\u001a)\u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015\u001a\u001b\u0010\u0016\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u00a2\u0006\u0002\u0010\u001a\"\u0016\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0005\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"CHECK_CANCELED", "Lkotlin/Function0;", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "POINTS_IN_READONLY_MODE", "", "Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;", "checkThatClassloaderIsActive", "", "adapter", "Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;", "findInsertionIndexForAnyOrder", "", "adapters", "", "getOrCreateExtensionInstance", "T", "", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "(Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;Lcom/intellij/openapi/components/ComponentManager;)Ljava/lang/Object;", "isInsideClassInitializer", "trace", "", "Ljava/lang/StackTraceElement;", "([Ljava/lang/StackTraceElement;)Z", "intellij.platform.extensions"})
@SourceDebugExtension(value={"SMAP\nExtensionPointImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionPointImpl.kt\ncom/intellij/openapi/extensions/impl/ExtensionPointImplKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1066:1\n12474#2,2:1067\n46#3,5:1069\n11#3:1074\n*S KotlinDebug\n*F\n+ 1 ExtensionPointImpl.kt\ncom/intellij/openapi/extensions/impl/ExtensionPointImplKt\n*L\n1039#1:1067,2\n1054#1:1069,5\n37#1:1074\n*E\n"})
public final class ExtensionPointImplKt {
    @NotNull
    private static final Logger LOG;
    @Nullable
    private static Set<ExtensionPointImpl<?>> POINTS_IN_READONLY_MODE;
    @Nullable
    private static Function0<Unit> CHECK_CANCELED;

    private static final int findInsertionIndexForAnyOrder(List<? extends ExtensionComponentAdapter> adapters) {
        ExtensionComponentAdapter lastAdapter;
        int index2;
        for (index2 = adapters.size(); index2 > 0 && (lastAdapter = adapters.get(index2 - 1)).getOrder() == LoadingOrder.LAST; --index2) {
        }
        return index2;
    }

    private static final boolean checkThatClassloaderIsActive(ExtensionComponentAdapter adapter) {
        ClassLoader classLoader2 = adapter.pluginDescriptor.getPluginClassLoader();
        if (classLoader2 instanceof PluginAwareClassLoader && ((PluginAwareClassLoader)((Object)classLoader2)).getState() != 1) {
            LOG.warn(adapter + " not loaded because classloader is being unloaded");
            return false;
        }
        return true;
    }

    private static final boolean isInsideClassInitializer(StackTraceElement[] trace2) {
        boolean bl2;
        block1: {
            StackTraceElement[] $this$any$iv = trace2;
            boolean $i$f$any = false;
            int n2 = $this$any$iv.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                StackTraceElement element$iv;
                StackTraceElement it = element$iv = $this$any$iv[i2];
                boolean bl3 = false;
                if (!Intrinsics.areEqual("<clinit>", it.getMethodName())) continue;
                bl2 = true;
                break block1;
            }
            bl2 = false;
        }
        return bl2;
    }

    private static final <T> T getOrCreateExtensionInstance(ExtensionComponentAdapter adapter, ComponentManager componentManager) {
        if (!ExtensionPointImplKt.checkThatClassloaderIsActive(adapter)) {
            return null;
        }
        try {
            Object instance2 = adapter.createInstance(componentManager);
            if (instance2 == null) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl2 = false;
                    logger.debug(adapter + " not loaded because it reported that not applicable", e$iv);
                }
            }
            return instance2;
        }
        catch (ProcessCanceledException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            LOG.error(componentManager.createError(e3, adapter.pluginDescriptor.getPluginId()));
            return null;
        }
    }

    public static final /* synthetic */ void access$setCHECK_CANCELED$p(Function0 function0) {
        CHECK_CANCELED = function0;
    }

    public static final /* synthetic */ boolean access$isInsideClassInitializer(StackTraceElement[] trace2) {
        return ExtensionPointImplKt.isInsideClassInitializer(trace2);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ int access$findInsertionIndexForAnyOrder(List adapters) {
        return ExtensionPointImplKt.findInsertionIndexForAnyOrder(adapters);
    }

    public static final /* synthetic */ Object access$getOrCreateExtensionInstance(ExtensionComponentAdapter adapter, ComponentManager componentManager) {
        return ExtensionPointImplKt.getOrCreateExtensionInstance(adapter, componentManager);
    }

    public static final /* synthetic */ Function0 access$getCHECK_CANCELED$p() {
        return CHECK_CANCELED;
    }

    public static final /* synthetic */ boolean access$checkThatClassloaderIsActive(ExtensionComponentAdapter adapter) {
        return ExtensionPointImplKt.checkThatClassloaderIsActive(adapter);
    }

    public static final /* synthetic */ Set access$getPOINTS_IN_READONLY_MODE$p() {
        return POINTS_IN_READONLY_MODE;
    }

    public static final /* synthetic */ void access$setPOINTS_IN_READONLY_MODE$p(Set set) {
        POINTS_IN_READONLY_MODE = set;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ExtensionPointImpl.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
    }
}

