/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypesProvider;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@State(name="ProjectType")
public final class ProjectTypeService
implements PersistentStateComponent<ProjectType> {
    private static final Key<CachedValue<Collection<ProjectType>>> PROJECT_TYPES_KEY = Key.create("PROJECT_TYPES");
    private ProjectType myProjectType;

    @Deprecated
    @Nullable
    public static ProjectType getProjectType(@Nullable Project project) {
        ProjectType projectType;
        if (project != null && (projectType = ProjectTypeService.getInstance((Project)project).myProjectType) != null) {
            return projectType;
        }
        Collection<ProjectType> projectTypes = ProjectTypeService.getProjectTypes(project);
        if (!projectTypes.isEmpty()) {
            return projectTypes.iterator().next();
        }
        return null;
    }

    public static Set<String> getProjectTypeIds(@Nullable Project project) {
        return ContainerUtil.map2Set(ProjectTypeService.getProjectTypes(project), ProjectType::getId);
    }

    public static Collection<ProjectType> getProjectTypes(@Nullable Project project) {
        if (project == null) {
            return Collections.emptyList();
        }
        if (project.isDefault()) {
            return Collections.emptyList();
        }
        return (Collection)CachedValuesManager.getManager(project).getCachedValue(project, PROJECT_TYPES_KEY, () -> CachedValueProvider.Result.create(ProjectTypeService.findProjectTypes(project), ProjectRootManager.getInstance(project), DumbService.getInstance(project)), false);
    }

    private static Collection<ProjectType> findProjectTypes(@NotNull Project project) {
        List<ProjectTypesProvider> providers;
        if (project == null) {
            ProjectTypeService.$$$reportNull$$$0(0);
        }
        if ((providers = ProjectTypesProvider.EP_NAME.getExtensionList()).isEmpty()) {
            return Collections.emptyList();
        }
        return ReadAction.compute(() -> {
            if (DumbService.isDumb(project)) {
                return Collections.emptyList();
            }
            return providers.stream().flatMap(p2 -> p2.inferProjectTypes(project).stream()).toList();
        });
    }

    public static void setProjectType(@NotNull Project project, @NotNull ProjectType projectType) {
        if (project == null) {
            ProjectTypeService.$$$reportNull$$$0(1);
        }
        if (projectType == null) {
            ProjectTypeService.$$$reportNull$$$0(2);
        }
        ProjectTypeService.getInstance(project).loadState(projectType);
    }

    private static ProjectTypeService getInstance(@NotNull Project project) {
        if (project == null) {
            ProjectTypeService.$$$reportNull$$$0(3);
        }
        return project.getService(ProjectTypeService.class);
    }

    @Override
    @Nullable
    public ProjectType getState() {
        return this.myProjectType;
    }

    @Override
    public void loadState(@NotNull ProjectType state) {
        if (state == null) {
            ProjectTypeService.$$$reportNull$$$0(4);
        }
        this.myProjectType = state;
    }

    @TestOnly
    public static void clearFieldsForLightProjectInTests(@NotNull Project project) {
        if (project == null) {
            ProjectTypeService.$$$reportNull$$$0(5);
        }
        ProjectTypeService.getInstance((Project)project).myProjectType = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/project/ProjectTypeService";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findProjectTypes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setProjectType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "clearFieldsForLightProjectInTests";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

