/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0001\u001a \u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0006\u001a2\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001H\u0007\u001a\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00a8\u0006\u0014"}, d2={"enableExternalStorageByDefaultInTests", "", "isExternalStorageEnabled", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Z", "appendModuleName", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "result", "moduleOnTheLeft", "decorateWithLibraryName", "displayUrlRelativeToProject", "url", "isIncludeFilePath", "doNotEnableExternalStorageByDefaultInTests", "", "action", "Lkotlin/Function0;", "intellij.platform.projectModel"})
@JvmName(name="ProjectUtilCore")
public final class ProjectUtilCore {
    private static boolean enableExternalStorageByDefaultInTests = true;

    @NlsSafe
    @NotNull
    public static final String displayUrlRelativeToProject(@NotNull VirtualFile file2, @NlsSafe @NotNull String url, @NotNull Project project, boolean isIncludeFilePath, boolean moduleOnTheLeft) {
        String urlWithLibraryName;
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(project, "project");
        String result2 = url;
        if (isIncludeFilePath) {
            Object object;
            String projectHomeUrl = PathUtil.toSystemDependentName(project.getBasePath());
            if (projectHomeUrl != null && StringsKt.startsWith$default(result2, projectHomeUrl, false, 2, null)) {
                String string2 = result2.substring(projectHomeUrl.length());
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                object = "\u2026" + string2;
            } else {
                String string3 = FileUtil.getLocationRelativeToUserHome(file2.getPresentableUrl());
                object = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "getLocationRelativeToUserHome(...)");
            }
            result2 = object;
        }
        if ((urlWithLibraryName = ProjectUtilCore.decorateWithLibraryName(file2, project, result2)) != null) {
            return urlWithLibraryName;
        }
        if (PlatformUtils.isCidr() || PlatformUtils.isRider()) {
            return result2;
        }
        return ProjectUtilCore.appendModuleName(file2, project, result2, moduleOnTheLeft);
    }

    @Nullable
    public static final String decorateWithLibraryName(@NotNull VirtualFile file2, @NotNull Project project, @NotNull String result2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(result2, "result");
        if (Intrinsics.areEqual(file2.getFileSystem().getProtocol(), "jar")) {
            OrderEntry libraryEntry = LibraryUtil.findLibraryEntry(file2, project);
            if (libraryEntry instanceof JdkOrderEntry) {
                return result2 + " [" + ((JdkOrderEntry)libraryEntry).getJdkName() + "]";
            }
            if (libraryEntry != null) {
                return result2 + " [" + libraryEntry.getPresentableName() + "]";
            }
        }
        return null;
    }

    @NotNull
    public static final String appendModuleName(@NotNull VirtualFile file2, @NotNull Project project, @NotNull String result2, boolean moduleOnTheLeft) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(result2, "result");
        Module module = ModuleUtilCore.findModuleForFile(file2, project);
        return module == null || ModuleManager.Companion.getInstance(project).getModules().length == 1 ? result2 : (moduleOnTheLeft ? "[" + module.getName() + "] " + result2 : result2 + " [" + module.getName() + "]");
    }

    public static final boolean isExternalStorageEnabled(@NotNull Project $this$isExternalStorageEnabled) {
        Intrinsics.checkNotNullParameter($this$isExternalStorageEnabled, "<this>");
        String string2 = $this$isExternalStorageEnabled.getProjectFilePath();
        boolean bl2 = string2 != null ? StringsKt.endsWith$default(string2, ".ipr", false, 2, null) : false;
        if (bl2) {
            return false;
        }
        ExternalStorageConfigurationManager externalStorageConfigurationManager = ExternalStorageConfigurationManager.getInstance($this$isExternalStorageEnabled);
        if (externalStorageConfigurationManager == null) {
            return false;
        }
        ExternalStorageConfigurationManager manager = externalStorageConfigurationManager;
        if (manager.isEnabled()) {
            return true;
        }
        Application application = ApplicationManager.getApplication();
        boolean testMode = application != null ? application.isUnitTestMode() : false;
        return testMode && enableExternalStorageByDefaultInTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static final void doNotEnableExternalStorageByDefaultInTests(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, "action");
        enableExternalStorageByDefaultInTests = false;
        try {
            action2.invoke();
        }
        finally {
            enableExternalStorageByDefaultInTests = true;
        }
    }
}

