/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.roots.PersistentOrderRootType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OrderRootType {
    private final String myName;
    private static boolean ourExtensionsLoaded;
    public static final ExtensionPointName<OrderRootType> EP_NAME;
    static PersistentOrderRootType @NotNull [] ourPersistentOrderRootTypes;
    public static final OrderRootType CLASSES;
    public static final OrderRootType SOURCES;
    public static final OrderRootType DOCUMENTATION;

    protected OrderRootType(@NotNull String name2) {
        if (name2 == null) {
            OrderRootType.$$$reportNull$$$0(0);
        }
        this.myName = name2;
    }

    @NotNull
    public String name() {
        String string2 = this.myName;
        if (string2 == null) {
            OrderRootType.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public boolean skipWriteIfEmpty() {
        return false;
    }

    public static synchronized OrderRootType @NotNull [] getAllTypes() {
        return OrderRootType.getAllPersistentTypes();
    }

    public static PersistentOrderRootType @NotNull [] getAllPersistentTypes() {
        if (!ourExtensionsLoaded) {
            ourExtensionsLoaded = true;
            EP_NAME.getExtensionList();
        }
        if (ourPersistentOrderRootTypes == null) {
            OrderRootType.$$$reportNull$$$0(2);
        }
        return ourPersistentOrderRootTypes;
    }

    @NotNull
    public static List<PersistentOrderRootType> getSortedRootTypes() {
        ArrayList<PersistentOrderRootType> allTypes = new ArrayList<PersistentOrderRootType>();
        Collections.addAll(allTypes, OrderRootType.getAllPersistentTypes());
        allTypes.sort((o1, o2) -> o1.name().compareToIgnoreCase(o2.name()));
        ArrayList<PersistentOrderRootType> arrayList = allTypes;
        if (arrayList == null) {
            OrderRootType.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    protected static <T> T getOrderRootType(@NotNull Class<? extends T> orderRootTypeClass) {
        if (orderRootTypeClass == null) {
            OrderRootType.$$$reportNull$$$0(4);
        }
        List<OrderRootType> rootTypes2 = EP_NAME.getExtensionList();
        for (OrderRootType rootType : rootTypes2) {
            OrderRootType t2;
            if (!orderRootTypeClass.isInstance(rootType)) continue;
            OrderRootType orderRootType = t2 = rootType;
            if (orderRootType == null) {
                OrderRootType.$$$reportNull$$$0(5);
            }
            return (T)orderRootType;
        }
        assert (false) : "Root type " + orderRootTypeClass + " not found. All roots: " + rootTypes2;
        if (null == null) {
            OrderRootType.$$$reportNull$$$0(6);
        }
        return null;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        return "Root " + this.name();
    }

    static {
        EP_NAME = ExtensionPointName.create("com.intellij.orderRootType");
        ourPersistentOrderRootTypes = new PersistentOrderRootType[0];
        CLASSES = new PersistentOrderRootType("CLASSES", "classPath", null, "classPathEntry");
        SOURCES = new PersistentOrderRootType("SOURCES", "sourcePath", null, "sourcePathEntry");
        DOCUMENTATION = new DocumentationRootType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1, 2, 3, 5, 6 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/OrderRootType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderRootTypeClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/OrderRootType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPersistentTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedRootTypes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderRootType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrderRootType";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 5, 6 -> new IllegalStateException(string2);
        };
    }

    public static class DocumentationRootType
    extends OrderRootType {
        public DocumentationRootType() {
            super("DOCUMENTATION");
        }

        @Override
        public boolean skipWriteIfEmpty() {
            return true;
        }
    }
}

