/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class NullableLazyKey<T, H extends UserDataHolder>
extends Key<T> {
    private final NullableFunction<? super H, ? extends T> myFunction;

    private NullableLazyKey(@NonNls String name2, NullableFunction<? super H, ? extends T> function) {
        super(name2);
        this.myFunction = function;
    }

    @Nullable
    public T getValue(H h2) {
        Object data = h2.getUserData(this);
        if (data == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            data = this.myFunction.fun(h2);
            if (stamp.mayCacheNow()) {
                h2.putUserData(this, (Object)(data == null ? ObjectUtils.NULL : data));
            }
        }
        return data == ObjectUtils.NULL ? null : (T)data;
    }

    public static <T, H extends UserDataHolder> NullableLazyKey<T, H> create(@NonNls String name2, NullableFunction<? super H, ? extends T> function) {
        return new NullableLazyKey<T, H>(name2, function);
    }
}

