/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.util.xml.dom.StaxFactory;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.stream.XMLStreamException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.codehaus.stax2.XMLStreamReader2;
import org.jdom.Attribute;
import org.jdom.AttributeList;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0012"}, d2={"buildJdom", "Lorg/jdom/Element;", "stream", "Lorg/codehaus/stax2/XMLStreamReader2;", "isNsSupported", "", "buildJdomDocument", "Lorg/jdom/Document;", "buildNsUnawareJdom", "reader", "Ljava/io/Reader;", "file", "Ljava/nio/file/Path;", "data", "", "buildNsUnawareJdomAndClose", "processElement", "processElementFragment", "intellij.platform.util"})
@ApiStatus.Internal
public final class SafeStAXStreamBuilderKt {
    @NotNull
    public static final Document buildJdomDocument(@NotNull XMLStreamReader2 stream) throws XMLStreamException {
        Intrinsics.checkNotNullParameter(stream, "stream");
        int state = stream.getEventType();
        if (7 != state) {
            throw new XMLStreamException("JDOM requires that XMLStreamReaders are at their beginning when being processed.");
        }
        Document document = new Document();
        while (state != 8) {
            switch (state) {
                case 7: {
                    document.setBaseURI(stream.getLocation().getSystemId());
                    document.setProperty("ENCODING_SCHEME", stream.getCharacterEncodingScheme());
                    document.setProperty("STANDALONE", String.valueOf(stream.isStandalone()));
                    document.setProperty("ENCODING", stream.getEncoding());
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 11: {
                    break;
                }
                case 1: {
                    document.setRootElement(SafeStAXStreamBuilderKt.processElementFragment(stream, true));
                    break;
                }
                case 4: {
                    String badTxt = stream.getText();
                    if (Verifier.isAllXMLWhitespace(badTxt)) break;
                    throw new XMLStreamException("Unexpected XMLStream event at Document level: CHARACTERS (" + badTxt + ')');
                }
                default: {
                    throw new XMLStreamException("Unexpected XMLStream event at Document level: " + state);
                }
            }
            if (stream.hasNext()) {
                state = stream.next();
                continue;
            }
            throw new XMLStreamException("Unexpected end-of-XMLStreamReader");
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Element buildNsUnawareJdom(@NotNull Reader reader) throws XMLStreamException {
        Intrinsics.checkNotNullParameter(reader, "reader");
        try (XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader(reader);){
            Element element = SafeStAXStreamBuilderKt.buildNsUnawareJdomAndClose(xmlStreamReader);
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Element buildNsUnawareJdom(@NotNull byte[] data) throws XMLStreamException {
        Intrinsics.checkNotNullParameter(data, "data");
        try (XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader(data);){
            Element element = SafeStAXStreamBuilderKt.buildNsUnawareJdomAndClose(xmlStreamReader);
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Element buildNsUnawareJdom(@NotNull Path file2) throws XMLStreamException {
        Intrinsics.checkNotNullParameter(file2, "file");
        InputStream inputStream = Files.newInputStream(file2, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
        try (XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader(inputStream);){
            Element element = SafeStAXStreamBuilderKt.buildNsUnawareJdomAndClose(xmlStreamReader);
            return element;
        }
    }

    @NotNull
    public static final Element buildNsUnawareJdomAndClose(@NotNull XMLStreamReader2 stream) throws XMLStreamException {
        Intrinsics.checkNotNullParameter(stream, "stream");
        return SafeStAXStreamBuilderKt.buildJdom(stream, false);
    }

    @NotNull
    public static final Element buildJdom(@NotNull XMLStreamReader2 stream, boolean isNsSupported) throws XMLStreamException {
        Intrinsics.checkNotNullParameter(stream, "stream");
        int state = stream.getEventType();
        if (state != 7) {
            throw new XMLStreamException("JDOM requires that XMLStreamReaders are at their beginning when being processed");
        }
        Element rootElement = null;
        while (state != 8) {
            switch (state) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 11: {
                    break;
                }
                case 1: {
                    rootElement = SafeStAXStreamBuilderKt.processElementFragment(stream, isNsSupported);
                    break;
                }
                default: {
                    throw new XMLStreamException("Unexpected XMLStream event " + state);
                }
            }
            if (stream.hasNext()) {
                state = stream.next();
                continue;
            }
            throw new XMLStreamException("Unexpected end-of-XMLStreamReader");
        }
        if (rootElement == null) {
            return new Element("empty");
        }
        return rootElement;
    }

    private static final Element processElementFragment(XMLStreamReader2 reader, boolean isNsSupported) throws XMLStreamException {
        Element fragment;
        Element current2 = fragment = SafeStAXStreamBuilderKt.processElement(reader, isNsSupported);
        int depth = 1;
        block8: while (depth > 0 && reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    Element tmp = SafeStAXStreamBuilderKt.processElement(reader, isNsSupported);
                    current2.addContent(tmp);
                    current2 = tmp;
                    ++depth;
                    continue block8;
                }
                case 2: {
                    if (current2.getParentElement() == null) {
                        return fragment;
                    }
                    --depth;
                    continue block8;
                }
                case 12: {
                    current2.addContent(new CDATA(reader.getText()));
                    continue block8;
                }
                case 6: {
                    continue block8;
                }
                case 4: {
                    if (reader.isWhiteSpace()) continue block8;
                    current2.addContent(new Text(reader.getText()));
                    continue block8;
                }
                case 3: 
                case 5: 
                case 9: {
                    continue block8;
                }
            }
            throw new XMLStreamException("Unexpected XMLStream event " + reader.getEventType(), reader.getLocation());
        }
        return fragment;
    }

    private static final Element processElement(XMLStreamReader2 reader, boolean isNsSupported) {
        Element element = new Element(reader.getLocalName(), isNsSupported ? Namespace.getNamespace(reader.getPrefix(), reader.getNamespaceURI()) : Namespace.NO_NAMESPACE);
        int attributeCount = reader.getAttributeCount();
        if (attributeCount != 0) {
            AttributeList list2 = element.initAttributeList(attributeCount);
            for (int i2 = 0; i2 < attributeCount; ++i2) {
                list2.doAdd(new Attribute(true, reader.getAttributeLocalName(i2), reader.getAttributeValue(i2), isNsSupported ? Namespace.getNamespace(reader.getAttributePrefix(i2), reader.getAttributeNamespace(i2)) : Namespace.NO_NAMESPACE));
            }
        }
        if (isNsSupported) {
            int len = reader.getNamespaceCount();
            for (int i3 = 0; i3 < len; ++i3) {
                element.addNamespaceDeclaration(Namespace.getNamespace(reader.getNamespacePrefix(i3), reader.getNamespaceURI(i3)));
            }
        }
        return element;
    }
}

