/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class TimeoutCachedValue<T>
implements Supplier<T> {
    private final long myTimeoutMs;
    @NotNull
    private final Supplier<? extends T> myValueSupplier;
    private long myLastCalcTime;
    private T myCache;

    /*
     * WARNING - void declaration
     */
    public TimeoutCachedValue(long timeout, @NotNull TimeUnit unit, @NotNull Supplier<? extends T> supplier) {
        void valueSupplier;
        if (unit == null) {
            TimeoutCachedValue.$$$reportNull$$$0(0);
        }
        if (supplier == null) {
            TimeoutCachedValue.$$$reportNull$$$0(1);
        }
        this.myValueSupplier = valueSupplier;
        this.myTimeoutMs = unit.toMillis(timeout);
    }

    @Override
    public synchronized T get() {
        if (this.hasUpToDateValue()) {
            return this.myCache;
        }
        this.myCache = this.myValueSupplier.get();
        this.myLastCalcTime = System.currentTimeMillis();
        return this.myCache;
    }

    public synchronized boolean hasUpToDateValue() {
        return this.myTimeoutMs > System.currentTimeMillis() - this.myLastCalcTime;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "unit";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "valueSupplier";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/util/TimeoutCachedValue";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

