/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.Pluralizer;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Strings {
    private static final List<String> REPLACES_REFS = Arrays.asList("&lt;", "&gt;", "&amp;", "&#39;", "&quot;");
    private static final List<String> REPLACES_DISP = Arrays.asList("<", ">", "&", "'", "\"");
    public static final CharSequence EMPTY_CHAR_SEQUENCE = new CharArrayCharSequence(ArrayUtilRt.EMPTY_CHAR_ARRAY);

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    @Contract(pure=true)
    public static boolean isDecimalDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    @Contract(value="null -> false")
    public static boolean isNotNegativeNumber(@Nullable CharSequence s2) {
        if (s2 == null) {
            return false;
        }
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (Strings.isDecimalDigit(s2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int compare(char c1, char c2, boolean ignoreCase) {
        char u2;
        int d2 = c1 - c2;
        if (d2 == 0 || !ignoreCase) {
            return d2;
        }
        char u1 = StringUtilRt.toUpperCase(c1);
        d2 = u1 - (u2 = StringUtilRt.toUpperCase(c2));
        if (d2 != 0) {
            d2 = StringUtilRt.toLowerCase(u1) - StringUtilRt.toLowerCase(u2);
        }
        return d2;
    }

    @Contract(pure=true)
    public static int compare(@Nullable CharSequence s1, @Nullable CharSequence s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        int length1 = s1.length();
        int length2 = s2.length();
        for (int i2 = 0; i2 < length1 && i2 < length2; ++i2) {
            int diff = Strings.compare(s1.charAt(i2), s2.charAt(i2), ignoreCase);
            if (diff == 0) continue;
            return diff;
        }
        return length1 - length2;
    }

    @Contract(pure=true)
    public static boolean charsMatch(char c1, char c2, boolean ignoreCase) {
        return Strings.compare(c1, c2, ignoreCase) == 0;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toLowerCase(@Nullable String str) {
        return str == null ? null : str.toLowerCase(Locale.ENGLISH);
    }

    @Contract(pure=true)
    public static char toLowerCase(char a2) {
        return StringUtilRt.toLowerCase(a2);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toUpperCase(String s2) {
        return s2 == null ? null : s2.toUpperCase(Locale.ENGLISH);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a2) {
        return StringUtilRt.toUpperCase(a2);
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        if (sequence == null) {
            Strings.$$$reportNull$$$0(0);
        }
        if (infix == null) {
            Strings.$$$reportNull$$$0(1);
        }
        return Strings.indexOf(sequence, infix) >= 0;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence s2, int start, int end, char c2) {
        if (s2 == null) {
            Strings.$$$reportNull$$$0(2);
        }
        return Strings.indexOf(s2, c2, start, end) >= 0;
    }

    @Contract(pure=true)
    public static boolean containsChar(@NotNull String value, char ch) {
        if (value == null) {
            Strings.$$$reportNull$$$0(3);
        }
        return value.indexOf(ch) >= 0;
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars) {
        if (value == null) {
            Strings.$$$reportNull$$$0(4);
        }
        if (chars == null) {
            Strings.$$$reportNull$$$0(5);
        }
        return chars.length() > value.length() ? Strings.containsAnyChar(value, chars, 0, value.length()) : Strings.containsAnyChar(chars, value, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars, int start, int end) {
        if (value == null) {
            Strings.$$$reportNull$$$0(6);
        }
        if (chars == null) {
            Strings.$$$reportNull$$$0(7);
        }
        for (int i2 = start; i2 < end; ++i2) {
            if (chars.indexOf(value.charAt(i2)) < 0) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s2, char c2) {
        if (s2 == null) {
            Strings.$$$reportNull$$$0(8);
        }
        return Strings.indexOf(s2, c2, 0, s2.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s2, char c2, int start) {
        if (s2 == null) {
            Strings.$$$reportNull$$$0(9);
        }
        return Strings.indexOf(s2, c2, start, s2.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s2, char c2, int start, int end) {
        if (s2 == null) {
            Strings.$$$reportNull$$$0(10);
        }
        end = Math.min(end, s2.length());
        for (int i2 = Math.max(start, 0); i2 < end; ++i2) {
            if (s2.charAt(i2) != c2) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        if (sequence == null) {
            Strings.$$$reportNull$$$0(11);
        }
        if (infix == null) {
            Strings.$$$reportNull$$$0(12);
        }
        return Strings.indexOf(sequence, infix, 0);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start) {
        if (sequence == null) {
            Strings.$$$reportNull$$$0(13);
        }
        if (infix == null) {
            Strings.$$$reportNull$$$0(14);
        }
        return Strings.indexOf(sequence, infix, start, sequence.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start, int end) {
        if (sequence == null) {
            Strings.$$$reportNull$$$0(15);
        }
        if (infix == null) {
            Strings.$$$reportNull$$$0(16);
        }
        for (int i2 = start; i2 <= end - infix.length(); ++i2) {
            if (!Strings.startsWith(sequence, i2, infix)) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s2, char c2, int start, int end, boolean caseSensitive) {
        if (s2 == null) {
            Strings.$$$reportNull$$$0(17);
        }
        end = Math.min(end, s2.length());
        for (int i2 = Math.max(start, 0); i2 < end; ++i2) {
            if (!Strings.charsMatch(s2.charAt(i2), c2, !caseSensitive)) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(char @NotNull [] s2, char c2, int start, int end, boolean caseSensitive) {
        if (s2 == null) {
            Strings.$$$reportNull$$$0(18);
        }
        end = Math.min(end, s2.length);
        for (int i2 = Math.max(start, 0); i2 < end; ++i2) {
            boolean ignoreCase;
            boolean bl2 = ignoreCase = !caseSensitive;
            if (!Strings.charsMatch(s2[i2], c2, ignoreCase)) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s2, @NotNull String chars) {
        if (s2 == null) {
            Strings.$$$reportNull$$$0(19);
        }
        if (chars == null) {
            Strings.$$$reportNull$$$0(20);
        }
        return Strings.indexOfAny(s2, chars, 0, s2.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s2, @NotNull String chars) {
        if (s2 == null) {
            Strings.$$$reportNull$$$0(21);
        }
        if (chars == null) {
            Strings.$$$reportNull$$$0(22);
        }
        return Strings.indexOfAny(s2, chars, 0, s2.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s2, @NotNull String chars, int start, int end) {
        if (s2 == null) {
            Strings.$$$reportNull$$$0(23);
        }
        if (chars == null) {
            Strings.$$$reportNull$$$0(24);
        }
        return Strings.indexOfAny((CharSequence)s2, chars, start, end);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s2, @NotNull String chars, int start, int end) {
        if (s2 == null) {
            Strings.$$$reportNull$$$0(25);
        }
        if (chars == null) {
            Strings.$$$reportNull$$$0(26);
        }
        if (chars.isEmpty()) {
            return -1;
        }
        end = Math.min(end, s2.length());
        for (int i2 = Math.max(start, 0); i2 < end; ++i2) {
            if (!Strings.containsChar(chars, s2.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        if (where == null) {
            Strings.$$$reportNull$$$0(27);
        }
        if (what == null) {
            Strings.$$$reportNull$$$0(28);
        }
        return Strings.indexOfIgnoreCase((CharSequence)where, (CharSequence)what, fromIndex);
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull CharSequence where, @NotNull CharSequence what, int fromIndex) {
        if (where == null) {
            Strings.$$$reportNull$$$0(29);
        }
        if (what == null) {
            Strings.$$$reportNull$$$0(30);
        }
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first2 = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i2 = fromIndex; i2 <= max; ++i2) {
            if (!Strings.charsEqualIgnoreCase(where.charAt(i2), first2)) {
                while (++i2 <= max && !Strings.charsEqualIgnoreCase(where.charAt(i2), first2)) {
                }
            }
            if (i2 > max) continue;
            int j2 = i2 + 1;
            int end = j2 + targetCount - 1;
            int k2 = 1;
            while (j2 < end && Strings.charsEqualIgnoreCase(where.charAt(j2), what.charAt(k2))) {
                ++j2;
                ++k2;
            }
            if (j2 != end) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        if (where == null) {
            Strings.$$$reportNull$$$0(31);
        }
        int sourceCount = where.length();
        for (int i2 = Math.max(fromIndex, 0); i2 < sourceCount; ++i2) {
            if (!Strings.charsEqualIgnoreCase(where.charAt(i2), what)) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a2, char b2) {
        return Strings.charsMatch(a2, b2, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalize(@NotNull String s2) {
        if (s2 == null) {
            Strings.$$$reportNull$$$0(32);
        }
        if (s2.isEmpty()) {
            String string2 = s2;
            if (string2 == null) {
                Strings.$$$reportNull$$$0(33);
            }
            return string2;
        }
        if (s2.length() == 1) {
            String string3 = Strings.toUpperCase(s2);
            if (string3 == null) {
                Strings.$$$reportNull$$$0(34);
            }
            return string3;
        }
        if (Character.isUpperCase(s2.charAt(0))) {
            String string4 = s2;
            if (string4 == null) {
                Strings.$$$reportNull$$$0(35);
            }
            return string4;
        }
        String string5 = Strings.toUpperCase(s2.charAt(0)) + s2.substring(1);
        if (string5 == null) {
            Strings.$$$reportNull$$$0(36);
        }
        return string5;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isCapitalized(@Nullable String s2) {
        return s2 != null && !s2.isEmpty() && Character.isUpperCase(s2.charAt(0));
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, int startIndex, @NotNull CharSequence prefix) {
        if (text == null) {
            Strings.$$$reportNull$$$0(37);
        }
        if (prefix == null) {
            Strings.$$$reportNull$$$0(38);
        }
        int tl = text.length();
        if (startIndex < 0 || startIndex > tl) {
            throw new IllegalArgumentException("Index is out of bounds: " + startIndex + ", length: " + tl);
        }
        int l1 = tl - startIndex;
        int l2 = prefix.length();
        if (l1 < l2) {
            return false;
        }
        for (int i2 = 0; i2 < l2; ++i2) {
            if (text.charAt(i2 + startIndex) == prefix.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        if (text == null) {
            Strings.$$$reportNull$$$0(39);
        }
        if (suffix == null) {
            Strings.$$$reportNull$$$0(40);
        }
        return StringUtilRt.endsWith(text, suffix);
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s2, char suffix) {
        return StringUtilRt.endsWithChar(s2, suffix);
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NotNull CharSequence str, @NotNull String suffix) {
        if (str == null) {
            Strings.$$$reportNull$$$0(41);
        }
        if (suffix == null) {
            Strings.$$$reportNull$$$0(42);
        }
        return StringUtilRt.endsWithIgnoreCase(str, suffix);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s2) {
        return !Strings.isEmpty(s2);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s2) {
        return s2 == null || s2.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return StringUtilRt.isEmpty(cs);
    }

    @Contract(pure=true)
    @NotNull
    public static String pluralize(@NotNull String word) {
        String plural;
        if (word == null) {
            Strings.$$$reportNull$$$0(43);
        }
        if ((plural = Pluralizer.PLURALIZER.plural(word)) != null) {
            String string2 = plural;
            if (string2 == null) {
                Strings.$$$reportNull$$$0(44);
            }
            return string2;
        }
        if (word.endsWith("s")) {
            String string3 = Pluralizer.restoreCase(word, word + "es");
            if (string3 == null) {
                Strings.$$$reportNull$$$0(45);
            }
            return string3;
        }
        String string4 = Pluralizer.restoreCase(word, word + "s");
        if (string4 == null) {
            Strings.$$$reportNull$$$0(46);
        }
        return string4;
    }

    @Contract(pure=true)
    @Nullable
    public static String unpluralize(@NotNull String word) {
        String singular;
        if (word == null) {
            Strings.$$$reportNull$$$0(47);
        }
        if ((singular = Pluralizer.PLURALIZER.singular(word)) != null) {
            return singular;
        }
        if (word.endsWith("es")) {
            return Strings.nullize(Strings.trimEnd(word, "es", true));
        }
        if (word.endsWith("s")) {
            return Strings.nullize(Strings.trimEnd(word, "s", true));
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s2) {
        String string2 = StringUtilRt.notNullize(s2);
        if (string2 == null) {
            Strings.$$$reportNull$$$0(48);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s2, @NotNull String defaultValue) {
        if (defaultValue == null) {
            Strings.$$$reportNull$$$0(49);
        }
        String string2 = StringUtilRt.notNullize(s2, defaultValue);
        if (string2 == null) {
            Strings.$$$reportNull$$$0(50);
        }
        return string2;
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s2) {
        return Strings.nullize(s2, false);
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s2, @Nullable String defaultValue) {
        boolean empty2 = Strings.isEmpty(s2) || Objects.equals(s2, defaultValue);
        return empty2 ? null : s2;
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s2, boolean nullizeSpaces) {
        boolean empty2 = nullizeSpaces ? Strings.isEmptyOrSpaces(s2) : Strings.isEmpty(s2);
        return empty2 ? null : s2;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s2) {
        return StringUtilRt.isEmptyOrSpaces(s2);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s2) {
        return s2 == null ? null : s2.trim();
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s2, @NotNull String suffix) {
        if (s2 == null) {
            Strings.$$$reportNull$$$0(51);
        }
        if (suffix == null) {
            Strings.$$$reportNull$$$0(52);
        }
        return Strings.trimEnd(s2, suffix, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s2, @NotNull String suffix, boolean ignoreCase) {
        boolean endsWith;
        if (s2 == null) {
            Strings.$$$reportNull$$$0(53);
        }
        if (suffix == null) {
            Strings.$$$reportNull$$$0(54);
        }
        boolean bl2 = endsWith = ignoreCase ? Strings.endsWithIgnoreCase(s2, suffix) : s2.endsWith(suffix);
        if (endsWith) {
            String string2 = s2.substring(0, s2.length() - suffix.length());
            if (string2 == null) {
                Strings.$$$reportNull$$$0(55);
            }
            return string2;
        }
        String string3 = s2;
        if (string3 == null) {
            Strings.$$$reportNull$$$0(56);
        }
        return string3;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s2, char suffix) {
        if (s2 == null) {
            Strings.$$$reportNull$$$0(57);
        }
        if (Strings.endsWithChar(s2, suffix)) {
            String string2 = s2.substring(0, s2.length() - 1);
            if (string2 == null) {
                Strings.$$$reportNull$$$0(58);
            }
            return string2;
        }
        String string3 = s2;
        if (string3 == null) {
            Strings.$$$reportNull$$$0(59);
        }
        return string3;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimStart(@NotNull String s2, @NotNull String prefix) {
        if (s2 == null) {
            Strings.$$$reportNull$$$0(60);
        }
        if (prefix == null) {
            Strings.$$$reportNull$$$0(61);
        }
        if (s2.startsWith(prefix)) {
            String string2 = s2.substring(prefix.length());
            if (string2 == null) {
                Strings.$$$reportNull$$$0(62);
            }
            return string2;
        }
        String string3 = s2;
        if (string3 == null) {
            Strings.$$$reportNull$$$0(63);
        }
        return string3;
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(64);
        }
        if (chars instanceof String || chars instanceof CharSequenceWithStringHash) {
            return chars.hashCode();
        }
        return Strings.stringHashCode(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from2, int to) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(65);
        }
        return Strings.stringHashCode(chars, from2, to, 0);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from2, int to, int prefixHash) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(66);
        }
        int h2 = prefixHash;
        for (int off = from2; off < to; ++off) {
            h2 = 31 * h2 + chars.charAt(off);
        }
        return h2;
    }

    @Contract(pure=true)
    public static int stringHashCode(char @NotNull [] chars, int from2, int to) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(67);
        }
        int h2 = 0;
        for (int off = from2; off < to; ++off) {
            h2 = 31 * h2 + chars[off];
        }
        return h2;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(char @NotNull [] chars, int from2, int to) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(68);
        }
        int h2 = 0;
        for (int off = from2; off < to; ++off) {
            h2 = 31 * h2 + Strings.toLowerCase(chars[off]);
        }
        return h2;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from2, int to) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(69);
        }
        return StringUtilRt.stringHashCodeInsensitive(chars, from2, to);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from2, int to, int prefixHash) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(70);
        }
        return StringUtilRt.stringHashCodeInsensitive(chars, from2, to, prefixHash);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(71);
        }
        return StringUtilRt.stringHashCodeInsensitive(chars);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c2) {
        if (text == null) {
            Strings.$$$reportNull$$$0(72);
        }
        return Strings.countChars(text, c2, 0, false);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c2, int offset, boolean stopAtOtherChar) {
        if (text == null) {
            Strings.$$$reportNull$$$0(73);
        }
        return Strings.countChars(text, c2, offset, text.length(), stopAtOtherChar);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c2, int start, int end, boolean stopAtOtherChar) {
        if (text == null) {
            Strings.$$$reportNull$$$0(74);
        }
        boolean forward = start <= end;
        start = forward ? Math.max(0, start) : Math.min(text.length(), start);
        end = forward ? Math.min(text.length(), end) : Math.max(0, end);
        int count2 = 0;
        int i2 = forward ? start : start - 1;
        while (forward == i2 < end) {
            if (text.charAt(i2) == c2) {
                ++count2;
            } else if (stopAtOtherChar) break;
            i2 += forward ? 1 : -1;
        }
        return count2;
    }

    @NotNull
    public static StringBuilder escapeToRegexp(@NotNull CharSequence text, @NotNull StringBuilder builder) {
        if (text == null) {
            Strings.$$$reportNull$$$0(75);
        }
        if (builder == null) {
            Strings.$$$reportNull$$$0(76);
        }
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c2 = text.charAt(i2);
            if (c2 == ' ' || Character.isLetter(c2) || Character.isDigit(c2) || c2 == '_') {
                builder.append(c2);
                continue;
            }
            if (c2 == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c2 == '\r') {
                builder.append("\\r");
                continue;
            }
            Character.UnicodeBlock block = Character.UnicodeBlock.of(c2);
            if (block == Character.UnicodeBlock.HIGH_SURROGATES || block == Character.UnicodeBlock.LOW_SURROGATES) {
                builder.append(c2);
                continue;
            }
            builder.append('\\').append(c2);
        }
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            Strings.$$$reportNull$$$0(77);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeXmlEntities(@NotNull String text) {
        if (text == null) {
            Strings.$$$reportNull$$$0(78);
        }
        return Strings.replace(text, REPLACES_REFS, REPLACES_DISP);
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeXmlEntities(@NotNull String text) {
        if (text == null) {
            Strings.$$$reportNull$$$0(79);
        }
        return Strings.replace(text, REPLACES_DISP, REPLACES_REFS);
    }

    @Contract(pure=true)
    @NotNull
    public static String replace(@NotNull String text, @NotNull List<String> from2, @NotNull List<String> to) {
        if (text == null) {
            Strings.$$$reportNull$$$0(80);
        }
        if (from2 == null) {
            Strings.$$$reportNull$$$0(81);
        }
        if (to == null) {
            Strings.$$$reportNull$$$0(82);
        }
        assert (from2.size() == to.size());
        StringBuilder result2 = null;
        block0: for (int i2 = 0; i2 < text.length(); ++i2) {
            for (int j2 = 0; j2 < from2.size(); ++j2) {
                String toReplace = from2.get(j2);
                String replaceWith = to.get(j2);
                int len = toReplace.length();
                if (len == 0 || !text.regionMatches(i2, toReplace, 0, len)) continue;
                if (result2 == null) {
                    result2 = new StringBuilder(text.length());
                    result2.append(text, 0, i2);
                }
                result2.append(replaceWith);
                i2 += len - 1;
                continue block0;
            }
            if (result2 == null) continue;
            result2.append(text.charAt(i2));
        }
        String string2 = result2 == null ? text : result2.toString();
        if (string2 == null) {
            Strings.$$$reportNull$$$0(83);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(T @NotNull [] items, @NotNull Function<? super T, String> f2, @NotNull String separator) {
        if (f2 == null) {
            Strings.$$$reportNull$$$0(84);
        }
        if (separator == null) {
            Strings.$$$reportNull$$$0(85);
        }
        if (items == null) {
            Strings.$$$reportNull$$$0(86);
        }
        return Strings.join(Arrays.asList(items), f2, separator);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(@NotNull Collection<? extends T> items, @NotNull Function<? super T, String> f2, @NotNull String separator) {
        if (items == null) {
            Strings.$$$reportNull$$$0(87);
        }
        if (f2 == null) {
            Strings.$$$reportNull$$$0(88);
        }
        if (separator == null) {
            Strings.$$$reportNull$$$0(89);
        }
        if (items.isEmpty()) {
            return "";
        }
        if (items.size() == 1) {
            return Strings.notNullize(f2.fun(items.iterator().next()));
        }
        return Strings.join(items, f2, separator);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(@NotNull Iterable<?> items, @NotNull String separator) {
        if (items == null) {
            Strings.$$$reportNull$$$0(90);
        }
        if (separator == null) {
            Strings.$$$reportNull$$$0(91);
        }
        StringBuilder result2 = new StringBuilder();
        for (Object item : items) {
            result2.append(item).append(separator);
        }
        if (result2.length() > 0) {
            result2.setLength(result2.length() - separator.length());
        }
        String string2 = result2.toString();
        if (string2 == null) {
            Strings.$$$reportNull$$$0(92);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, ? extends CharSequence> f2, @NotNull String separator) {
        if (items == null) {
            Strings.$$$reportNull$$$0(93);
        }
        if (f2 == null) {
            Strings.$$$reportNull$$$0(94);
        }
        if (separator == null) {
            Strings.$$$reportNull$$$0(95);
        }
        StringBuilder result2 = new StringBuilder();
        Strings.join(items, f2, separator, result2);
        String string2 = result2.toString();
        if (string2 == null) {
            Strings.$$$reportNull$$$0(96);
        }
        return string2;
    }

    public static <T> void join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, ? extends CharSequence> f2, @NotNull String separator, @NotNull StringBuilder result2) {
        if (items == null) {
            Strings.$$$reportNull$$$0(97);
        }
        if (f2 == null) {
            Strings.$$$reportNull$$$0(98);
        }
        if (separator == null) {
            Strings.$$$reportNull$$$0(99);
        }
        if (result2 == null) {
            Strings.$$$reportNull$$$0(100);
        }
        boolean isFirst = true;
        for (T item : items) {
            CharSequence string2 = f2.fun(item);
            if (Strings.isEmpty(string2)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(separator);
            }
            result2.append(string2);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String join(@NotNull Collection<String> strings2, @NotNull String separator) {
        if (strings2 == null) {
            Strings.$$$reportNull$$$0(101);
        }
        if (separator == null) {
            Strings.$$$reportNull$$$0(102);
        }
        if (strings2.size() <= 1) {
            return Strings.notNullize(strings2.isEmpty() ? null : strings2.iterator().next());
        }
        StringBuilder result2 = new StringBuilder();
        Strings.join(strings2, separator, result2);
        String string2 = result2.toString();
        if (string2 == null) {
            Strings.$$$reportNull$$$0(103);
        }
        return string2;
    }

    public static void join(@NotNull Collection<String> strings2, @NotNull String separator, @NotNull StringBuilder result2) {
        if (strings2 == null) {
            Strings.$$$reportNull$$$0(104);
        }
        if (separator == null) {
            Strings.$$$reportNull$$$0(105);
        }
        if (result2 == null) {
            Strings.$$$reportNull$$$0(106);
        }
        boolean isFirst = true;
        for (String string2 : strings2) {
            if (string2 == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(separator);
            }
            result2.append(string2);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String join(int @NotNull [] values2, @NotNull String separator) {
        if (separator == null) {
            Strings.$$$reportNull$$$0(107);
        }
        if (values2 == null) {
            Strings.$$$reportNull$$$0(108);
        }
        if (values2.length == 0) {
            return "";
        }
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < values2.length; ++i2) {
            if (i2 > 0) {
                result2.append(separator);
            }
            result2.append(values2[i2]);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            Strings.$$$reportNull$$$0(109);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String join(String ... strings2) {
        if (strings2 == null) {
            Strings.$$$reportNull$$$0(110);
        }
        if (strings2.length == 0) {
            return "";
        }
        if (strings2.length == 1) {
            String string2 = strings2[0];
            if (string2 == null) {
                Strings.$$$reportNull$$$0(111);
            }
            return string2;
        }
        StringBuilder builder = new StringBuilder();
        for (String string3 : strings2) {
            builder.append(string3);
        }
        String string4 = builder.toString();
        if (string4 == null) {
            Strings.$$$reportNull$$$0(112);
        }
        return string4;
    }

    @Contract(pure=true)
    public static boolean isWhiteSpace(char c2) {
        return c2 == '\n' || c2 == '\t' || c2 == ' ';
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars) {
        if (chars == null) {
            Strings.$$$reportNull$$$0(113);
        }
        int h2 = 0;
        for (int off = 0; off < chars.length(); ++off) {
            char c2 = chars.charAt(off);
            if (Strings.isWhiteSpace(c2)) continue;
            h2 = 31 * h2 + c2;
        }
        return h2;
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreWhitespaces(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        int index1 = 0;
        int index2 = 0;
        while (index1 < len1 && index2 < len2) {
            if (s1.charAt(index1) == s2.charAt(index2)) {
                ++index1;
                ++index2;
                continue;
            }
            boolean skipped = false;
            while (index1 != len1 && Strings.isWhiteSpace(s1.charAt(index1))) {
                skipped = true;
                ++index1;
            }
            while (index2 != len2 && Strings.isWhiteSpace(s2.charAt(index2))) {
                skipped = true;
                ++index2;
            }
            if (skipped) continue;
            return false;
        }
        while (index1 != len1) {
            if (!Strings.isWhiteSpace(s1.charAt(index1))) {
                return false;
            }
            ++index1;
        }
        while (index2 != len2) {
            if (!Strings.isWhiteSpace(s2.charAt(index2))) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsTrimWhitespaces(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        char c2;
        int start2;
        char c3;
        int start1;
        if (s1 == null) {
            Strings.$$$reportNull$$$0(114);
        }
        if (s2 == null) {
            Strings.$$$reportNull$$$0(115);
        }
        int end1 = s1.length();
        int end2 = s2.length();
        for (start1 = 0; start1 < end1 && Strings.isWhiteSpace(c3 = s1.charAt(start1)); ++start1) {
        }
        while (start1 < end1 && Strings.isWhiteSpace(c3 = s1.charAt(end1 - 1))) {
            --end1;
        }
        for (start2 = 0; start2 < end2 && Strings.isWhiteSpace(c2 = s2.charAt(start2)); ++start2) {
        }
        while (start2 < end2 && Strings.isWhiteSpace(c2 = s2.charAt(end2 - 1))) {
            --end2;
        }
        CharSequenceSubSequence ts1 = new CharSequenceSubSequence(s1, start1, end1);
        CharSequenceSubSequence ts2 = new CharSequenceSubSequence(s2, start2, end2);
        return StringUtilRt.equal(ts1, ts2, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String convertLineSeparators(@NotNull String text) {
        if (text == null) {
            Strings.$$$reportNull$$$0(116);
        }
        String string2 = StringUtilRt.convertLineSeparators(text);
        if (string2 == null) {
            Strings.$$$reportNull$$$0(117);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String convertLineSeparators(@NotNull String text, boolean keepCarriageReturn) {
        if (text == null) {
            Strings.$$$reportNull$$$0(118);
        }
        String string2 = StringUtilRt.convertLineSeparators(text, keepCarriageReturn);
        if (string2 == null) {
            Strings.$$$reportNull$$$0(119);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator) {
        if (text == null) {
            Strings.$$$reportNull$$$0(120);
        }
        if (newSeparator == null) {
            Strings.$$$reportNull$$$0(121);
        }
        String string2 = StringUtilRt.convertLineSeparators(text, newSeparator);
        if (string2 == null) {
            Strings.$$$reportNull$$$0(122);
        }
        return string2;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, int @Nullable [] offsetsToKeep) {
        if (text == null) {
            Strings.$$$reportNull$$$0(123);
        }
        if (newSeparator == null) {
            Strings.$$$reportNull$$$0(124);
        }
        String string2 = StringUtilRt.convertLineSeparators(text, newSeparator, offsetsToKeep);
        if (string2 == null) {
            Strings.$$$reportNull$$$0(125);
        }
        return string2;
    }

    public static boolean areSameInstance(@Nullable String s1, @Nullable String s2) {
        return s1 == s2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 77: 
            case 83: 
            case 92: 
            case 96: 
            case 103: 
            case 109: 
            case 111: 
            case 112: 
            case 117: 
            case 119: 
            case 122: 
            case 125: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 77: 
            case 83: 
            case 92: 
            case 96: 
            case 103: 
            case 109: 
            case 111: 
            case 112: 
            case 117: 
            case 119: 
            case 122: 
            case 125: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 1: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infix";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 32: 
            case 51: 
            case 53: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 7: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 77: 
            case 83: 
            case 92: 
            case 96: 
            case 103: 
            case 109: 
            case 111: 
            case 112: 
            case 117: 
            case 119: 
            case 122: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/Strings";
                break;
            }
            case 37: 
            case 39: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 78: 
            case 79: 
            case 80: 
            case 116: 
            case 118: 
            case 120: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 38: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 40: 
            case 42: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 84: 
            case 88: 
            case 94: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 85: 
            case 89: 
            case 91: 
            case 95: 
            case 99: 
            case 102: 
            case 105: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 86: 
            case 87: 
            case 90: 
            case 93: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 100: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 101: 
            case 104: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 121: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/Strings";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalize";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
            case 48: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 55: 
            case 56: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "trimEnd";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStart";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeToRegexp";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 92: 
            case 96: 
            case 103: 
            case 109: 
            case 111: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 117: 
            case 119: 
            case 122: 
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsChar";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyChar";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "indexOfAny";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIgnoreCase";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "capitalize";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 77: 
            case 83: 
            case 92: 
            case 96: 
            case 103: 
            case 109: 
            case 111: 
            case 112: 
            case 117: 
            case 119: 
            case 122: 
            case 125: {
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "unpluralize";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "trimEnd";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "trimStart";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCode";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeInsensitive";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "countChars";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "escapeToRegexp";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "unescapeXmlEntities";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "escapeXmlEntities";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeIgnoreWhitespaces";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "equalsTrimWhitespaces";
                break;
            }
            case 116: 
            case 118: 
            case 120: 
            case 121: 
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 63: 
            case 77: 
            case 83: 
            case 92: 
            case 96: 
            case 103: 
            case 109: 
            case 111: 
            case 112: 
            case 117: 
            case 119: 
            case 122: 
            case 125: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

