/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSetEx;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CompactVirtualFileSet
extends AbstractSet<VirtualFile>
implements VirtualFileSetEx {
    static final int BIT_SET_LIMIT = 1000;
    static final int INT_SET_LIMIT = 10;
    private final Set<VirtualFile> weirdFiles;
    private IntSet idSet;
    private BitSet fileIds;
    private boolean frozen;

    CompactVirtualFileSet() {
        this.weirdFiles = new HashSet<VirtualFile>();
    }

    @Deprecated
    @ApiStatus.Internal
    CompactVirtualFileSet(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(0);
        }
        this.weirdFiles = new HashSet<VirtualFile>();
        this.addAll(files2);
    }

    @Deprecated
    @ApiStatus.Internal
    public CompactVirtualFileSet(IntSet fileIds) {
        this.weirdFiles = new HashSet<VirtualFile>();
        this.idSet = fileIds;
        if (this.idSet.size() > 1000) {
            this.convertToBitSet();
        }
    }

    @Override
    @ApiStatus.Internal
    public boolean containsId(int fileId) {
        if (this.idSet != null) {
            return this.idSet.contains(fileId);
        }
        if (this.fileIds != null) {
            return this.fileIds.get(fileId);
        }
        for (VirtualFile file2 : this.weirdFiles) {
            if (!(file2 instanceof VirtualFileWithId) || ((VirtualFileWithId)((Object)file2)).getId() != fileId) continue;
            return true;
        }
        return false;
    }

    @Override
    @ApiStatus.Internal
    public int @NotNull [] onlyInternalFileIds() {
        if (this.idSet != null) {
            int[] nArray = this.idSet.toIntArray();
            if (nArray == null) {
                CompactVirtualFileSet.$$$reportNull$$$0(1);
            }
            return nArray;
        }
        if (this.fileIds != null) {
            int[] nArray = this.fileIds.stream().toArray();
            if (nArray == null) {
                CompactVirtualFileSet.$$$reportNull$$$0(2);
            }
            return nArray;
        }
        int[] nArray = this.weirdFiles.stream().filter(f2 -> f2 instanceof VirtualFileWithId).mapToInt(f2 -> ((VirtualFileWithId)((Object)f2)).getId()).toArray();
        if (nArray == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(3);
        }
        return nArray;
    }

    @Override
    public boolean contains(Object file2) {
        if (file2 instanceof VirtualFileWithId) {
            BitSet ids2 = this.fileIds;
            int id2 = ((VirtualFileWithId)file2).getId();
            if (ids2 != null) {
                return ids2.get(id2);
            }
            IntSet idSet = this.idSet;
            if (idSet != null) {
                return idSet.contains(id2);
            }
        }
        return this.weirdFiles.contains(file2);
    }

    @Override
    public boolean add(@NotNull VirtualFile file2) {
        boolean added;
        if (file2 == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(4);
        }
        if (this.frozen) {
            throw new UnsupportedOperationException();
        }
        if (file2 instanceof VirtualFileWithId) {
            int id2 = ((VirtualFileWithId)((Object)file2)).getId();
            BitSet ids2 = this.fileIds;
            IntSet idSet = this.idSet;
            if (ids2 != null) {
                added = !ids2.get(id2);
                ids2.set(id2);
            } else if (idSet != null) {
                added = idSet.add(id2);
                if (idSet.size() > 1000) {
                    this.convertToBitSet();
                }
            } else {
                added = this.weirdFiles.add(file2);
                if (this.weirdFiles.size() > 10) {
                    this.convertToIntSet();
                }
            }
        } else {
            added = this.weirdFiles.add(file2);
        }
        return added;
    }

    private void convertToIntSet() {
        IntOpenHashSet idSet = new IntOpenHashSet(this.weirdFiles.size());
        Iterator<VirtualFile> iterator2 = this.weirdFiles.iterator();
        while (iterator2.hasNext()) {
            VirtualFile wf = iterator2.next();
            if (!(wf instanceof VirtualFileWithId)) continue;
            idSet.add(((VirtualFileWithId)((Object)wf)).getId());
            iterator2.remove();
        }
        this.idSet = idSet;
    }

    private void convertToBitSet() {
        this.fileIds = new BitSet();
        IntIterator iterator2 = this.idSet.intIterator();
        while (iterator2.hasNext()) {
            this.fileIds.set(iterator2.nextInt());
        }
        this.idSet = null;
    }

    @Override
    public boolean remove(Object o2) {
        if (this.frozen) {
            throw new IllegalStateException();
        }
        if (this.weirdFiles.remove(o2)) {
            return true;
        }
        if (!(o2 instanceof VirtualFileWithId)) {
            return false;
        }
        int fileId = ((VirtualFileWithId)o2).getId();
        if (this.fileIds != null && this.fileIds.get(fileId)) {
            this.fileIds.clear(fileId);
            return true;
        }
        return this.idSet != null && this.idSet.remove(fileId);
    }

    @Override
    public void clear() {
        this.weirdFiles.clear();
        this.idSet = null;
        this.fileIds = null;
    }

    @Override
    public void freeze() {
        this.frozen = true;
    }

    @Override
    public Set<VirtualFile> freezed() {
        this.freeze();
        return this;
    }

    @Override
    public boolean process(@NotNull Processor<? super VirtualFile> processor) {
        IntSet idSet;
        if (processor == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(5);
        }
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        BitSet ids2 = this.fileIds;
        if (ids2 != null) {
            int id2 = ids2.nextSetBit(0);
            while (id2 < ids2.size() && id2 >= 0) {
                VirtualFile file2 = virtualFileManager.findFileById(id2);
                if (file2 != null && !processor.process(file2)) {
                    return false;
                }
                id2 = ids2.nextSetBit(id2 + 1);
            }
        }
        if ((idSet = this.idSet) != null) {
            IntIterator iterator2 = idSet.iterator();
            while (iterator2.hasNext()) {
                VirtualFile file3 = virtualFileManager.findFileById(iterator2.nextInt());
                if (file3 == null || processor.process(file3)) continue;
                return false;
            }
        }
        for (VirtualFile t2 : this.weirdFiles) {
            if (processor.process(t2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        BitSet ids2 = this.fileIds;
        IntSet idSet = this.idSet;
        return (ids2 == null ? 0 : ids2.cardinality()) + (idSet == null ? 0 : idSet.size()) + this.weirdFiles.size();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c2) {
        if (c2 == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(6);
        }
        if (this.frozen) {
            throw new IllegalStateException();
        }
        if (c2 instanceof CompactVirtualFileSet) {
            boolean modified = false;
            IntSet specifiedIdSet = ((CompactVirtualFileSet)c2).idSet;
            BitSet specifiedFileIds = ((CompactVirtualFileSet)c2).fileIds;
            Set<VirtualFile> specifiedWeirdFiles = ((CompactVirtualFileSet)c2).weirdFiles;
            if (this.idSet != null) {
                IntArrayList toRemove = new IntArrayList();
                IntIterator iterator2 = this.idSet.intIterator();
                while (iterator2.hasNext()) {
                    int id2 = iterator2.nextInt();
                    if (CompactVirtualFileSet.contains(id2, specifiedIdSet, specifiedFileIds, specifiedWeirdFiles)) continue;
                    toRemove.add(id2);
                    modified = true;
                }
                toRemove.forEach(i2 -> this.idSet.remove(i2));
            }
            if (this.fileIds != null) {
                for (Object id3 : (IntArrayList)this.fileIds.stream().toArray()) {
                    if (CompactVirtualFileSet.contains((int)id3, specifiedIdSet, specifiedFileIds, specifiedWeirdFiles)) continue;
                    this.fileIds.set((int)id3, false);
                    modified = true;
                }
            }
            Iterator<VirtualFile> it = this.weirdFiles.iterator();
            while (it.hasNext()) {
                VirtualFile file2 = it.next();
                if (c2.contains(file2)) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }
        return super.retainAll(c2);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends VirtualFile> c2) {
        if (c2 == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(7);
        }
        if (this.frozen) {
            throw new IllegalStateException();
        }
        if (c2 instanceof CompactVirtualFileSet) {
            IntIterator toAdd;
            boolean modified = false;
            CompactVirtualFileSet setToAdd = (CompactVirtualFileSet)c2;
            for (VirtualFile file2 : setToAdd.weirdFiles) {
                if (!this.add(file2)) continue;
                modified = true;
            }
            if (setToAdd.idSet != null) {
                toAdd = setToAdd.idSet.intIterator();
            } else if (setToAdd.fileIds != null) {
                toAdd = IntIterators.asIntIterator(setToAdd.fileIds.stream().iterator());
            } else {
                return modified;
            }
            while (toAdd.hasNext()) {
                int id2 = toAdd.nextInt();
                if (this.fileIds == null && this.idSet == null) {
                    this.convertToIntSet();
                }
                if (this.fileIds != null) {
                    modified = !this.fileIds.get(id2);
                    this.fileIds.set(id2);
                    continue;
                }
                if (this.idSet != null) {
                    modified = this.idSet.add(id2);
                    if (this.idSet.size() <= 1000) continue;
                    this.convertToBitSet();
                    continue;
                }
                throw new IllegalStateException();
            }
            return modified;
        }
        return super.addAll(c2);
    }

    @Override
    @NotNull
    public Iterator<VirtualFile> iterator() {
        Iterator totalIterator;
        Iterator<VirtualFile> fromIdsIterator;
        BitSet ids2 = this.fileIds;
        final IntSet idSet = this.idSet;
        final VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        if (ids2 == null) {
            fromIdsIterator = Collections.emptyIterator();
        } else {
            final BitSetIterator idIterator = new BitSetIterator(ids2);
            fromIdsIterator = new Iterator<VirtualFile>(){

                @Override
                public boolean hasNext() {
                    return idIterator.hasNext();
                }

                @Override
                public VirtualFile next() {
                    ProgressManager.checkCanceled();
                    return virtualFileManager.findFileById(idIterator.next());
                }

                @Override
                public void remove() {
                    idIterator.remove();
                }
            };
        }
        if (idSet == null) {
            totalIterator = ContainerUtil.concatIterators(fromIdsIterator, this.weirdFiles.iterator());
        } else {
            Iterator<VirtualFile> idSetIterator = new Iterator<VirtualFile>(){
                final IntIterator iterator;
                {
                    this.iterator = idSet.intIterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public VirtualFile next() {
                    ProgressManager.checkCanceled();
                    return virtualFileManager.findFileById(this.iterator.nextInt());
                }

                @Override
                public void remove() {
                    this.iterator.remove();
                }
            };
            totalIterator = ContainerUtil.concatIterators(fromIdsIterator, idSetIterator, this.weirdFiles.iterator());
        }
        return new Iterator<VirtualFile>(){
            VirtualFile next;
            Boolean hasNext;

            @Override
            public boolean hasNext() {
                this.findNext();
                return this.hasNext;
            }

            private void findNext() {
                if (this.hasNext == null) {
                    this.hasNext = false;
                    while (totalIterator.hasNext()) {
                        ProgressManager.checkCanceled();
                        VirtualFile t2 = (VirtualFile)totalIterator.next();
                        if (t2 == null) continue;
                        this.next = t2;
                        this.hasNext = true;
                        break;
                    }
                }
            }

            @Override
            public VirtualFile next() {
                this.findNext();
                if (!this.hasNext.booleanValue()) {
                    throw new NoSuchElementException();
                }
                VirtualFile result2 = this.next;
                this.hasNext = null;
                return result2;
            }

            @Override
            public void remove() {
                totalIterator.remove();
            }
        };
    }

    private static boolean contains(int id2, @Nullable IntSet idSet, @Nullable BitSet fileIds, @NotNull Set<? extends VirtualFile> weirdFiles) {
        if (weirdFiles == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(8);
        }
        if (idSet != null && idSet.contains(id2)) {
            return true;
        }
        if (fileIds != null && fileIds.get(id2)) {
            return true;
        }
        for (VirtualFile virtualFile : weirdFiles) {
            if (!(virtualFile instanceof VirtualFileWithId) || ((VirtualFileWithId)((Object)virtualFile)).getId() != id2) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/CompactVirtualFileSet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weirdFiles";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/CompactVirtualFileSet";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "onlyInternalFileIds";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BitSetIterator {
        @NotNull
        private final BitSet myBitSet;
        private int currentBit;
        private Boolean hasNext;

        private BitSetIterator(@NotNull BitSet set) {
            if (set == null) {
                BitSetIterator.$$$reportNull$$$0(0);
            }
            this.currentBit = -1;
            this.myBitSet = set;
        }

        public boolean hasNext() {
            this.findNext();
            return this.hasNext;
        }

        public int next() {
            this.findNext();
            if (!this.hasNext.booleanValue()) {
                throw new NoSuchElementException();
            }
            this.hasNext = null;
            return this.currentBit;
        }

        public void remove() {
            if (this.currentBit >= 0) {
                this.myBitSet.set(this.currentBit, false);
            }
        }

        private void findNext() {
            if (this.hasNext == null) {
                this.currentBit = this.myBitSet.nextSetBit(this.currentBit + 1);
                this.hasNext = this.currentBit != -1;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/openapi/vfs/CompactVirtualFileSet$BitSetIterator", "<init>"));
        }
    }
}

