/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.backend.workspace;

import com.intellij.platform.backend.workspace.StorageReplacement;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.instrumentation.MutableEntityStorageInstrumentation;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/backend/workspace/BuilderSnapshot;", "", "version", "", "storage", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "(JLcom/intellij/platform/workspace/storage/ImmutableEntityStorage;)V", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "getBuilder", "()Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "areEntitiesChanged", "", "getStorageReplacement", "Lcom/intellij/platform/backend/workspace/StorageReplacement;", "intellij.platform.backend.workspace"})
public final class BuilderSnapshot {
    private final long version;
    @NotNull
    private final ImmutableEntityStorage storage;
    @NotNull
    private final MutableEntityStorage builder;

    @ApiStatus.Internal
    public BuilderSnapshot(long version, @NotNull ImmutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter(storage, "storage");
        this.version = version;
        this.storage = storage;
        this.builder = MutableEntityStorage.Companion.from(this.storage);
    }

    @NotNull
    public final MutableEntityStorage getBuilder() {
        return this.builder;
    }

    public final boolean areEntitiesChanged() {
        MutableEntityStorage mutableEntityStorage = this.builder;
        Intrinsics.checkNotNull(mutableEntityStorage, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.instrumentation.MutableEntityStorageInstrumentation");
        return !((MutableEntityStorageInstrumentation)mutableEntityStorage).hasSameEntities();
    }

    @NotNull
    public final StorageReplacement getStorageReplacement() {
        MutableEntityStorage mutableEntityStorage = this.builder;
        Intrinsics.checkNotNull(mutableEntityStorage, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.instrumentation.MutableEntityStorageInstrumentation");
        Map<Class<?>, List<EntityChange<?>>> changes = ((MutableEntityStorageInstrumentation)mutableEntityStorage).collectChanges();
        return new StorageReplacement(this.version, this.builder, changes);
    }
}

