/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry;

import com.intellij.platform.diagnostic.telemetry.AggregatedMetricExporterKt;
import com.intellij.platform.diagnostic.telemetry.MetricsExporterEntry;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tJ\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/AggregatedMetricExporter;", "Lio/opentelemetry/sdk/metrics/export/MetricExporter;", "()V", "metricsExporters", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/platform/diagnostic/telemetry/MetricsExporterEntry;", "addMetricsExporters", "", "metrics", "", "export", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "", "Lio/opentelemetry/sdk/metrics/data/MetricData;", "flush", "getAggregationTemporality", "Lio/opentelemetry/sdk/metrics/data/AggregationTemporality;", "instrumentType", "Lio/opentelemetry/sdk/metrics/InstrumentType;", "shutdown", "intellij.platform.diagnostic.telemetry"})
@ApiStatus.Internal
public final class AggregatedMetricExporter
implements MetricExporter {
    @NotNull
    private final CopyOnWriteArrayList<MetricsExporterEntry> metricsExporters = new CopyOnWriteArrayList();

    public final void addMetricsExporters(@NotNull List<MetricsExporterEntry> metrics2) {
        Intrinsics.checkNotNullParameter(metrics2, "metrics");
        this.metricsExporters.addAll((Collection<MetricsExporterEntry>)metrics2);
    }

    @Override
    @NotNull
    public AggregationTemporality getAggregationTemporality(@NotNull InstrumentType instrumentType) {
        Intrinsics.checkNotNullParameter((Object)instrumentType, "instrumentType");
        return AggregationTemporality.DELTA;
    }

    @Override
    @NotNull
    public CompletableResultCode export(@NotNull Collection<MetricData> metrics2) {
        Intrinsics.checkNotNullParameter(metrics2, "metrics");
        if (this.metricsExporters.isEmpty()) {
            CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
            Intrinsics.checkNotNullExpressionValue(completableResultCode, "ofSuccess()");
            return completableResultCode;
        }
        List results = new ArrayList();
        for (MetricsExporterEntry entry : this.metricsExporters) {
            for (MetricExporter exporter : entry.getMetrics()) {
                try {
                    CompletableResultCode completableResultCode = exporter.export(metrics2);
                    Intrinsics.checkNotNullExpressionValue(completableResultCode, "exporter.export(metrics)");
                    results.add(completableResultCode);
                }
                catch (Throwable e2) {
                    CompletableResultCode completableResultCode = CompletableResultCode.ofFailure();
                    Intrinsics.checkNotNullExpressionValue(completableResultCode, "ofFailure()");
                    results.add(completableResultCode);
                    AggregatedMetricExporterKt.access$getLOG().info("Exporter " + exporter.getClass().getName() + " failed to export with: " + e2.getMessage());
                }
            }
        }
        CompletableResultCode completableResultCode = CompletableResultCode.ofAll(results);
        Intrinsics.checkNotNullExpressionValue(completableResultCode, "ofAll(results)");
        return completableResultCode;
    }

    @Override
    @NotNull
    public CompletableResultCode flush() {
        List results = new ArrayList();
        for (MetricsExporterEntry metricsExporterEntry : this.metricsExporters) {
            for (MetricExporter exporter : metricsExporterEntry.getMetrics()) {
                try {
                    CompletableResultCode completableResultCode = exporter.flush();
                    Intrinsics.checkNotNullExpressionValue(completableResultCode, "exporter.flush()");
                    results.add(completableResultCode);
                }
                catch (Throwable e2) {
                    CompletableResultCode completableResultCode = CompletableResultCode.ofFailure();
                    Intrinsics.checkNotNullExpressionValue(completableResultCode, "ofFailure()");
                    results.add(completableResultCode);
                    AggregatedMetricExporterKt.access$getLOG().info("Exporter " + exporter.getClass().getName() + " failed to flush with: " + e2.getMessage());
                }
            }
        }
        CompletableResultCode completableResultCode = CompletableResultCode.ofAll(results);
        Intrinsics.checkNotNullExpressionValue(completableResultCode, "ofAll(results)");
        return completableResultCode;
    }

    @Override
    @NotNull
    public CompletableResultCode shutdown() {
        List results = new ArrayList();
        for (MetricsExporterEntry metricsExporterEntry : this.metricsExporters) {
            for (MetricExporter exporter : metricsExporterEntry.getMetrics()) {
                try {
                    CompletableResultCode completableResultCode = exporter.shutdown();
                    Intrinsics.checkNotNullExpressionValue(completableResultCode, "exporter.shutdown()");
                    results.add(completableResultCode);
                }
                catch (Throwable e2) {
                    CompletableResultCode completableResultCode = CompletableResultCode.ofFailure();
                    Intrinsics.checkNotNullExpressionValue(completableResultCode, "ofFailure()");
                    results.add(completableResultCode);
                    AggregatedMetricExporterKt.access$getLOG().info("Exporter " + exporter.getClass().getName() + " failed to shutdown with: " + e2.getMessage());
                }
            }
        }
        CompletableResultCode completableResultCode = CompletableResultCode.ofAll(results);
        Intrinsics.checkNotNullExpressionValue(completableResultCode, "ofAll(results)");
        return completableResultCode;
    }
}

