/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.diagnostic.telemetry.MetricsImporterUtils;
import com.intellij.platform.diagnostic.telemetry.OpenTelemetryUtils;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\b2\u0006\u0010\t\u001a\u00020\nH\u0002J<\u0010\u0003\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\f\u0010\r\u001a\u00020\u000e*\u00020\u0005H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/MetricsImporterUtils;", "", "()V", "fromCsvFile", "Ljava/util/HashMap;", "", "", "Lio/opentelemetry/sdk/metrics/data/LongPointData;", "Lkotlin/collections/HashMap;", "metricsCsvPath", "Ljava/nio/file/Path;", "metricsCsvFiles", "", "isLongNumber", "", "intellij.platform.diagnostic.telemetry"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMetricsImporterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsImporterUtils.kt\ncom/intellij/platform/diagnostic/telemetry/MetricsImporterUtils\n+ 2 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,71:1\n52#2:72\n1#3:73\n11#4:74\n215#5,2:75\n*S KotlinDebug\n*F\n+ 1 MetricsImporterUtils.kt\ncom/intellij/platform/diagnostic/telemetry/MetricsImporterUtils\n*L\n31#1:72\n31#1:73\n50#1:74\n64#1:75,2\n*E\n"})
public final class MetricsImporterUtils {
    @NotNull
    public static final MetricsImporterUtils INSTANCE = new MetricsImporterUtils();

    private MetricsImporterUtils() {
    }

    private final boolean isLongNumber(String $this$isLongNumber) {
        boolean bl2;
        try {
            Long.parseLong($this$isLongNumber);
            bl2 = true;
        }
        catch (NumberFormatException e2) {
            bl2 = false;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HashMap<String, List<LongPointData>> fromCsvFile(Path metricsCsvPath) {
        HashMap<String, List<LongPointData>> meters = new HashMap<String, List<LongPointData>>();
        Path path = metricsCsvPath;
        Object object = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        int n2 = 8192;
        Reader $this$useLines$iv = new BufferedReader(new InputStreamReader(Files.newInputStream(path, Arrays.copyOf(object, ((OpenOption[])object).length)), charset), n2);
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        closeable = (BufferedReader)closeable;
        object = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl2 = false;
            Sequence<String> lines = TextStreamsKt.lineSequence(it$iv);
            boolean bl3 = false;
            Iterator<String> iterator2 = SequencesKt.drop(lines, OpenTelemetryUtils.INSTANCE.csvHeadersLines().size()).iterator();
            while (iterator2.hasNext()) {
                String line = iterator2.next();
                if (((CharSequence)((Object)StringsKt.trim((CharSequence)line)).toString()).length() == 0) continue;
                try {
                    LongPointData data;
                    List metrics2;
                    String[] stringArray = new String[]{","};
                    List list2 = StringsKt.split$default((CharSequence)line, stringArray, false, 0, 6, null);
                    String metricName = (String)list2.get(0);
                    String startEpochNanos = (String)list2.get(1);
                    String endEpochNanos = (String)list2.get(2);
                    String value = (String)list2.get(3);
                    if (!INSTANCE.isLongNumber(value)) continue;
                    Intrinsics.checkNotNullExpressionValue(ImmutableLongPointData.create(Long.parseLong(startEpochNanos), Long.parseLong(endEpochNanos), Attributes.empty(), Long.parseLong(value)), "create(startEpochNanos.t\u2026          value.toLong())");
                    Intrinsics.checkNotNullExpressionValue(meters.computeIfAbsent(metricName, arg_0 -> MetricsImporterUtils.fromCsvFile$lambda$1$lambda$0(fromCsvFile.1.metrics.1.INSTANCE, arg_0)), "meters.computeIfAbsent(m\u2026Name) { mutableListOf() }");
                    metrics2.add(data);
                }
                catch (Exception e2) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(MetricsImporterUtils.class);
                    Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
                    logger.error("Failure during parsing OpenTelemetry metrics from CSV file " + metricsCsvPath + " on line " + line);
                    throw e2;
                }
            }
            HashMap<String, List<LongPointData>> hashMap = meters;
            return hashMap;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally(closeable, (Throwable)object);
        }
    }

    @NotNull
    public final HashMap<String, List<LongPointData>> fromCsvFile(@NotNull Iterable<? extends Path> metricsCsvFiles) {
        Intrinsics.checkNotNullParameter(metricsCsvFiles, "metricsCsvFiles");
        HashMap<String, List<LongPointData>> meters = new HashMap<String, List<LongPointData>>();
        for (Path path : metricsCsvFiles) {
            HashMap<String, List<LongPointData>> currentMeters = this.fromCsvFile(path);
            Map $this$forEach$iv = currentMeters;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl2 = false;
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                meters.merge(key, value, (arg_0, arg_1) -> MetricsImporterUtils.fromCsvFile$lambda$3$lambda$2(fromCsvFile.2.1.INSTANCE, arg_0, arg_1));
            }
        }
        return meters;
    }

    private static final List fromCsvFile$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final List fromCsvFile$lambda$3$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (List)$tmp0.invoke(p0, p1);
    }
}

