/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileSetLimiter;
import com.intellij.util.SystemProperties;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0010J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/OpenTelemetryUtils;", "", "()V", "RDCT_CONN_METRICS_DIAGNOSTIC_FLAG", "", "RDCT_LUX_METRICS_DIAGNOSTIC_FLAG", "RDCT_TRACING_DIAGNOSTIC_FLAG", "concatToCsvLine", "name", "startEpochNanos", "", "endEpochNanos", "value", "csvHeadersLines", "", "generateFileForMetrics", "Ljava/nio/file/Path;", "metricsReportingBasePath", "metricsReportingPath", "setupFileLimiterForMetrics", "Lcom/intellij/openapi/util/io/FileSetLimiter;", "toCsvStream", "Lkotlin/sequences/Sequence;", "metricData", "Lio/opentelemetry/sdk/metrics/data/MetricData;", "intellij.platform.diagnostic.telemetry"})
@ApiStatus.Internal
public final class OpenTelemetryUtils {
    @NotNull
    public static final OpenTelemetryUtils INSTANCE = new OpenTelemetryUtils();
    @NotNull
    public static final String RDCT_TRACING_DIAGNOSTIC_FLAG = "rdct.diagnostic.otlp";
    @NotNull
    public static final String RDCT_CONN_METRICS_DIAGNOSTIC_FLAG = "rdct.connection.metrics.enabled";
    @NotNull
    public static final String RDCT_LUX_METRICS_DIAGNOSTIC_FLAG = "lux.metrics.enabled";

    private OpenTelemetryUtils() {
    }

    @NotNull
    public final Sequence<String> toCsvStream(@NotNull MetricData metricData) {
        Sequence<String> sequence;
        Intrinsics.checkNotNullParameter(metricData, "metricData");
        MetricDataType metricDataType = metricData.getType();
        switch (metricDataType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[metricDataType.ordinal()]) {
            case 1: {
                Collection collection = metricData.getLongSumData().getPoints();
                Intrinsics.checkNotNullExpressionValue(collection, "metricData.longSumData.points");
                sequence = SequencesKt.map(CollectionsKt.asSequence(collection), (Function1)new Function1<LongPointData, String>(metricData){
                    final /* synthetic */ MetricData $metricData;
                    {
                        this.$metricData = $metricData;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull LongPointData p2) {
                        Intrinsics.checkNotNullParameter(p2, "p");
                        String string2 = this.$metricData.getName();
                        Intrinsics.checkNotNullExpressionValue(string2, "metricData.name");
                        return OpenTelemetryUtils.access$concatToCsvLine(OpenTelemetryUtils.INSTANCE, string2, p2.getStartEpochNanos(), p2.getEpochNanos(), String.valueOf(p2.getValue()));
                    }
                });
                break;
            }
            case 2: {
                Collection collection = metricData.getDoubleSumData().getPoints();
                Intrinsics.checkNotNullExpressionValue(collection, "metricData.doubleSumData.points");
                sequence = SequencesKt.map(CollectionsKt.asSequence(collection), (Function1)new Function1<DoublePointData, String>(metricData){
                    final /* synthetic */ MetricData $metricData;
                    {
                        this.$metricData = $metricData;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull DoublePointData p2) {
                        Intrinsics.checkNotNullParameter(p2, "p");
                        String string2 = this.$metricData.getName();
                        Intrinsics.checkNotNullExpressionValue(string2, "metricData.name");
                        return OpenTelemetryUtils.access$concatToCsvLine(OpenTelemetryUtils.INSTANCE, string2, p2.getStartEpochNanos(), p2.getEpochNanos(), String.valueOf(p2.getValue()));
                    }
                });
                break;
            }
            case 3: {
                Collection collection = metricData.getLongGaugeData().getPoints();
                Intrinsics.checkNotNullExpressionValue(collection, "metricData.longGaugeData.points");
                sequence = SequencesKt.map(CollectionsKt.asSequence(collection), (Function1)new Function1<LongPointData, String>(metricData){
                    final /* synthetic */ MetricData $metricData;
                    {
                        this.$metricData = $metricData;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull LongPointData p2) {
                        Intrinsics.checkNotNullParameter(p2, "p");
                        String string2 = this.$metricData.getName();
                        Intrinsics.checkNotNullExpressionValue(string2, "metricData.name");
                        return OpenTelemetryUtils.access$concatToCsvLine(OpenTelemetryUtils.INSTANCE, string2, p2.getStartEpochNanos(), p2.getEpochNanos(), String.valueOf(p2.getValue()));
                    }
                });
                break;
            }
            case 4: {
                Collection collection = metricData.getDoubleGaugeData().getPoints();
                Intrinsics.checkNotNullExpressionValue(collection, "metricData.doubleGaugeData.points");
                sequence = SequencesKt.map(CollectionsKt.asSequence(collection), (Function1)new Function1<DoublePointData, String>(metricData){
                    final /* synthetic */ MetricData $metricData;
                    {
                        this.$metricData = $metricData;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull DoublePointData p2) {
                        Intrinsics.checkNotNullParameter(p2, "p");
                        String string2 = this.$metricData.getName();
                        Intrinsics.checkNotNullExpressionValue(string2, "metricData.name");
                        return OpenTelemetryUtils.access$concatToCsvLine(OpenTelemetryUtils.INSTANCE, string2, p2.getStartEpochNanos(), p2.getEpochNanos(), String.valueOf(p2.getValue()));
                    }
                });
                break;
            }
            default: {
                String[] stringArray = new String[1];
                String string2 = metricData.getName();
                Intrinsics.checkNotNullExpressionValue(string2, "metricData.name");
                stringArray[0] = this.concatToCsvLine(string2, -1L, -1L, "<metrics type " + (Object)((Object)metricData.getType()) + " is not supported yet>");
                sequence = SequencesKt.sequenceOf(stringArray);
            }
        }
        return sequence;
    }

    private final String concatToCsvLine(String name2, long startEpochNanos, long endEpochNanos, String value) {
        return name2 + ',' + startEpochNanos + ',' + endEpochNanos + ',' + value;
    }

    @NotNull
    public final List<String> csvHeadersLines() {
        String[] stringArray = new String[]{"# OpenTelemetry Metrics report: .csv, 4 fields: ", "# <metric name>, <period start, nanoseconds>, <period end, nanoseconds>, <metric value>", "# See CsvMetricsExporter for details.", "# ", "# NAME, PERIOD_START_NANOS, PERIOD_END_NANOS, VALUE"};
        return CollectionsKt.listOf(stringArray);
    }

    @Nullable
    public final Path metricsReportingPath() {
        String metricsReportingPath = System.getProperty("idea.diagnostic.opentelemetry.metrics.file", "open-telemetry-metrics.csv");
        Intrinsics.checkNotNullExpressionValue(metricsReportingPath, "metricsReportingPath");
        if (StringsKt.isBlank(metricsReportingPath)) {
            return null;
        }
        return PathManager.getLogDir().resolve(metricsReportingPath).toAbsolutePath();
    }

    @NotNull
    public final FileSetLimiter setupFileLimiterForMetrics(@NotNull Path metricsReportingBasePath) {
        Intrinsics.checkNotNullParameter(metricsReportingBasePath, "metricsReportingBasePath");
        String suffixDateFormat = System.getProperty("idea.diagnostic.opentelemetry.metrics.suffix-date-format", "yyyy-MM-dd-HH-mm-ss");
        FileSetLimiter fileSetLimiter = FileSetLimiter.inDirectory(metricsReportingBasePath.getParent()).withBaseNameAndDateFormatSuffix(((Object)metricsReportingBasePath.getFileName()).toString(), suffixDateFormat);
        Intrinsics.checkNotNullExpressionValue(fileSetLimiter, "inDirectory(metricsRepor\u2026ring(), suffixDateFormat)");
        return fileSetLimiter;
    }

    @NotNull
    public final Path generateFileForMetrics(@NotNull Path metricsReportingBasePath) {
        Intrinsics.checkNotNullParameter(metricsReportingBasePath, "metricsReportingBasePath");
        int maxFilesToKeep = SystemProperties.getIntProperty("idea.diagnostic.opentelemetry.metrics.max-files-to-keep", 14);
        FileSetLimiter fileLimiterForMetrics = this.setupFileLimiterForMetrics(metricsReportingBasePath);
        Path path = fileLimiterForMetrics.removeOldFilesBut(maxFilesToKeep, FileSetLimiter.DELETE_ASYNC).createNewFile();
        Intrinsics.checkNotNullExpressionValue(path, "fileLimiterForMetrics.re\u2026C)\n      .createNewFile()");
        return path;
    }

    public static final /* synthetic */ String access$concatToCsvLine(OpenTelemetryUtils $this, String name2, long startEpochNanos, long endEpochNanos, String value) {
        return $this.concatToCsvLine(name2, startEpochNanos, endEpochNanos, value);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MetricDataType.values().length];
            try {
                nArray[MetricDataType.LONG_SUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.DOUBLE_SUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.LONG_GAUGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.DOUBLE_GAUGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

