/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.helpers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.TracerLevel;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class SharedMetrics {
    public final Scope rootScopeName;
    public final IJTracer tracer;
    private final Map<String, Span> spans;
    private static final Logger LOG = Logger.getInstance(SharedMetrics.class);

    public SharedMetrics(@NotNull Scope scope) {
        if (scope == null) {
            SharedMetrics.$$$reportNull$$$0(0);
        }
        this.spans = new ConcurrentHashMap<String, Span>();
        this.rootScopeName = scope;
        this.tracer = TelemetryManager.Companion.getTracer(scope);
    }

    public Context getSpanContext(String spanName) {
        return Context.current().with(this.getOrStartSpan(spanName));
    }

    public Span getOrStartSpan(@NotNull String spanName) {
        if (spanName == null) {
            SharedMetrics.$$$reportNull$$$0(1);
        }
        return this.getOrStartSpan(spanName, (SpanBuilder builder) -> builder);
    }

    public Span getOrStartSpan(@NotNull String spanName, @NotNull String parentSpanName) {
        if (spanName == null) {
            SharedMetrics.$$$reportNull$$$0(2);
        }
        if (parentSpanName == null) {
            SharedMetrics.$$$reportNull$$$0(3);
        }
        this.getOrStartSpan(parentSpanName);
        return this.getOrStartSpan(spanName, (SpanBuilder builder) -> builder.setParent(this.getSpanContext(parentSpanName)));
    }

    public Span getOrStartSpan(@NotNull String spanName, Function<SpanBuilder, SpanBuilder> action2) {
        if (spanName == null) {
            SharedMetrics.$$$reportNull$$$0(4);
        }
        return this.spans.computeIfAbsent(spanName, name2 -> ((SpanBuilder)action2.apply(this.tracer.spanBuilder(spanName, TracerLevel.DEFAULT))).startSpan());
    }

    public Span startNewSpan(@NotNull String spanName, @NotNull String parentSpanName) {
        if (spanName == null) {
            SharedMetrics.$$$reportNull$$$0(5);
        }
        if (parentSpanName == null) {
            SharedMetrics.$$$reportNull$$$0(6);
        }
        this.getOrStartSpan(parentSpanName);
        return this.startNewSpan(spanName, (SpanBuilder builder) -> builder.setParent(this.getSpanContext(parentSpanName)));
    }

    public Span startNewSpan(@NotNull String spanName, Function<SpanBuilder, SpanBuilder> action2) {
        if (spanName == null) {
            SharedMetrics.$$$reportNull$$$0(7);
        }
        return this.spans.put(spanName, action2.apply(this.tracer.spanBuilder(spanName, TracerLevel.DEFAULT)).startSpan());
    }

    public void endSpan(@NotNull String spanName) {
        if (spanName == null) {
            SharedMetrics.$$$reportNull$$$0(8);
        }
        this.endSpan(spanName, span -> span);
    }

    public void endSpan(@NotNull String spanName, Function<Span, Span> action2) {
        Span span;
        if (spanName == null) {
            SharedMetrics.$$$reportNull$$$0(9);
        }
        if (!this.spans.containsKey(spanName)) {
            LOG.error(String.format("Span with name %s isn't started yet, but was called to stop", spanName));
        }
        if ((span = this.spans.get(spanName)) != null) {
            try {
                action2.apply(span).end();
            }
            catch (Exception e2) {
                LOG.error(String.format("Error while stopping span %s ", spanName), e2);
            }
        }
    }

    public Meter getMeter() {
        return TelemetryManager.getInstance().getMeter(this.rootScopeName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spanName";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSpanName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/diagnostic/telemetry/helpers/SharedMetrics";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrStartSpan";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "startNewSpan";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "endSpan";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

