/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.jps.model.serialization.resolver;

import com.intellij.platform.jps.model.resolver.JpsDependencyResolverConfiguration;
import com.intellij.platform.jps.model.resolver.JpsDependencyResolverConfigurationService;
import java.util.EnumMap;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;

public final class JpsDependencyResolverConfigurationSerializer
extends JpsProjectExtensionSerializer {
    private static final String CONFIG_FILE_NAME = "dependencyResolver.xml";
    private static final String COMPONENT_NAME = "MavenDependencyResolverConfiguration";
    private static final String OPTION_TAG = "option";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VALUE_ATTRIBUTE = "value";

    public JpsDependencyResolverConfigurationSerializer() {
        super(CONFIG_FILE_NAME, COMPONENT_NAME);
    }

    @Override
    public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
        if (project == null) {
            JpsDependencyResolverConfigurationSerializer.$$$reportNull$$$0(0);
        }
        if (componentTag == null) {
            JpsDependencyResolverConfigurationSerializer.$$$reportNull$$$0(1);
        }
        EnumMap<Options, Boolean> optionsValues = new EnumMap<Options, Boolean>(Options.class);
        List<Element> optionElements = componentTag.getChildren(OPTION_TAG);
        for (Element element : optionElements) {
            try {
                Options name2 = Options.valueOf(element.getAttributeValue(NAME_ATTRIBUTE));
                boolean value = Boolean.parseBoolean(element.getAttributeValue(VALUE_ATTRIBUTE));
                optionsValues.put(name2, value);
            }
            catch (Exception exception) {}
        }
        JpsDependencyResolverConfigurationService resolverConfigurationService = JpsDependencyResolverConfigurationService.getInstance();
        JpsDependencyResolverConfiguration config = resolverConfigurationService.getOrCreateDependencyResolverConfiguration(project);
        if (optionsValues.containsKey((Object)Options.VERIFY_SHA256_CHECKSUMS)) {
            config.setSha256ChecksumVerificationEnabled((Boolean)optionsValues.get((Object)Options.VERIFY_SHA256_CHECKSUMS));
        }
        if (optionsValues.containsKey((Object)Options.USE_BIND_REPOSITORY)) {
            config.setBindRepositoryEnabled((Boolean)optionsValues.get((Object)Options.USE_BIND_REPOSITORY));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "componentTag";
                break;
            }
        }
        objectArray[1] = "com/intellij/platform/jps/model/serialization/resolver/JpsDependencyResolverConfigurationSerializer";
        objectArray[2] = "loadExtension";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum Options {
        VERIFY_SHA256_CHECKSUMS,
        USE_BIND_REPOSITORY;

    }
}

