/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.progress.impl;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\n\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/util/progress/impl/StepConfig;", "", "isIndeterminate", "", "textLevel", "", "(ZI)V", "()Z", "getTextLevel", "()I", "childConfig", "indeterminate", "hasText", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "intellij.platform.util.progress"})
public final class StepConfig {
    private final boolean isIndeterminate;
    private final int textLevel;

    public StepConfig(boolean isIndeterminate, int textLevel) {
        this.isIndeterminate = isIndeterminate;
        this.textLevel = textLevel;
        int n2 = this.textLevel;
        if (!(0 <= n2 ? n2 < 3 : false)) {
            boolean $i$a$-require-StepConfig$32 = false;
            String $i$a$-require-StepConfig$32 = "Unsupported text level: " + this.textLevel;
            throw new IllegalArgumentException($i$a$-require-StepConfig$32.toString());
        }
        if (!(!this.isIndeterminate || this.textLevel > 0)) {
            boolean bl2 = false;
            String string2 = "This step is effectively no-op";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public final boolean isIndeterminate() {
        return this.isIndeterminate;
    }

    public final int getTextLevel() {
        return this.textLevel;
    }

    @Nullable
    public final StepConfig childConfig(boolean indeterminate, boolean hasText) {
        int childLevel;
        boolean childIndeterminate = indeterminate || this.isIndeterminate;
        int n2 = childLevel = hasText && this.textLevel > 0 ? this.textLevel - 1 : this.textLevel;
        if (childLevel == 0 && childIndeterminate) {
            return null;
        }
        return new StepConfig(childIndeterminate, childLevel);
    }

    public final boolean component1() {
        return this.isIndeterminate;
    }

    public final int component2() {
        return this.textLevel;
    }

    @NotNull
    public final StepConfig copy(boolean isIndeterminate, int textLevel) {
        return new StepConfig(isIndeterminate, textLevel);
    }

    public static /* synthetic */ StepConfig copy$default(StepConfig stepConfig, boolean bl2, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            bl2 = stepConfig.isIndeterminate;
        }
        if ((n3 & 2) != 0) {
            n2 = stepConfig.textLevel;
        }
        return stepConfig.copy(bl2, n2);
    }

    @NotNull
    public String toString() {
        return "StepConfig(isIndeterminate=" + this.isIndeterminate + ", textLevel=" + this.textLevel + ')';
    }

    public int hashCode() {
        int result2 = Boolean.hashCode(this.isIndeterminate);
        result2 = result2 * 31 + Integer.hashCode(this.textLevel);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StepConfig)) {
            return false;
        }
        StepConfig stepConfig = (StepConfig)other;
        if (this.isIndeterminate != stepConfig.isIndeterminate) {
            return false;
        }
        return this.textLevel == stepConfig.textLevel;
    }
}

