/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.entities.FacetEntity;
import com.intellij.platform.workspace.jps.entities.FacetId;
import com.intellij.platform.workspace.jps.entities.FacetKt;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.jps.serialization.impl.CustomFacetRelatedEntitySerializer;
import com.intellij.platform.workspace.storage.EntitySource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.facet.FacetState;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u0004\u0018\u00010\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J:\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00022\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J,\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00102\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020%0$H\u0016J<\u0010&\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010(\u001a\u0004\u0018\u00010\u00022\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020%0$H\u0002J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020*H\u0016J\u0010\u0010-\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006/"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/DefaultFacetEntitySerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/CustomFacetRelatedEntitySerializer;", "Lcom/intellij/platform/workspace/jps/entities/FacetEntity;", "()V", "configurationStringInterner", "Ljava/util/concurrent/ConcurrentHashMap;", "", "rootEntityType", "Ljava/lang/Class;", "getRootEntityType", "()Ljava/lang/Class;", "supportedFacetType", "getSupportedFacetType", "()Ljava/lang/String;", "createFacetStateFromEntities", "", "Lorg/jetbrains/jps/model/serialization/facet/FacetState;", "entities", "storeExternally", "", "findFacetById", "facets", "id", "Lcom/intellij/platform/workspace/jps/entities/FacetId;", "getOrCreateFacetState", "facetEntity", "existingFacetStates", "", "rootFacets", "", "loadEntitiesFromFacetState", "", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "facetState", "evaluateEntitySource", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/EntitySource;", "loadFacetEntities", "facetStates", "underlyingFacet", "serialize", "Lorg/jdom/Element;", "entity", "rootElement", "serializeIntoXml", "Companion", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nDefaultFacetEntitySerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultFacetEntitySerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/DefaultFacetEntitySerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1855#2:126\n1856#2:128\n1855#2,2:129\n1#3:127\n*S KotlinDebug\n*F\n+ 1 DefaultFacetEntitySerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/DefaultFacetEntitySerializer\n*L\n37#1:126\n37#1:128\n81#1:129,2\n*E\n"})
public final class DefaultFacetEntitySerializer
implements CustomFacetRelatedEntitySerializer<FacetEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, String> configurationStringInterner = new ConcurrentHashMap();
    @NotNull
    public static final String ALL_FACETS_TYPES_MARKER = "<all types of facets>";

    @Override
    @NotNull
    public Class<FacetEntity> getRootEntityType() {
        return FacetEntity.class;
    }

    @Override
    @NotNull
    public String getSupportedFacetType() {
        return ALL_FACETS_TYPES_MARKER;
    }

    @Override
    public void loadEntitiesFromFacetState(@NotNull ModuleEntity moduleEntity, @NotNull FacetState facetState, @NotNull Function1<? super FacetState, ? extends EntitySource> evaluateEntitySource) {
        Intrinsics.checkNotNullParameter(moduleEntity, "moduleEntity");
        Intrinsics.checkNotNullParameter(facetState, "facetState");
        Intrinsics.checkNotNullParameter(evaluateEntitySource, "evaluateEntitySource");
        this.loadFacetEntities(moduleEntity, CollectionsKt.listOf(facetState), null, evaluateEntitySource);
    }

    private final void loadFacetEntities(ModuleEntity moduleEntity, List<FacetState> facetStates, FacetEntity underlyingFacet, Function1<? super FacetState, ? extends EntitySource> evaluateEntitySource) {
        Iterable $this$forEach$iv = facetStates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string2;
            String configurationXmlTagRaw;
            String string3;
            Object it;
            FacetState facetState = (FacetState)element$iv;
            boolean bl2 = false;
            EntitySource entitySource = evaluateEntitySource.invoke(facetState);
            if (facetState.getConfiguration() != null) {
                boolean bl3 = false;
                string3 = JDOMUtil.write((Element)it);
            } else {
                string3 = configurationXmlTagRaw = null;
            }
            if (configurationXmlTagRaw != null) {
                boolean bl4 = false;
                string2 = this.configurationStringInterner.computeIfAbsent((String)it, Function.identity());
            } else {
                string2 = null;
            }
            String configurationXmlTag = string2;
            String string4 = facetState.getName();
            Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
            String string5 = facetState.getFacetType();
            Intrinsics.checkNotNullExpressionValue(string5, "getFacetType(...)");
            FacetId newFacetId = new FacetId(string4, string5, moduleEntity.getSymbolicId());
            FacetEntity facetEntity = null;
            FacetEntity existingFacet = this.findFacetById(moduleEntity.getFacets(), newFacetId);
            if (existingFacet != null && configurationXmlTag != null && existingFacet.getConfigurationXmlTag() == null) {
                FacetEntity.Builder builder;
                FacetEntity.Builder $this$loadFacetEntities_u24lambda_u243_u24lambda_u242 = builder = (FacetEntity.Builder)existingFacet;
                boolean bl5 = false;
                $this$loadFacetEntities_u24lambda_u243_u24lambda_u242.setEntitySource(entitySource);
                $this$loadFacetEntities_u24lambda_u243_u24lambda_u242.setConfigurationXmlTag(configurationXmlTag);
                facetEntity = existingFacet;
            }
            if (existingFacet == null) {
                String string6 = facetState.getName();
                Intrinsics.checkNotNullExpressionValue(string6, "getName(...)");
                ModuleId moduleId = moduleEntity.getSymbolicId();
                String string7 = facetState.getFacetType();
                Intrinsics.checkNotNullExpressionValue(string7, "getFacetType(...)");
                facetEntity = FacetEntity.Companion.create(string6, moduleId, string7, entitySource, (Function1<? super FacetEntity.Builder, Unit>)new Function1<FacetEntity.Builder, Unit>(configurationXmlTag, moduleEntity, underlyingFacet){
                    final /* synthetic */ String $configurationXmlTag;
                    final /* synthetic */ ModuleEntity $moduleEntity;
                    final /* synthetic */ FacetEntity $underlyingFacet;
                    {
                        this.$configurationXmlTag = $configurationXmlTag;
                        this.$moduleEntity = $moduleEntity;
                        this.$underlyingFacet = $underlyingFacet;
                        super(1);
                    }

                    public final void invoke(@NotNull FacetEntity.Builder $this$invoke) {
                        Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                        $this$invoke.setConfigurationXmlTag(this.$configurationXmlTag);
                        $this$invoke.setModule(this.$moduleEntity);
                        $this$invoke.setUnderlyingFacet(this.$underlyingFacet);
                    }
                });
            }
            List<FacetState> list2 = facetState.subFacets;
            Intrinsics.checkNotNullExpressionValue(list2, "subFacets");
            this.loadFacetEntities(moduleEntity, list2, facetEntity, evaluateEntitySource);
        }
    }

    private final FacetEntity findFacetById(List<? extends FacetEntity> facets, FacetId id2) {
        for (FacetEntity facetEntity : facets) {
            if (Intrinsics.areEqual(facetEntity.getSymbolicId(), id2)) {
                return facetEntity;
            }
            FacetEntity subs = this.findFacetById(FacetKt.getChildrenFacets(facetEntity), id2);
            if (subs == null) continue;
            return subs;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FacetState> createFacetStateFromEntities(@NotNull List<? extends FacetEntity> entities2, boolean storeExternally) {
        Intrinsics.checkNotNullParameter(entities2, "entities");
        HashMap existingFacetStates = new HashMap();
        ArrayList resultFacetStates = new ArrayList();
        Iterable $this$forEach$iv = entities2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element element;
            FacetState state;
            FacetEntity facetEntity = (FacetEntity)element$iv;
            boolean bl2 = false;
            FacetState facetState = state = this.getOrCreateFacetState(facetEntity, existingFacetStates, resultFacetStates, storeExternally);
            if (facetEntity.getConfigurationXmlTag() != null) {
                void it;
                FacetState facetState2 = facetState;
                boolean bl3 = false;
                element = JDOMUtil.load((CharSequence)it);
                facetState = facetState2;
            } else {
                element = null;
            }
            facetState.setConfiguration(element);
        }
        return resultFacetStates;
    }

    private final FacetState getOrCreateFacetState(FacetEntity facetEntity, Map<String, FacetState> existingFacetStates, List<FacetState> rootFacets, boolean storeExternally) {
        String externalSystemIdValue;
        FacetState existing;
        FacetState facetState = existing = existingFacetStates.get(facetEntity.getName());
        if (facetState != null) {
            return facetState;
        }
        Object object = new FacetState();
        FacetState $this$getOrCreateFacetState_u24lambda_u246 = object;
        boolean bl2 = false;
        $this$getOrCreateFacetState_u24lambda_u246.setName(facetEntity.getName());
        $this$getOrCreateFacetState_u24lambda_u246.setFacetType(facetEntity.getFacetType());
        EntitySource entitySource = facetEntity.getEntitySource();
        JpsImportedEntitySource jpsImportedEntitySource = entitySource instanceof JpsImportedEntitySource ? (JpsImportedEntitySource)entitySource : null;
        String string2 = externalSystemIdValue = jpsImportedEntitySource != null ? jpsImportedEntitySource.getExternalSystemId() : null;
        if (storeExternally) {
            $this$getOrCreateFacetState_u24lambda_u246.setExternalSystemId(externalSystemIdValue);
        } else {
            $this$getOrCreateFacetState_u24lambda_u246.setExternalSystemIdInInternalStorage(externalSystemIdValue);
        }
        FacetState state = object;
        object = existingFacetStates;
        String string3 = state.getName();
        Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
        object.put(string3, state);
        FacetEntity underlyingFacet = facetEntity.getUnderlyingFacet();
        if (underlyingFacet != null) {
            this.getOrCreateFacetState((FacetEntity)underlyingFacet, existingFacetStates, rootFacets, (boolean)storeExternally).subFacets.add(state);
        } else {
            rootFacets.add(state);
        }
        return state;
    }

    @Override
    @NotNull
    public Element serializeIntoXml(@NotNull FacetEntity entity) {
        Element element;
        Element element2;
        Intrinsics.checkNotNullParameter(entity, "entity");
        String string2 = entity.getConfigurationXmlTag();
        if (string2 != null) {
            String it = string2;
            boolean bl2 = false;
            element2 = JDOMUtil.load(it);
        } else {
            element2 = element = null;
        }
        if (element2 == null) {
            element = new Element("configuration");
        }
        return element;
    }

    @Override
    @NotNull
    public Element serialize(@NotNull FacetEntity entity, @NotNull Element rootElement) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(rootElement, "rootElement");
        throw new IllegalStateException("Unsupported operation".toString());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/DefaultFacetEntitySerializer$Companion;", "", "()V", "ALL_FACETS_TYPES_MARKER", "", "intellij.platform.workspace.jps"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

