/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.entities.FacetsOrderEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleSettingsBase;
import com.intellij.platform.workspace.jps.entities.OrdersKt;
import com.intellij.platform.workspace.jps.serialization.SerializationContext;
import com.intellij.platform.workspace.jps.serialization.impl.CustomFacetRelatedEntitySerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.facet.FacetManagerState;
import org.jetbrains.jps.model.serialization.facet.FacetState;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J,\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019H\u0002JU\u0010\u001a\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112 \u0010\u001b\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00160\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\n0\"H\u0000\u00a2\u0006\u0002\b$R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/FacetsSerializer;", "", "imlFileUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "internalSource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "componentName", "", "baseModuleDirPath", "externalStorage", "", "context", "Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;Ljava/lang/String;Ljava/lang/String;ZLcom/intellij/platform/workspace/jps/serialization/SerializationContext;)V", "loadFacetEntities", "", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "reader", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentReader;", "loadFacetEntities$intellij_platform_workspace_jps", "facetStates", "", "Lorg/jetbrains/jps/model/serialization/facet/FacetState;", "orderOfFacets", "", "saveFacetEntities", "affectedEntities", "", "Ljava/lang/Class;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "writer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "entitySourceFilter", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/EntitySource;", "saveFacetEntities$intellij_platform_workspace_jps", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nFacetsSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacetsSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/FacetsSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,103:1\n1194#2,2:104\n1222#2,4:106\n1603#2,9:110\n1855#2:119\n766#2:120\n857#2,2:121\n1549#2:123\n1620#2,3:124\n1856#2:128\n1612#2:129\n1502#2,3:130\n1505#2,3:140\n1855#2,2:143\n1#3:127\n372#4,7:133\n11#5:145\n*S KotlinDebug\n*F\n+ 1 FacetsSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/FacetsSerializer\n*L\n53#1:104,2\n53#1:106,4\n69#1:110,9\n69#1:119\n70#1:120\n70#1:121,2\n72#1:123\n72#1:124,3\n69#1:128\n69#1:129\n81#1:130,3\n81#1:140,3\n84#1:143,2\n69#1:127\n81#1:133,7\n94#1:145\n*E\n"})
public final class FacetsSerializer {
    @NotNull
    private final VirtualFileUrl imlFileUrl;
    @NotNull
    private final JpsFileEntitySource internalSource;
    @NotNull
    private final String componentName;
    @Nullable
    private final String baseModuleDirPath;
    private final boolean externalStorage;
    @NotNull
    private final SerializationContext context;

    public FacetsSerializer(@NotNull VirtualFileUrl imlFileUrl, @NotNull JpsFileEntitySource internalSource, @NotNull String componentName, @Nullable String baseModuleDirPath, boolean externalStorage, @NotNull SerializationContext context2) {
        Intrinsics.checkNotNullParameter(imlFileUrl, "imlFileUrl");
        Intrinsics.checkNotNullParameter(internalSource, "internalSource");
        Intrinsics.checkNotNullParameter(componentName, "componentName");
        Intrinsics.checkNotNullParameter(context2, "context");
        this.imlFileUrl = imlFileUrl;
        this.internalSource = internalSource;
        this.componentName = componentName;
        this.baseModuleDirPath = baseModuleDirPath;
        this.externalStorage = externalStorage;
        this.context = context2;
    }

    public final void loadFacetEntities$intellij_platform_workspace_jps(@NotNull ModuleEntity moduleEntity, @NotNull JpsFileContentReader reader) {
        Intrinsics.checkNotNullParameter(moduleEntity, "moduleEntity");
        Intrinsics.checkNotNullParameter(reader, "reader");
        String string2 = this.imlFileUrl.getUrl();
        Intrinsics.checkNotNullExpressionValue(string2, "getUrl(...)");
        Element element = reader.loadComponent(string2, this.componentName, this.baseModuleDirPath);
        if (element == null) {
            return;
        }
        Element facetManagerTag = element;
        FacetManagerState facetManagerState = XmlSerializer.deserialize(facetManagerTag, FacetManagerState.class);
        Intrinsics.checkNotNullExpressionValue(facetManagerState, "deserialize(...)");
        FacetManagerState facetManagerState2 = facetManagerState;
        ArrayList orderOfFacets = new ArrayList();
        List<FacetState> list2 = facetManagerState2.facets;
        Intrinsics.checkNotNullExpressionValue(list2, "facets");
        this.loadFacetEntities(list2, moduleEntity, orderOfFacets);
        if (orderOfFacets.size() > 1 && !this.externalStorage) {
            FacetsOrderEntity entity = OrdersKt.getFacetOrder(moduleEntity);
            if (entity != null) {
                ((FacetsOrderEntity.Builder)entity).setOrderOfFacets(orderOfFacets);
            } else {
                FacetsOrderEntity.Companion.create(orderOfFacets, this.internalSource, (Function1<? super FacetsOrderEntity.Builder, Unit>)new Function1<FacetsOrderEntity.Builder, Unit>(moduleEntity){
                    final /* synthetic */ ModuleEntity $moduleEntity;
                    {
                        this.$moduleEntity = $moduleEntity;
                        super(1);
                    }

                    public final void invoke(@NotNull FacetsOrderEntity.Builder $this$invoke) {
                        Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                        $this$invoke.setModuleEntity(this.$moduleEntity);
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadFacetEntities(List<FacetState> facetStates, ModuleEntity moduleEntity, List<String> orderOfFacets) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = this.context.getCustomFacetRelatedEntitySerializers();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            CustomFacetRelatedEntitySerializer customFacetRelatedEntitySerializer = (CustomFacetRelatedEntitySerializer)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl2 = false;
            map2.put(it.getSupportedFacetType(), element$iv$iv);
        }
        Map facetTypeToSerializer = destination$iv$iv;
        for (FacetState facetState : facetStates) {
            String string2 = facetState.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            orderOfFacets.add(string2);
            CustomFacetRelatedEntitySerializer customFacetRelatedEntitySerializer = (CustomFacetRelatedEntitySerializer)facetTypeToSerializer.get(facetState.getFacetType());
            if (customFacetRelatedEntitySerializer == null) {
                customFacetRelatedEntitySerializer = (CustomFacetRelatedEntitySerializer)MapsKt.getValue(facetTypeToSerializer, "<all types of facets>");
            }
            CustomFacetRelatedEntitySerializer serializer2 = customFacetRelatedEntitySerializer;
            serializer2.loadEntitiesFromFacetState(moduleEntity, facetState, (Function1<FacetState, EntitySource>)new Function1<FacetState, EntitySource>(this){
                final /* synthetic */ FacetsSerializer this$0;
                {
                    this.this$0 = $receiver;
                    super(1, Intrinsics.Kotlin.class, "evaluateEntitySource", "loadFacetEntities$evaluateEntitySource(Lcom/intellij/platform/workspace/jps/serialization/impl/FacetsSerializer;Lorg/jetbrains/jps/model/serialization/facet/FacetState;)Lcom/intellij/platform/workspace/storage/EntitySource;", 0);
                }

                @NotNull
                public final EntitySource invoke(@NotNull FacetState p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return FacetsSerializer.access$loadFacetEntities$evaluateEntitySource(this.this$0, p0);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void saveFacetEntities$intellij_platform_workspace_jps(@Nullable ModuleEntity moduleEntity, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends List<? extends WorkspaceEntity>> affectedEntities, @NotNull JpsFileContentWriter writer, @NotNull Function1<? super EntitySource, Boolean> entitySourceFilter2) {
        void $this$groupByTo$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(affectedEntities, "affectedEntities");
        Intrinsics.checkNotNullParameter(writer, "writer");
        Intrinsics.checkNotNullParameter(entitySourceFilter2, "entitySourceFilter");
        String fileUrl = this.imlFileUrl.getUrl();
        Iterable iterable = this.context.getCustomFacetRelatedEntitySerializers();
        boolean $i$f$mapNotNull = false;
        void var9_9 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            List<FacetState> list2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            CustomFacetRelatedEntitySerializer entitySerializer = (CustomFacetRelatedEntitySerializer)element$iv$iv;
            boolean bl3 = false;
            List<? extends WorkspaceEntity> list3 = affectedEntities.get(entitySerializer.getRootEntityType());
            if (list3 == null) {
                list2 = null;
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = list3;
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    WorkspaceEntity it = (WorkspaceEntity)element$iv$iv2;
                    boolean bl4 = false;
                    if (!entitySourceFilter2.invoke(it.getEntitySource()).booleanValue()) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                List entitiesToSave2 = (List)destination$iv$iv2;
                Iterable iterable3 = entitiesToSave2;
                CustomFacetRelatedEntitySerializer customFacetRelatedEntitySerializer = entitySerializer;
                boolean $i$f$map = false;
                $this$filter$iv = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    WorkspaceEntity workspaceEntity = (WorkspaceEntity)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl5 = false;
                    Intrinsics.checkNotNull(it, "null cannot be cast to non-null type com.intellij.platform.workspace.jps.entities.ModuleSettingsBase");
                    collection.add((ModuleSettingsBase)it);
                }
                list2 = customFacetRelatedEntitySerializer.createFacetStateFromEntities((List)destination$iv$iv3, this.externalStorage);
            }
            if (list2 == null) continue;
            List<FacetState> it$iv$iv = list2;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List facetStatesFromEP = CollectionsKt.flatten((List)destination$iv$iv);
        if (facetStatesFromEP.isEmpty()) {
            Intrinsics.checkNotNull(fileUrl);
            writer.saveComponent(fileUrl, this.componentName, null);
            return;
        }
        FacetManagerState facetManagerState = new FacetManagerState();
        $this$mapNotNullTo$iv$iv = facetStatesFromEP;
        Map destination$iv = new HashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv : $this$groupByTo$iv) {
            Object object;
            FacetState it = (FacetState)element$iv;
            boolean bl7 = false;
            String key$iv = it.getName();
            Map $this$getOrPut$iv$iv = destination$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
            if (value$iv$iv == null) {
                boolean bl8 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                object = answer$iv$iv;
            } else {
                object = value$iv$iv;
            }
            List list$iv = (List)object;
            list$iv.add(element$iv);
        }
        HashMap facetNameToFacetState = (HashMap)destination$iv;
        Object object = moduleEntity;
        if (object == null || (object = OrdersKt.getFacetOrder((ModuleEntity)object)) == null || (object = object.getOrderOfFacets()) == null) {
            object = CollectionsKt.emptyList();
        }
        List<String> orderOfFacets = object;
        for (String facetName : orderOfFacets) {
            List list4 = (List)facetNameToFacetState.remove(facetName);
            if (list4 == null) continue;
            Iterable $this$forEach$iv = list4;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                FacetState it = (FacetState)element$iv;
                boolean bl9 = false;
                facetManagerState.facets.add(it);
            }
        }
        List<FacetState> list5 = facetManagerState.facets;
        Collection collection = facetNameToFacetState.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        list5.addAll(CollectionsKt.flatten(collection));
        Element componentTag = JDomSerializationUtil.createComponentElement(this.componentName);
        XmlSerializer.serializeInto(facetManagerState, componentTag);
        if (this.externalStorage && FileUtil.extensionEquals(fileUrl, "iml")) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FacetsSerializer.class);
            Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
            logger.error(StringsKt.trimMargin$default("Incorrect file for the serializer\n        |externalStorage: true\n        |file path: " + fileUrl + "\n        |componentName: " + this.componentName + "\n      ", null, 1, null));
        }
        Intrinsics.checkNotNull(fileUrl);
        writer.saveComponent(fileUrl, this.componentName, componentTag);
    }

    private static final EntitySource loadFacetEntities$evaluateEntitySource(FacetsSerializer this$0, FacetState facetState) {
        String externalSystemId;
        String string2 = facetState.getExternalSystemId();
        if (string2 == null) {
            string2 = facetState.getExternalSystemIdInInternalStorage();
        }
        return (externalSystemId = string2) == null ? (EntitySource)this$0.internalSource : (EntitySource)new JpsImportedEntitySource(this$0.internalSource, externalSystemId, this$0.externalStorage);
    }

    public static final /* synthetic */ EntitySource access$loadFacetEntities$evaluateEntitySource(FacetsSerializer this$0, FacetState facetState) {
        return FacetsSerializer.loadFacetEntities$evaluateEntitySource(this$0, facetState);
    }
}

