/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.java.workspace.entities.ArchivePackagingElementEntity;
import com.intellij.java.workspace.entities.ArtifactEntity;
import com.intellij.java.workspace.entities.ArtifactId;
import com.intellij.java.workspace.entities.ArtifactKt;
import com.intellij.java.workspace.entities.ArtifactOutputPackagingElementEntity;
import com.intellij.java.workspace.entities.ArtifactPropertiesEntity;
import com.intellij.java.workspace.entities.ArtifactRootElementEntity;
import com.intellij.java.workspace.entities.ArtifactsOrderEntity;
import com.intellij.java.workspace.entities.CompositePackagingElementEntity;
import com.intellij.java.workspace.entities.CustomPackagingElementEntity;
import com.intellij.java.workspace.entities.DirectoryCopyPackagingElementEntity;
import com.intellij.java.workspace.entities.DirectoryPackagingElementEntity;
import com.intellij.java.workspace.entities.ExtractedDirectoryPackagingElementEntity;
import com.intellij.java.workspace.entities.FileCopyPackagingElementEntity;
import com.intellij.java.workspace.entities.LibraryFilesPackagingElementEntity;
import com.intellij.java.workspace.entities.ModuleOutputPackagingElementEntity;
import com.intellij.java.workspace.entities.ModuleSourcePackagingElementEntity;
import com.intellij.java.workspace.entities.ModuleTestOutputPackagingElementEntity;
import com.intellij.java.workspace.entities.PackagingElementEntity;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.JpsMetrics;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.jps.serialization.impl.ErrorReporter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.LibraryNameGenerator;
import com.intellij.platform.workspace.jps.serialization.impl.LoadingResult;
import com.intellij.platform.workspace.jps.serialization.impl.UtilsKt;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.artifact.ArtifactPropertiesState;
import org.jetbrains.jps.model.serialization.artifact.ArtifactState;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0010\u0018\u0000 ;2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001;B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ:\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192 \u0010\u001b\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001e0\u001cH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0014J@\u0010#\u001a\"\u0012\u001e\u0012\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001e0\u001c0$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020 H\u0002J\u0010\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u0002H\u0002JH\u0010/\u001a\u00020\u00172\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00020\u001e2 \u00101\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d020\u001c2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\"2\u0006\u0010+\u001a\u00020*H\u0002J\b\u00108\u001a\u000209H\u0016J\f\u0010:\u001a\u000209*\u000209H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsArtifactEntitiesSerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntitiesSerializer;", "Lcom/intellij/java/workspace/entities/ArtifactEntity;", "fileUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "internalEntitySource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "preserveOrder", "", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;ZLcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;)V", "getFileUrl", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "getInternalEntitySource", "()Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "isExternalStorage", "()Z", "mainEntityClass", "Ljava/lang/Class;", "getMainEntityClass", "()Ljava/lang/Class;", "checkAndAddToBuilder", "", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "orphanage", "newEntities", "", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "", "createEntitySource", "Lcom/intellij/platform/workspace/storage/EntitySource;", "artifactTag", "Lorg/jdom/Element;", "loadEntities", "Lcom/intellij/platform/workspace/jps/serialization/impl/LoadingResult;", "reader", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentReader;", "errorReporter", "Lcom/intellij/platform/workspace/jps/serialization/impl/ErrorReporter;", "loadPackagingElement", "Lcom/intellij/java/workspace/entities/PackagingElementEntity;", "element", "source", "saveArtifact", "artifact", "saveEntities", "mainEntities", "entities", "", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "writer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "savePackagingElement", "toString", "", "toPathWithScheme", "Companion", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nJpsArtifactEntitiesSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsArtifactEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsArtifactEntitiesSerializer\n+ 2 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 LoadingResult.kt\ncom/intellij/platform/workspace/jps/serialization/impl/LoadingResultKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,438:1\n44#2,2:439\n46#2:509\n44#2,2:514\n46#2:537\n17#3,5:441\n22#3:508\n17#3,5:516\n22#3:536\n21#4,11:446\n21#4,11:458\n21#4,11:479\n1#5:457\n1#5:490\n1#5:503\n1#5:543\n1603#6,9:469\n1855#6:478\n1856#6:491\n1612#6:492\n1603#6,9:493\n1855#6:502\n1856#6:504\n1612#6:505\n288#6,2:506\n1855#6,2:511\n1502#6,3:521\n1505#6,3:531\n1855#6,2:534\n766#6:538\n857#6,2:539\n1611#6:541\n1855#6:542\n1856#6:544\n1612#6:545\n1855#6,2:546\n1620#6,3:548\n1855#6,2:551\n215#7:510\n216#7:513\n372#8,7:524\n*S KotlinDebug\n*F\n+ 1 JpsArtifactEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsArtifactEntitiesSerializer\n*L\n157#1:439,2\n157#1:509\n294#1:514,2\n294#1:537\n157#1:441,5\n157#1:508\n294#1:516,5\n294#1:536\n158#1:446,11\n164#1:458,11\n168#1:479,11\n167#1:490\n196#1:503\n313#1:543\n167#1:469,9\n167#1:478\n167#1:491\n167#1:492\n196#1:493,9\n196#1:502\n196#1:504\n196#1:505\n198#1:506,2\n221#1:511,2\n299#1:521,3\n299#1:531,3\n300#1:534,2\n312#1:538\n312#1:539,2\n313#1:541\n313#1:542\n313#1:544\n313#1:545\n404#1:546,2\n232#1:548,3\n339#1:551,2\n218#1:510\n218#1:513\n299#1:524,7\n*E\n"})
public class JpsArtifactEntitiesSerializer
implements JpsFileEntitiesSerializer<ArtifactEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFileUrl fileUrl;
    @NotNull
    private final JpsFileEntitySource internalEntitySource;
    private final boolean preserveOrder;
    @NotNull
    private final VirtualFileUrlManager virtualFileManager;
    @NotNull
    private static final AtomicLong loadEntitiesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
    @NotNull
    private static final AtomicLong saveEntitiesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);

    public JpsArtifactEntitiesSerializer(@NotNull VirtualFileUrl fileUrl, @NotNull JpsFileEntitySource internalEntitySource, boolean preserveOrder, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter(fileUrl, "fileUrl");
        Intrinsics.checkNotNullParameter(internalEntitySource, "internalEntitySource");
        Intrinsics.checkNotNullParameter(virtualFileManager, "virtualFileManager");
        this.fileUrl = fileUrl;
        this.internalEntitySource = internalEntitySource;
        this.preserveOrder = preserveOrder;
        this.virtualFileManager = virtualFileManager;
    }

    @Override
    @NotNull
    public VirtualFileUrl getFileUrl() {
        return this.fileUrl;
    }

    @Override
    @NotNull
    public JpsFileEntitySource getInternalEntitySource() {
        return this.internalEntitySource;
    }

    public boolean isExternalStorage() {
        return false;
    }

    @Override
    @NotNull
    public Class<ArtifactEntity> getMainEntityClass() {
        return ArtifactEntity.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LoadingResult<Map<Class<? extends WorkspaceEntity>, Collection<WorkspaceEntity>>> loadEntities(@NotNull JpsFileContentReader reader, @NotNull ErrorReporter errorReporter, @NotNull VirtualFileUrlManager virtualFileManager) {
        LoadingResult<Pair[]> loadingResult;
        Object object;
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(errorReporter, "errorReporter");
        Intrinsics.checkNotNullParameter(virtualFileManager, "virtualFileManager");
        AtomicLong arg0$iv = loadEntitiesTimeMs;
        boolean bl2 = false;
        LoadingResult<Pair[]> value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        Object $this$runCatchingXmlIssues$iv = this;
        boolean $i$f$runCatchingXmlIssues = false;
        try {
            boolean bl5 = false;
            String string2 = this.getFileUrl().getUrl();
            Intrinsics.checkNotNullExpressionValue(string2, "getUrl(...)");
            object = Result.constructor-impl(JpsFileContentReader.loadComponent$default(reader, string2, "ArtifactManager", null, 4, null));
        }
        catch (JDOMException e$iv) {
            object = Result.constructor-impl(ResultKt.createFailure(e$iv));
        }
        catch (IOException e$iv) {
            object = Result.constructor-impl(ResultKt.createFailure(e$iv));
        }
        $this$runCatchingXmlIssues$iv = object;
        Throwable throwable = Result.exceptionOrNull-impl($this$runCatchingXmlIssues$iv);
        if (throwable != null) {
            Throwable it = $i$f$runCatchingXmlIssues = throwable;
            boolean bl6 = false;
            loadingResult = new LoadingResult<Pair[]>((Pair[])MapsKt.emptyMap(), it);
        } else {
            ResultKt.throwOnFailure($this$runCatchingXmlIssues$iv);
            Element artifactListElement = (Element)$this$runCatchingXmlIssues$iv;
            if (artifactListElement == null) {
                loadingResult = new LoadingResult<Pair[]>((Pair[])MapsKt.emptyMap(), null);
            } else {
                Object object2;
                ArrayList orderOfItems = new ArrayList();
                Object $this$runCatchingXmlIssues$iv2 = this;
                boolean $i$f$runCatchingXmlIssues22 = false;
                try {
                    boolean bl7 = false;
                    object2 = Result.constructor-impl(artifactListElement.getChildren("artifact"));
                }
                catch (JDOMException e$iv) {
                    object2 = Result.constructor-impl(ResultKt.createFailure(e$iv));
                }
                catch (IOException e$iv) {
                    object2 = Result.constructor-impl(ResultKt.createFailure(e$iv));
                }
                $this$runCatchingXmlIssues$iv2 = object2;
                Throwable throwable2 = Result.exceptionOrNull-impl($this$runCatchingXmlIssues$iv2);
                if (throwable2 != null) {
                    Throwable it = $i$f$runCatchingXmlIssues22 = throwable2;
                    boolean bl8 = false;
                    loadingResult = new LoadingResult<Pair[]>((Pair[])MapsKt.emptyMap(), it);
                } else {
                    Object v12;
                    Object object3;
                    block23: {
                        void $this$firstOrNull$iv;
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv;
                        void $this$mapNotNullTo$iv$iv2;
                        void $this$mapNotNull$iv2;
                        ResultKt.throwOnFailure($this$runCatchingXmlIssues$iv2);
                        Object object4 = $this$runCatchingXmlIssues$iv2;
                        Intrinsics.checkNotNullExpressionValue(object4, "getOrThrow(...)");
                        Iterable it = (Iterable)object4;
                        boolean $i$f$mapNotNull22 = false;
                        void $i$f$runCatchingXmlIssues22 = $this$mapNotNull$iv2;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                        boolean $i$f$forEach = false;
                        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            Result result2;
                            block22: {
                                Object object5;
                                Object element$iv$iv$iv;
                                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                                boolean bl9 = false;
                                Element artifactElement = (Element)element$iv$iv;
                                boolean bl10 = false;
                                JpsFileEntitiesSerializer $this$runCatchingXmlIssues$iv3 = this;
                                boolean $i$f$runCatchingXmlIssues3 = false;
                                try {
                                    EntitySource entitySource;
                                    VirtualFileUrl virtualFileUrl;
                                    ArtifactState state;
                                    String string3;
                                    boolean bl11 = false;
                                    Intrinsics.checkNotNull(artifactElement);
                                    if (this.createEntitySource(artifactElement) == null) {
                                        result2 = null;
                                        break block22;
                                    }
                                    Intrinsics.checkNotNullExpressionValue(XmlSerializer.deserialize(artifactElement, ArtifactState.class), "deserialize(...)");
                                    String string4 = string3 = state.getOutputPath();
                                    if (string4 != null) {
                                        Intrinsics.checkNotNull(string4);
                                        String path = string3;
                                        boolean bl12 = false;
                                        virtualFileUrl = ((CharSequence)path).length() > 0 ? virtualFileManager.getOrCreateFromUri(this.toPathWithScheme(path)) : null;
                                    } else {
                                        virtualFileUrl = null;
                                    }
                                    VirtualFileUrl outputUrl = virtualFileUrl;
                                    Element element = state.getRootElement();
                                    Intrinsics.checkNotNullExpressionValue(element, "getRootElement(...)");
                                    PackagingElementEntity rootElement = this.loadPackagingElement(element, entitySource);
                                    String string5 = state.getName();
                                    Intrinsics.checkNotNullExpressionValue(string5, "getName(...)");
                                    String string6 = state.getArtifactType();
                                    Intrinsics.checkNotNullExpressionValue(string6, "getArtifactType(...)");
                                    ArtifactEntity artifactEntity2 = ArtifactEntity.Companion.create(string5, string6, state.isBuildOnMake(), entitySource, (Function1<? super ArtifactEntity.Builder, Unit>)new Function1<ArtifactEntity.Builder, Unit>(outputUrl, rootElement){
                                        final /* synthetic */ VirtualFileUrl $outputUrl;
                                        final /* synthetic */ PackagingElementEntity $rootElement;
                                        {
                                            this.$outputUrl = $outputUrl;
                                            this.$rootElement = $rootElement;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull ArtifactEntity.Builder $this$invoke) {
                                            Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                                            $this$invoke.setOutputUrl(this.$outputUrl);
                                            PackagingElementEntity packagingElementEntity = this.$rootElement;
                                            Intrinsics.checkNotNull(packagingElementEntity, "null cannot be cast to non-null type com.intellij.java.workspace.entities.CompositePackagingElementEntity");
                                            $this$invoke.setRootElement((CompositePackagingElementEntity)packagingElementEntity);
                                        }
                                    });
                                    for (ArtifactPropertiesState propertiesState : state.getPropertiesList()) {
                                        String string7 = propertiesState.getId();
                                        Intrinsics.checkNotNullExpressionValue(string7, "getId(...)");
                                        ArtifactPropertiesEntity.Companion.create(string7, entitySource, (Function1<? super ArtifactPropertiesEntity.Builder, Unit>)new Function1<ArtifactPropertiesEntity.Builder, Unit>(artifactEntity2, propertiesState){
                                            final /* synthetic */ ArtifactEntity $artifactEntity;
                                            final /* synthetic */ ArtifactPropertiesState $propertiesState;
                                            {
                                                this.$artifactEntity = $artifactEntity;
                                                this.$propertiesState = $propertiesState;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull ArtifactPropertiesEntity.Builder $this$invoke) {
                                                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                                                $this$invoke.setArtifact(this.$artifactEntity);
                                                $this$invoke.setPropertiesXmlTag(JDOMUtil.write(this.$propertiesState.getOptions()));
                                            }
                                        });
                                    }
                                    ((Collection)orderOfItems).add(state.getName());
                                    object5 = Result.constructor-impl(artifactEntity2);
                                }
                                catch (JDOMException e$iv) {
                                    object5 = Result.constructor-impl(ResultKt.createFailure(e$iv));
                                }
                                catch (IOException e$iv) {
                                    object5 = Result.constructor-impl(ResultKt.createFailure(e$iv));
                                }
                                result2 = Result.box-impl(object5);
                            }
                            if (result2 == null) continue;
                            Result it$iv$iv = result2;
                            boolean bl13 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List artifactEntities2 = (List)destination$iv$iv;
                        Pair[] pairArray = new Pair[2];
                        pairArray[0] = TuplesKt.to(ArtifactsOrderEntity.class, CollectionsKt.listOf(ArtifactsOrderEntity.Companion.create$default(ArtifactsOrderEntity.Companion, orderOfItems, this.getInternalEntitySource(), null, 4, null)));
                        Iterable $i$f$mapNotNull22 = artifactEntities2;
                        Class<ArtifactEntity> clazz = ArtifactEntity.class;
                        int n2 = 1;
                        object3 = pairArray;
                        boolean $i$f$mapNotNull = false;
                        destination$iv$iv = $this$mapNotNull$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$mapNotNullTo2 = false;
                        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach2 = false;
                        Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
                        while (iterator3.hasNext()) {
                            ArtifactEntity it$iv$iv;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                            boolean bl14 = false;
                            Object it2 = ((Result)element$iv$iv).unbox-impl();
                            boolean bl15 = false;
                            if ((ArtifactEntity)(Result.isFailure-impl(it2) ? null : it2) == null) continue;
                            boolean bl16 = false;
                            destination$iv$iv2.add(it$iv$iv);
                        }
                        List list2 = (List)destination$iv$iv2;
                        object3[n2] = TuplesKt.to(clazz, list2);
                        $this$mapNotNull$iv = artifactEntities2;
                        object3 = MapsKt.mapOf(pairArray);
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Object it3 = ((Result)element$iv).unbox-impl();
                            boolean bl17 = false;
                            if (!Result.isFailure-impl(it3)) continue;
                            v12 = element$iv;
                            break block23;
                        }
                        v12 = null;
                    }
                    Result result3 = v12;
                    Throwable throwable3 = result3 != null ? Result.exceptionOrNull-impl(result3.unbox-impl()) : null;
                    Object object6 = object3;
                    loadingResult = new LoadingResult<Pair[]>((Pair[])object6, throwable3);
                }
            }
        }
        value$iv = loadingResult;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    @Override
    public void checkAndAddToBuilder(@NotNull MutableEntityStorage builder, @NotNull MutableEntityStorage orphanage, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity>> newEntities) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(orphanage, "orphanage");
        Intrinsics.checkNotNullParameter(newEntities, "newEntities");
        if (this.preserveOrder) {
            ArtifactsOrderEntity order;
            Collection<? extends WorkspaceEntity> collection = newEntities.get(ArtifactsOrderEntity.class);
            WorkspaceEntity workspaceEntity = collection != null ? (WorkspaceEntity)CollectionsKt.singleOrNull((Iterable)collection) : null;
            ArtifactsOrderEntity artifactsOrderEntity = order = workspaceEntity instanceof ArtifactsOrderEntity ? (ArtifactsOrderEntity)workspaceEntity : null;
            if (order != null) {
                ArtifactsOrderEntity entity = SequencesKt.firstOrNull(builder.entities(ArtifactsOrderEntity.class));
                if (entity != null) {
                    ArtifactKt.modifyEntity(builder, entity, (Function1<? super ArtifactsOrderEntity.Builder, Unit>)new Function1<ArtifactsOrderEntity.Builder, Unit>(order){
                        final /* synthetic */ ArtifactsOrderEntity $order;
                        {
                            this.$order = $order;
                            super(1);
                        }

                        public final void invoke(@NotNull ArtifactsOrderEntity.Builder $this$modifyEntity) {
                            Intrinsics.checkNotNullParameter($this$modifyEntity, "$this$modifyEntity");
                            $this$modifyEntity.getOrderOfArtifacts().addAll((Collection<String>)this.$order.getOrderOfArtifacts());
                        }
                    });
                } else {
                    builder.addEntity((WorkspaceEntity)order);
                }
            }
        }
        Map<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity>> $this$forEach$iv = newEntities;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity>> element$iv;
            Map.Entry<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity>> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            Class<? extends WorkspaceEntity> key = entry.getKey();
            Collection<? extends WorkspaceEntity> value = entry.getValue();
            if (Intrinsics.areEqual(key, ArtifactsOrderEntity.class)) continue;
            Iterable $this$forEach$iv2 = value;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                WorkspaceEntity it = (WorkspaceEntity)element$iv2;
                boolean bl3 = false;
                builder.addEntity(it);
            }
        }
    }

    @Nullable
    protected EntitySource createEntitySource(@NotNull Element artifactTag) {
        Intrinsics.checkNotNullParameter(artifactTag, "artifactTag");
        String externalSystemId = artifactTag.getAttributeValue("external-system-id");
        return externalSystemId == null ? (EntitySource)this.getInternalEntitySource() : (EntitySource)new JpsImportedEntitySource(this.getInternalEntitySource(), externalSystemId, false);
    }

    private final PackagingElementEntity loadPackagingElement(Element element, EntitySource source) {
        PackagingElementEntity packagingElementEntity;
        switch (JpsArtifactEntitiesSerializer.loadPackagingElement$getAttribute(element, "id")) {
            case "root": {
                packagingElementEntity = ArtifactRootElementEntity.Companion.create(source, (Function1<? super ArtifactRootElementEntity.Builder, Unit>)new Function1<ArtifactRootElementEntity.Builder, Unit>(element, this, source){
                    final /* synthetic */ Element $element;
                    final /* synthetic */ JpsArtifactEntitiesSerializer this$0;
                    final /* synthetic */ EntitySource $source;
                    {
                        this.$element = $element;
                        this.this$0 = $receiver;
                        this.$source = $source;
                        super(1);
                    }

                    public final void invoke(@NotNull ArtifactRootElementEntity.Builder $this$invoke) {
                        Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                        $this$invoke.setChildren(JpsArtifactEntitiesSerializer.access$loadPackagingElement$loadElementChildren(this.$element, this.this$0, this.$source));
                    }
                });
                break;
            }
            case "directory": {
                packagingElementEntity = DirectoryPackagingElementEntity.Companion.create(JpsArtifactEntitiesSerializer.loadPackagingElement$getAttribute(element, "name"), source, (Function1<? super DirectoryPackagingElementEntity.Builder, Unit>)new Function1<DirectoryPackagingElementEntity.Builder, Unit>(element, this, source){
                    final /* synthetic */ Element $element;
                    final /* synthetic */ JpsArtifactEntitiesSerializer this$0;
                    final /* synthetic */ EntitySource $source;
                    {
                        this.$element = $element;
                        this.this$0 = $receiver;
                        this.$source = $source;
                        super(1);
                    }

                    public final void invoke(@NotNull DirectoryPackagingElementEntity.Builder $this$invoke) {
                        Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                        $this$invoke.setChildren(JpsArtifactEntitiesSerializer.access$loadPackagingElement$loadElementChildren(this.$element, this.this$0, this.$source));
                    }
                });
                break;
            }
            case "archive": {
                packagingElementEntity = ArchivePackagingElementEntity.Companion.create(JpsArtifactEntitiesSerializer.loadPackagingElement$getAttribute(element, "name"), source, (Function1<? super ArchivePackagingElementEntity.Builder, Unit>)new Function1<ArchivePackagingElementEntity.Builder, Unit>(element, this, source){
                    final /* synthetic */ Element $element;
                    final /* synthetic */ JpsArtifactEntitiesSerializer this$0;
                    final /* synthetic */ EntitySource $source;
                    {
                        this.$element = $element;
                        this.this$0 = $receiver;
                        this.$source = $source;
                        super(1);
                    }

                    public final void invoke(@NotNull ArchivePackagingElementEntity.Builder $this$invoke) {
                        Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                        $this$invoke.setChildren(JpsArtifactEntitiesSerializer.access$loadPackagingElement$loadElementChildren(this.$element, this.this$0, this.$source));
                    }
                });
                break;
            }
            case "dir-copy": {
                packagingElementEntity = DirectoryCopyPackagingElementEntity.Companion.create$default(DirectoryCopyPackagingElementEntity.Companion, JpsArtifactEntitiesSerializer.loadPackagingElement$getPathAttribute(element, this, "path"), source, null, 4, null);
                break;
            }
            case "file-copy": {
                packagingElementEntity = FileCopyPackagingElementEntity.Companion.create(JpsArtifactEntitiesSerializer.loadPackagingElement$getPathAttribute(element, this, "path"), source, (Function1<? super FileCopyPackagingElementEntity.Builder, Unit>)new Function1<FileCopyPackagingElementEntity.Builder, Unit>(element){
                    final /* synthetic */ Element $element;
                    {
                        this.$element = $element;
                        super(1);
                    }

                    public final void invoke(@NotNull FileCopyPackagingElementEntity.Builder $this$invoke) {
                        Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                        $this$invoke.setRenamedOutputFileName(JpsArtifactEntitiesSerializer.access$loadPackagingElement$getOptionalAttribute(this.$element, "output-file-name"));
                    }
                });
                break;
            }
            case "extracted-dir": {
                packagingElementEntity = ExtractedDirectoryPackagingElementEntity.Companion.create$default(ExtractedDirectoryPackagingElementEntity.Companion, JpsArtifactEntitiesSerializer.loadPackagingElement$getPathAttribute(element, this, "path"), JpsArtifactEntitiesSerializer.loadPackagingElement$getAttribute(element, "path-in-jar"), source, null, 8, null);
                break;
            }
            case "artifact": {
                packagingElementEntity = ArtifactOutputPackagingElementEntity.Companion.create(source, (Function1<? super ArtifactOutputPackagingElementEntity.Builder, Unit>)new Function1<ArtifactOutputPackagingElementEntity.Builder, Unit>(element){
                    final /* synthetic */ Element $element;
                    {
                        this.$element = $element;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull ArtifactOutputPackagingElementEntity.Builder $this$invoke) {
                        ArtifactId artifactId;
                        Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                        ArtifactOutputPackagingElementEntity.Builder builder = $this$invoke;
                        String string2 = JpsArtifactEntitiesSerializer.access$loadPackagingElement$getOptionalAttribute(this.$element, "artifact-name");
                        if (string2 != null) {
                            void it;
                            String string3 = string2;
                            ArtifactOutputPackagingElementEntity.Builder builder2 = builder;
                            boolean bl2 = false;
                            artifactId = new ArtifactId((String)it);
                            builder = builder2;
                        } else {
                            artifactId = null;
                        }
                        builder.setArtifact(artifactId);
                    }
                });
                break;
            }
            case "module-output": {
                packagingElementEntity = ModuleOutputPackagingElementEntity.Companion.create(source, (Function1<? super ModuleOutputPackagingElementEntity.Builder, Unit>)new Function1<ModuleOutputPackagingElementEntity.Builder, Unit>(element){
                    final /* synthetic */ Element $element;
                    {
                        this.$element = $element;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull ModuleOutputPackagingElementEntity.Builder $this$invoke) {
                        ModuleId moduleId;
                        Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                        ModuleOutputPackagingElementEntity.Builder builder = $this$invoke;
                        String string2 = JpsArtifactEntitiesSerializer.access$loadPackagingElement$getOptionalAttribute(this.$element, "name");
                        if (string2 != null) {
                            void it;
                            String string3 = string2;
                            ModuleOutputPackagingElementEntity.Builder builder2 = builder;
                            boolean bl2 = false;
                            moduleId = new ModuleId((String)it);
                            builder = builder2;
                        } else {
                            moduleId = null;
                        }
                        builder.setModule(moduleId);
                    }
                });
                break;
            }
            case "module-test-output": {
                packagingElementEntity = ModuleTestOutputPackagingElementEntity.Companion.create(source, (Function1<? super ModuleTestOutputPackagingElementEntity.Builder, Unit>)new Function1<ModuleTestOutputPackagingElementEntity.Builder, Unit>(element){
                    final /* synthetic */ Element $element;
                    {
                        this.$element = $element;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull ModuleTestOutputPackagingElementEntity.Builder $this$invoke) {
                        ModuleId moduleId;
                        Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                        ModuleTestOutputPackagingElementEntity.Builder builder = $this$invoke;
                        String string2 = JpsArtifactEntitiesSerializer.access$loadPackagingElement$getOptionalAttribute(this.$element, "name");
                        if (string2 != null) {
                            void it;
                            String string3 = string2;
                            ModuleTestOutputPackagingElementEntity.Builder builder2 = builder;
                            boolean bl2 = false;
                            moduleId = new ModuleId((String)it);
                            builder = builder2;
                        } else {
                            moduleId = null;
                        }
                        builder.setModule(moduleId);
                    }
                });
                break;
            }
            case "module-source": {
                packagingElementEntity = ModuleSourcePackagingElementEntity.Companion.create(source, (Function1<? super ModuleSourcePackagingElementEntity.Builder, Unit>)new Function1<ModuleSourcePackagingElementEntity.Builder, Unit>(element){
                    final /* synthetic */ Element $element;
                    {
                        this.$element = $element;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull ModuleSourcePackagingElementEntity.Builder $this$invoke) {
                        ModuleId moduleId;
                        Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                        ModuleSourcePackagingElementEntity.Builder builder = $this$invoke;
                        String string2 = JpsArtifactEntitiesSerializer.access$loadPackagingElement$getOptionalAttribute(this.$element, "name");
                        if (string2 != null) {
                            void it;
                            String string3 = string2;
                            ModuleSourcePackagingElementEntity.Builder builder2 = builder;
                            boolean bl2 = false;
                            moduleId = new ModuleId((String)it);
                            builder = builder2;
                        } else {
                            moduleId = null;
                        }
                        builder.setModule(moduleId);
                    }
                });
                break;
            }
            case "library": {
                LibraryFilesPackagingElementEntity libraryFilesPackagingElementEntity;
                String level = JpsArtifactEntitiesSerializer.loadPackagingElement$getOptionalAttribute(element, "level");
                String name2 = JpsArtifactEntitiesSerializer.loadPackagingElement$getOptionalAttribute(element, "name");
                if (level != null && name2 != null) {
                    String moduleName = JpsArtifactEntitiesSerializer.loadPackagingElement$getOptionalAttribute(element, "module-name");
                    LibraryTableId parentId = moduleName != null ? (LibraryTableId)new LibraryTableId.ModuleLibraryTableId(new ModuleId(moduleName)) : LibraryNameGenerator.INSTANCE.getLibraryTableId(level);
                    libraryFilesPackagingElementEntity = LibraryFilesPackagingElementEntity.Companion.create(source, (Function1<? super LibraryFilesPackagingElementEntity.Builder, Unit>)new Function1<LibraryFilesPackagingElementEntity.Builder, Unit>(name2, parentId){
                        final /* synthetic */ String $name;
                        final /* synthetic */ LibraryTableId $parentId;
                        {
                            this.$name = $name;
                            this.$parentId = $parentId;
                            super(1);
                        }

                        public final void invoke(@NotNull LibraryFilesPackagingElementEntity.Builder $this$invoke) {
                            Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                            String string2 = this.$name;
                            Intrinsics.checkNotNullExpressionValue(string2, "$name");
                            $this$invoke.setLibrary(new LibraryId(string2, this.$parentId));
                        }
                    });
                } else {
                    libraryFilesPackagingElementEntity = LibraryFilesPackagingElementEntity.Companion.create$default(LibraryFilesPackagingElementEntity.Companion, source, null, 2, null);
                }
                packagingElementEntity = libraryFilesPackagingElementEntity;
                break;
            }
            default: {
                String typeId;
                Element element2 = element.clone();
                Intrinsics.checkNotNullExpressionValue(element2, "clone(...)");
                Element cloned = element2;
                cloned.removeContent();
                String string2 = JDOMUtil.write(cloned);
                Intrinsics.checkNotNullExpressionValue(string2, "write(...)");
                packagingElementEntity = CustomPackagingElementEntity.Companion.create(typeId, string2, source, (Function1<? super CustomPackagingElementEntity.Builder, Unit>)new Function1<CustomPackagingElementEntity.Builder, Unit>(element, this, source){
                    final /* synthetic */ Element $element;
                    final /* synthetic */ JpsArtifactEntitiesSerializer this$0;
                    final /* synthetic */ EntitySource $source;
                    {
                        this.$element = $element;
                        this.this$0 = $receiver;
                        this.$source = $source;
                        super(1);
                    }

                    public final void invoke(@NotNull CustomPackagingElementEntity.Builder $this$invoke) {
                        Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                        $this$invoke.setChildren(JpsArtifactEntitiesSerializer.access$loadPackagingElement$loadElementChildren(this.$element, this.this$0, this.$source));
                    }
                });
            }
        }
        return packagingElementEntity;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveEntities(@NotNull Collection<? extends ArtifactEntity> mainEntities, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends List<? extends WorkspaceEntity>> entities2, @NotNull EntityStorage storage, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter(mainEntities, "mainEntities");
        Intrinsics.checkNotNullParameter(entities2, "entities");
        Intrinsics.checkNotNullParameter(storage, "storage");
        Intrinsics.checkNotNullParameter(writer, "writer");
        AtomicLong arg0$iv = saveEntitiesTimeMs;
        boolean bl2 = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!mainEntities.isEmpty()) {
            void destination$iv;
            void $this$groupByTo$iv;
            List<String> list2;
            Object object;
            Element componentTag = JDomSerializationUtil.createComponentElement("ArtifactManager");
            if (this.preserveOrder) {
                List<? extends WorkspaceEntity> list3 = entities2.get(ArtifactsOrderEntity.class);
                object = list3 != null ? CollectionsKt.firstOrNull(list3) : null;
                ArtifactsOrderEntity artifactsOrderEntity = object instanceof ArtifactsOrderEntity ? (ArtifactsOrderEntity)object : null;
                list2 = artifactsOrderEntity != null ? artifactsOrderEntity.getOrderOfArtifacts() : null;
            } else {
                list2 = null;
            }
            List<String> orderOfItems = list2;
            object = mainEntities;
            Map map2 = new HashMap();
            List<String> list4 = orderOfItems;
            boolean $i$f$groupByTo = false;
            for (Object element$iv : $this$groupByTo$iv) {
                Object object2;
                ArtifactEntity it = (ArtifactEntity)element$iv;
                boolean bl5 = false;
                String key$iv = it.getName();
                void $this$getOrPut$iv$iv = destination$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
                if (value$iv$iv == null) {
                    boolean bl6 = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                    object2 = answer$iv$iv;
                } else {
                    object2 = value$iv$iv;
                }
                List list$iv = (List)object2;
                list$iv.add(element$iv);
            }
            ArrayList sorted2 = UtilsKt.sortByOrderEntity$default(list4, MapsKt.toMutableMap(destination$iv), null, 4, null);
            Iterable $this$forEach$iv = sorted2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ArtifactEntity it = (ArtifactEntity)element$iv;
                boolean bl7 = false;
                componentTag.addContent(this.saveArtifact(it));
            }
            String string2 = this.getFileUrl().getUrl();
            Intrinsics.checkNotNullExpressionValue(string2, "getUrl(...)");
            writer.saveComponent(string2, "ArtifactManager", componentTag);
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final Element saveArtifact(ArtifactEntity artifact) {
        String externalSystemId;
        void destination$iv;
        void $this$mapNotNullTo$iv;
        void $this$filterTo$iv$iv;
        ArtifactState artifactState = new ArtifactState();
        artifactState.setName(artifact.getName());
        artifactState.setArtifactType(artifact.getArtifactType());
        artifactState.setBuildOnMake(artifact.getIncludeInProjectBuild());
        VirtualFileUrl virtualFileUrl = artifact.getOutputUrl();
        artifactState.setOutputPath(JpsPathUtil.urlToPath(virtualFileUrl != null ? virtualFileUrl.getUrl() : null));
        Iterable $this$filter$iv = artifact.getCustomProperties();
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ArtifactPropertiesEntity it = (ArtifactPropertiesEntity)element$iv$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual(it.getEntitySource(), artifact.getEntitySource())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List customProperties = (List)destination$iv$iv;
        $this$filter$iv = customProperties;
        Collection $i$f$filter22 = new ArrayList();
        ArtifactState artifactState2 = artifactState;
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ArtifactPropertiesState artifactPropertiesState;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl3 = false;
            ArtifactPropertiesEntity it = (ArtifactPropertiesEntity)element$iv;
            boolean bl4 = false;
            if (it.getPropertiesXmlTag() == null) {
                artifactPropertiesState = null;
            } else {
                Element element;
                ArtifactPropertiesState artifactPropertiesState2;
                ArtifactPropertiesState $this$saveArtifact_u24lambda_u2420_u24lambda_u2419 = artifactPropertiesState2 = new ArtifactPropertiesState();
                boolean bl5 = false;
                $this$saveArtifact_u24lambda_u2420_u24lambda_u2419.setId(it.getProviderType());
                ArtifactPropertiesState artifactPropertiesState3 = $this$saveArtifact_u24lambda_u2420_u24lambda_u2419;
                if (it.getPropertiesXmlTag() != null) {
                    void it2;
                    ArtifactPropertiesState artifactPropertiesState4 = artifactPropertiesState3;
                    boolean bl6 = false;
                    element = JDOMUtil.load((CharSequence)it2);
                    artifactPropertiesState3 = artifactPropertiesState4;
                } else {
                    element = null;
                }
                artifactPropertiesState3.setOptions(element);
                artifactPropertiesState = artifactPropertiesState2;
            }
            if (artifactPropertiesState == null) continue;
            ArtifactPropertiesState it$iv = artifactPropertiesState;
            boolean bl7 = false;
            destination$iv.add(it$iv);
        }
        artifactState2.setPropertiesList((List)destination$iv);
        CompositePackagingElementEntity compositePackagingElementEntity = artifact.getRootElement();
        Intrinsics.checkNotNull(compositePackagingElementEntity);
        artifactState.setRootElement(this.savePackagingElement(compositePackagingElementEntity));
        EntitySource entitySource = artifact.getEntitySource();
        JpsImportedEntitySource jpsImportedEntitySource = entitySource instanceof JpsImportedEntitySource ? (JpsImportedEntitySource)entitySource : null;
        String string2 = externalSystemId = jpsImportedEntitySource != null ? jpsImportedEntitySource.getExternalSystemId() : null;
        if (externalSystemId != null) {
            if (this.isExternalStorage()) {
                artifactState.setExternalSystemId(externalSystemId);
            } else {
                artifactState.setExternalSystemIdInInternalStorage(externalSystemId);
            }
        }
        Element element = XmlSerializer.serialize(artifactState, new SkipDefaultsSerializationFilter());
        Intrinsics.checkNotNullExpressionValue(element, "serialize(...)");
        return element;
    }

    private final Element savePackagingElement(PackagingElementEntity element) {
        Element tag = new Element("element");
        PackagingElementEntity packagingElementEntity = element;
        if (packagingElementEntity instanceof ArtifactRootElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "root");
            JpsArtifactEntitiesSerializer.savePackagingElement$saveElementChildren(tag, this, (CompositePackagingElementEntity)element);
        } else if (packagingElementEntity instanceof DirectoryPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "directory");
            JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "name", ((DirectoryPackagingElementEntity)element).getDirectoryName());
            JpsArtifactEntitiesSerializer.savePackagingElement$saveElementChildren(tag, this, (CompositePackagingElementEntity)element);
        } else if (packagingElementEntity instanceof ArchivePackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "archive");
            JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "name", ((ArchivePackagingElementEntity)element).getFileName());
            JpsArtifactEntitiesSerializer.savePackagingElement$saveElementChildren(tag, this, (CompositePackagingElementEntity)element);
        } else if (packagingElementEntity instanceof DirectoryCopyPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "dir-copy");
            JpsArtifactEntitiesSerializer.savePackagingElement$setPathAttribute(tag, "path", ((DirectoryCopyPackagingElementEntity)element).getFilePath());
        } else if (packagingElementEntity instanceof FileCopyPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "file-copy");
            JpsArtifactEntitiesSerializer.savePackagingElement$setPathAttribute(tag, "path", ((FileCopyPackagingElementEntity)element).getFilePath());
            String string2 = ((FileCopyPackagingElementEntity)element).getRenamedOutputFileName();
            if (string2 != null) {
                String it = string2;
                boolean bl2 = false;
                JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "output-file-name", it);
            }
        } else if (packagingElementEntity instanceof ExtractedDirectoryPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "extracted-dir");
            JpsArtifactEntitiesSerializer.savePackagingElement$setPathAttribute(tag, "path", ((ExtractedDirectoryPackagingElementEntity)element).getFilePath());
            JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "path-in-jar", ((ExtractedDirectoryPackagingElementEntity)element).getPathInArchive());
        } else if (packagingElementEntity instanceof ArtifactOutputPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "artifact");
            ArtifactId artifactId = ((ArtifactOutputPackagingElementEntity)element).getArtifact();
            if (artifactId != null) {
                ArtifactId it = artifactId;
                boolean bl3 = false;
                JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "artifact-name", it.getName());
            }
        } else if (packagingElementEntity instanceof ModuleOutputPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "module-output");
            ModuleId moduleId = ((ModuleOutputPackagingElementEntity)element).getModule();
            if (moduleId != null) {
                ModuleId it = moduleId;
                boolean bl4 = false;
                JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "name", it.getName());
            }
        } else if (packagingElementEntity instanceof ModuleTestOutputPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "module-test-output");
            ModuleId moduleId = ((ModuleTestOutputPackagingElementEntity)element).getModule();
            if (moduleId != null) {
                ModuleId it = moduleId;
                boolean bl5 = false;
                JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "name", it.getName());
            }
        } else if (packagingElementEntity instanceof ModuleSourcePackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "module-source");
            ModuleId moduleId = ((ModuleSourcePackagingElementEntity)element).getModule();
            if (moduleId != null) {
                ModuleId it = moduleId;
                boolean bl6 = false;
                JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "name", it.getName());
            }
        } else if (packagingElementEntity instanceof LibraryFilesPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, "library");
            LibraryId library = ((LibraryFilesPackagingElementEntity)element).getLibrary();
            if (library != null) {
                LibraryTableId tableId = library.getTableId();
                JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "level", tableId.getLevel());
                JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "name", library.getName());
                if (tableId instanceof LibraryTableId.ModuleLibraryTableId) {
                    JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, "module-name", ((LibraryTableId.ModuleLibraryTableId)tableId).getModuleId().getName());
                }
            }
        } else if (packagingElementEntity instanceof CustomPackagingElementEntity) {
            JpsArtifactEntitiesSerializer.savePackagingElement$setId(tag, ((CustomPackagingElementEntity)element).getTypeId());
            Element element2 = JDOMUtil.load(((CustomPackagingElementEntity)element).getPropertiesXmlTag());
            Intrinsics.checkNotNullExpressionValue(element2, "load(...)");
            Element customElement = element2;
            List<Attribute> list2 = customElement.getAttributes();
            Intrinsics.checkNotNullExpressionValue(list2, "getAttributes(...)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Attribute attribute = (Attribute)element$iv;
                boolean bl7 = false;
                String string3 = attribute.getName();
                Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                String string4 = attribute.getValue();
                Intrinsics.checkNotNullExpressionValue(string4, "getValue(...)");
                JpsArtifactEntitiesSerializer.savePackagingElement$setAttribute(tag, string3, string4);
            }
            JpsArtifactEntitiesSerializer.savePackagingElement$saveElementChildren(tag, this, (CompositePackagingElementEntity)element);
        }
        return tag;
    }

    @NotNull
    public String toString() {
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        return StringsKt.substringAfterLast$default(string2, '.', null, 2, null) + "(" + this.getFileUrl() + ")";
    }

    private final String toPathWithScheme(String $this$toPathWithScheme) {
        return "file://" + FileUtil.toSystemIndependentName($this$toPathWithScheme);
    }

    /*
     * WARNING - void declaration
     */
    private static final ArrayList<PackagingElementEntity> loadPackagingElement$loadElementChildren(Element $element, JpsArtifactEntitiesSerializer this$0, EntitySource $source) {
        void $this$mapTo$iv;
        List<Element> list2 = $element.getChildren();
        Intrinsics.checkNotNullExpressionValue(list2, "getChildren(...)");
        Iterable iterable = list2;
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Element element = (Element)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull(it);
            collection.add(this$0.loadPackagingElement((Element)it, $source));
        }
        return (ArrayList)destination$iv;
    }

    private static final String loadPackagingElement$getAttribute(Element $element, String name2) {
        String string2 = $element.getAttributeValue(name2);
        Intrinsics.checkNotNull(string2);
        return string2;
    }

    private static final String loadPackagingElement$getOptionalAttribute(Element $element, String name2) {
        return $element.getAttributeValue(name2);
    }

    private static final VirtualFileUrl loadPackagingElement$getPathAttribute(Element $element, JpsArtifactEntitiesSerializer this$0, String name2) {
        String string2 = $element.getAttributeValue(name2);
        Intrinsics.checkNotNull(string2);
        String it = string2;
        boolean bl2 = false;
        return this$0.virtualFileManager.getOrCreateFromUri(this$0.toPathWithScheme(it));
    }

    private static final Element savePackagingElement$setId(Element tag, String typeId) {
        return tag.setAttribute("id", typeId);
    }

    private static final Element savePackagingElement$setAttribute(Element tag, String name2, String value) {
        return tag.setAttribute(name2, value);
    }

    private static final Element savePackagingElement$setPathAttribute(Element tag, String name2, VirtualFileUrl value) {
        return tag.setAttribute(name2, JpsPathUtil.urlToPath(value.getUrl()));
    }

    private static final void savePackagingElement$saveElementChildren(Element tag, JpsArtifactEntitiesSerializer this$0, CompositePackagingElementEntity composite) {
        Iterable $this$forEach$iv = composite.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PackagingElementEntity it = (PackagingElementEntity)element$iv;
            boolean bl2 = false;
            tag.addContent(this$0.savePackagingElement(it));
        }
    }

    public static final /* synthetic */ ArrayList access$loadPackagingElement$loadElementChildren(Element $element, JpsArtifactEntitiesSerializer this$0, EntitySource $source) {
        return JpsArtifactEntitiesSerializer.loadPackagingElement$loadElementChildren($element, this$0, $source);
    }

    public static final /* synthetic */ String access$loadPackagingElement$getOptionalAttribute(Element $element, String name2) {
        return JpsArtifactEntitiesSerializer.loadPackagingElement$getOptionalAttribute($element, name2);
    }

    static {
        Meter meter = JpsMetrics.getInstance().getMeter();
        Intrinsics.checkNotNullExpressionValue(meter, "getMeter(...)");
        JpsArtifactEntitiesSerializer.Companion.setupOpenTelemetryReporting(meter);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0016\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsArtifactEntitiesSerializer$Companion;", "", "()V", "loadEntitiesTimeMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "saveEntitiesTimeMs", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.platform.workspace.jps"})
    public static final class Companion {
        private Companion() {
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement loadEntitiesTimeCounter = meter.counterBuilder("jps.artifact.entities.serializer.load.entities.ms").buildObserver();
            ObservableLongMeasurement saveEntitiesTimeCounter = meter.counterBuilder("jps.artifact.entities.serializer.save.entities.ms").buildObserver();
            ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{saveEntitiesTimeCounter};
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(loadEntitiesTimeCounter, saveEntitiesTimeCounter), loadEntitiesTimeCounter, observableMeasurementArray);
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $loadEntitiesTimeCounter, ObservableLongMeasurement $saveEntitiesTimeCounter) {
            $loadEntitiesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(loadEntitiesTimeMs));
            $saveEntitiesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(saveEntitiesTimeMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

