/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.java.workspace.entities.ArtifactEntity;
import com.intellij.java.workspace.entities.ArtifactsOrderEntity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.jps.serialization.impl.FileInDirectorySourceNames;
import com.intellij.platform.workspace.jps.serialization.impl.JpsArtifactEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsArtifactsExternalFileSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntityTypeSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsLibrariesExternalFileSerializer;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.artifact.ArtifactState;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\"\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00150\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsArtifactsExternalFileSerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsArtifactEntitiesSerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntityTypeSerializer;", "Lcom/intellij/java/workspace/entities/ArtifactEntity;", "externalFile", "Lcom/intellij/platform/workspace/jps/JpsProjectFileEntitySource$ExactFile;", "internalArtifactsDirUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "fileInDirectorySourceNames", "Lcom/intellij/platform/workspace/jps/serialization/impl/FileInDirectorySourceNames;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "(Lcom/intellij/platform/workspace/jps/JpsProjectFileEntitySource$ExactFile;Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/jps/serialization/impl/FileInDirectorySourceNames;Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;)V", "additionalEntityTypes", "", "Ljava/lang/Class;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "getAdditionalEntityTypes", "()Ljava/util/List;", "entityFilter", "Lkotlin/Function1;", "", "getEntityFilter", "()Lkotlin/jvm/functions/Function1;", "isExternalStorage", "()Z", "createEntitySource", "Lcom/intellij/platform/workspace/storage/EntitySource;", "artifactTag", "Lorg/jdom/Element;", "deleteObsoleteFile", "", "fileUrl", "", "writer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nJpsArtifactEntitiesSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsArtifactEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsArtifactsExternalFileSerializer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,438:1\n11#2:439\n46#2,5:440\n*S KotlinDebug\n*F\n+ 1 JpsArtifactEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsArtifactsExternalFileSerializer\n*L\n111#1:439\n111#1:440,5\n*E\n"})
public final class JpsArtifactsExternalFileSerializer
extends JpsArtifactEntitiesSerializer
implements JpsFileEntityTypeSerializer<ArtifactEntity> {
    @NotNull
    private final JpsProjectFileEntitySource.ExactFile externalFile;
    @NotNull
    private final VirtualFileUrl internalArtifactsDirUrl;
    @NotNull
    private final FileInDirectorySourceNames fileInDirectorySourceNames;

    public JpsArtifactsExternalFileSerializer(@NotNull JpsProjectFileEntitySource.ExactFile externalFile, @NotNull VirtualFileUrl internalArtifactsDirUrl, @NotNull FileInDirectorySourceNames fileInDirectorySourceNames, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter(externalFile, "externalFile");
        Intrinsics.checkNotNullParameter(internalArtifactsDirUrl, "internalArtifactsDirUrl");
        Intrinsics.checkNotNullParameter(fileInDirectorySourceNames, "fileInDirectorySourceNames");
        Intrinsics.checkNotNullParameter(virtualFileManager, "virtualFileManager");
        super(externalFile.getFile(), externalFile, false, virtualFileManager);
        this.externalFile = externalFile;
        this.internalArtifactsDirUrl = internalArtifactsDirUrl;
        this.fileInDirectorySourceNames = fileInDirectorySourceNames;
    }

    @Override
    public boolean isExternalStorage() {
        return true;
    }

    @Override
    @NotNull
    public Function1<ArtifactEntity, Boolean> getEntityFilter() {
        return entityFilter.1.INSTANCE;
    }

    @Override
    @NotNull
    public List<Class<? extends WorkspaceEntity>> getAdditionalEntityTypes() {
        return CollectionsKt.listOf(ArtifactsOrderEntity.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected EntitySource createEntitySource(@NotNull Element artifactTag) {
        JpsProjectFileEntitySource.FileInDirectory fileInDirectory;
        Intrinsics.checkNotNullParameter(artifactTag, "artifactTag");
        String string2 = artifactTag.getAttributeValue("__external-system-id");
        if (string2 == null) {
            return null;
        }
        String externalSystemId = string2;
        String artifactName = XmlSerializer.deserialize(artifactTag, ArtifactState.class).getName();
        Class<ArtifactEntity> clazz = this.getMainEntityClass();
        Intrinsics.checkNotNull(artifactName);
        JpsProjectFileEntitySource.FileInDirectory existingInternalSource = this.fileInDirectorySourceNames.findSource(clazz, artifactName);
        if (existingInternalSource != null && Intrinsics.areEqual(existingInternalSource.getDirectory(), this.internalArtifactsDirUrl)) {
            void $this$debug_u24default$iv;
            boolean $i$f$logger22 = false;
            Logger logger = Logger.getInstance(JpsLibrariesExternalFileSerializer.class);
            Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
            Logger $i$f$logger22 = logger;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                void var10_9 = $this$debug_u24default$iv;
                boolean bl2 = false;
                var10_9.debug("Reuse existing source for artifact: " + existingInternalSource.getFileNameId() + "=" + artifactName, e$iv);
            }
            fileInDirectory = existingInternalSource;
        } else {
            fileInDirectory = new JpsProjectFileEntitySource.FileInDirectory(this.internalArtifactsDirUrl, this.externalFile.getProjectLocation());
        }
        JpsProjectFileEntitySource.FileInDirectory internalEntitySource = fileInDirectory;
        return new JpsImportedEntitySource(internalEntitySource, externalSystemId, true);
    }

    @Override
    public void deleteObsoleteFile(@NotNull String fileUrl, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter(fileUrl, "fileUrl");
        Intrinsics.checkNotNullParameter(writer, "writer");
        writer.saveComponent(fileUrl, "ArtifactManager", null);
    }
}

