/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsProjectConfigLocation;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.jps.serialization.impl.JpsExternalStorageMapping;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.PathUtilRt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsExternalStorageMappingImpl;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsExternalStorageMapping;", "externalStorageRoot", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "projectLocation", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;)V", "getExternalStorageRoot", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "getExternalSource", "Lcom/intellij/platform/workspace/jps/JpsProjectFileEntitySource;", "internalSource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "intellij.platform.workspace.jps"})
public final class JpsExternalStorageMappingImpl
implements JpsExternalStorageMapping {
    @NotNull
    private final VirtualFileUrl externalStorageRoot;
    @NotNull
    private final JpsProjectConfigLocation projectLocation;

    public JpsExternalStorageMappingImpl(@NotNull VirtualFileUrl externalStorageRoot, @NotNull JpsProjectConfigLocation projectLocation) {
        Intrinsics.checkNotNullParameter(externalStorageRoot, "externalStorageRoot");
        Intrinsics.checkNotNullParameter(projectLocation, "projectLocation");
        this.externalStorageRoot = externalStorageRoot;
        this.projectLocation = projectLocation;
    }

    @Override
    @NotNull
    public VirtualFileUrl getExternalStorageRoot() {
        return this.externalStorageRoot;
    }

    @Override
    @NotNull
    public JpsProjectFileEntitySource getExternalSource(@NotNull JpsFileEntitySource internalSource) {
        JpsProjectFileEntitySource jpsProjectFileEntitySource;
        Intrinsics.checkNotNullParameter(internalSource, "internalSource");
        if (internalSource instanceof JpsProjectFileEntitySource.FileInDirectory) {
            String directoryPath = JpsPathUtil.urlToPath(((JpsProjectFileEntitySource.FileInDirectory)internalSource).getDirectory().getUrl());
            String string2 = PathUtilRt.getFileName(directoryPath);
            Intrinsics.checkNotNullExpressionValue(string2, "getFileName(...)");
            String directoryName = string2;
            String string3 = PathUtilRt.getParentPath(directoryPath);
            Intrinsics.checkNotNullExpressionValue(string3, "getParentPath(...)");
            String parentPath = string3;
            if (Intrinsics.areEqual(PathUtilRt.getFileName(parentPath), ".idea") && (Intrinsics.areEqual(directoryName, "libraries") || Intrinsics.areEqual(directoryName, "artifacts"))) {
                VirtualFileUrl virtualFileUrl = this.getExternalStorageRoot().append("project/" + directoryName + ".xml");
                Intrinsics.checkNotNullExpressionValue(virtualFileUrl, "append(...)");
                jpsProjectFileEntitySource = new JpsProjectFileEntitySource.ExactFile(virtualFileUrl, this.projectLocation);
            } else {
                VirtualFileUrl virtualFileUrl = this.getExternalStorageRoot().append("modules");
                Intrinsics.checkNotNullExpressionValue(virtualFileUrl, "append(...)");
                jpsProjectFileEntitySource = new JpsProjectFileEntitySource.FileInDirectory(virtualFileUrl, this.projectLocation);
            }
        } else {
            throw new IllegalArgumentException("Unsupported internal entity source " + internalSource);
        }
        return jpsProjectFileEntitySource;
    }
}

