/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.serialization.impl.FileInDirectorySourceNames;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntityTypeSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsLibrariesExternalFileSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsLibraryEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsProjectSerializersImplKt;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsLibrariesExternalFileSerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsLibraryEntitiesSerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntityTypeSerializer;", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "externalFile", "Lcom/intellij/platform/workspace/jps/JpsProjectFileEntitySource$ExactFile;", "internalLibrariesDirUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "fileInDirectorySourceNames", "Lcom/intellij/platform/workspace/jps/serialization/impl/FileInDirectorySourceNames;", "(Lcom/intellij/platform/workspace/jps/JpsProjectFileEntitySource$ExactFile;Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/jps/serialization/impl/FileInDirectorySourceNames;)V", "entityFilter", "Lkotlin/Function1;", "", "getEntityFilter", "()Lkotlin/jvm/functions/Function1;", "isExternalStorage", "()Z", "createEntitySource", "Lcom/intellij/platform/workspace/storage/EntitySource;", "libraryTag", "Lorg/jdom/Element;", "deleteObsoleteFile", "", "fileUrl", "", "writer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nJpsLibraryEntitiesSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsLibraryEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsLibrariesExternalFileSerializer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,338:1\n11#2:339\n46#2,5:340\n*S KotlinDebug\n*F\n+ 1 JpsLibraryEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsLibrariesExternalFileSerializer\n*L\n111#1:339\n111#1:340,5\n*E\n"})
public final class JpsLibrariesExternalFileSerializer
extends JpsLibraryEntitiesSerializer
implements JpsFileEntityTypeSerializer<LibraryEntity> {
    @NotNull
    private final JpsProjectFileEntitySource.ExactFile externalFile;
    @NotNull
    private final VirtualFileUrl internalLibrariesDirUrl;
    @NotNull
    private final FileInDirectorySourceNames fileInDirectorySourceNames;

    public JpsLibrariesExternalFileSerializer(@NotNull JpsProjectFileEntitySource.ExactFile externalFile, @NotNull VirtualFileUrl internalLibrariesDirUrl, @NotNull FileInDirectorySourceNames fileInDirectorySourceNames) {
        Intrinsics.checkNotNullParameter(externalFile, "externalFile");
        Intrinsics.checkNotNullParameter(internalLibrariesDirUrl, "internalLibrariesDirUrl");
        Intrinsics.checkNotNullParameter(fileInDirectorySourceNames, "fileInDirectorySourceNames");
        super(externalFile.getFile(), externalFile, LibraryTableId.ProjectLibraryTableId.INSTANCE);
        this.externalFile = externalFile;
        this.internalLibrariesDirUrl = internalLibrariesDirUrl;
        this.fileInDirectorySourceNames = fileInDirectorySourceNames;
    }

    @Override
    public boolean isExternalStorage() {
        return true;
    }

    @Override
    @NotNull
    public Function1<LibraryEntity, Boolean> getEntityFilter() {
        return entityFilter.1.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected EntitySource createEntitySource(@NotNull Element libraryTag) {
        JpsProjectFileEntitySource.FileInDirectory fileInDirectory;
        Intrinsics.checkNotNullParameter(libraryTag, "libraryTag");
        String string2 = libraryTag.getAttributeValue("__external-system-id");
        if (string2 == null) {
            return null;
        }
        String externalSystemId = string2;
        String libraryName = JpsProjectSerializersImplKt.getAttributeValueStrict(libraryTag, "name");
        JpsProjectFileEntitySource.FileInDirectory existingInternalSource = this.fileInDirectorySourceNames.findSource(this.getMainEntityClass(), libraryName);
        if (existingInternalSource != null && Intrinsics.areEqual(existingInternalSource.getDirectory(), this.internalLibrariesDirUrl)) {
            void $this$debug_u24default$iv;
            boolean $i$f$logger22 = false;
            Logger logger = Logger.getInstance(JpsLibrariesExternalFileSerializer.class);
            Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
            Logger $i$f$logger22 = logger;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                void var10_9 = $this$debug_u24default$iv;
                boolean bl2 = false;
                var10_9.debug("Reuse existing source for library: " + existingInternalSource.getFileNameId() + "=" + libraryName, e$iv);
            }
            fileInDirectory = existingInternalSource;
        } else {
            fileInDirectory = new JpsProjectFileEntitySource.FileInDirectory(this.internalLibrariesDirUrl, this.externalFile.getProjectLocation());
        }
        JpsProjectFileEntitySource.FileInDirectory internalEntitySource = fileInDirectory;
        return new JpsImportedEntitySource(internalEntitySource, externalSystemId, true);
    }

    @Override
    public void deleteObsoleteFile(@NotNull String fileUrl, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter(fileUrl, "fileUrl");
        Intrinsics.checkNotNullParameter(writer, "writer");
        writer.saveComponent(fileUrl, "libraryTable", null);
    }
}

