/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.JpsMetrics;
import com.intellij.platform.workspace.jps.entities.DependenciesKt;
import com.intellij.platform.workspace.jps.entities.ExcludeUrlEntity;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryPropertiesEntity;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.entities.Library_extensionsKt;
import com.intellij.platform.workspace.jps.serialization.impl.ErrorReporter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsLibraryEntitiesSerializerKt;
import com.intellij.platform.workspace.jps.serialization.impl.JpsProjectSerializersImplKt;
import com.intellij.platform.workspace.jps.serialization.impl.LibraryNameGenerator;
import com.intellij.platform.workspace.jps.serialization.impl.LoadingResult;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 62\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00016B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ:\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2 \u0010\u001c\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001f0\u001dH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0014J@\u0010$\u001a\"\u0012\u001e\u0012\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001f0\u001d0%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016JH\u0010,\u001a\u00020\u00182\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2 \u0010.\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0/0\u001d2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000205H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00067"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsLibraryEntitiesSerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntitiesSerializer;", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "fileUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "internalEntitySource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "libraryTableId", "Lcom/intellij/platform/workspace/jps/entities/LibraryTableId;", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;Lcom/intellij/platform/workspace/jps/entities/LibraryTableId;)V", "getFileUrl", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "getInternalEntitySource", "()Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "isExternalStorage", "", "()Z", "getLibraryTableId", "()Lcom/intellij/platform/workspace/jps/entities/LibraryTableId;", "mainEntityClass", "Ljava/lang/Class;", "getMainEntityClass", "()Ljava/lang/Class;", "checkAndAddToBuilder", "", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "orphanage", "newEntities", "", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "", "createEntitySource", "Lcom/intellij/platform/workspace/storage/EntitySource;", "libraryTag", "Lorg/jdom/Element;", "loadEntities", "Lcom/intellij/platform/workspace/jps/serialization/impl/LoadingResult;", "reader", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentReader;", "errorReporter", "Lcom/intellij/platform/workspace/jps/serialization/impl/ErrorReporter;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "saveEntities", "mainEntities", "entities", "", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "writer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "toString", "", "Companion", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nJpsLibraryEntitiesSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsLibraryEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsLibraryEntitiesSerializer\n+ 2 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 LoadingResult.kt\ncom/intellij/platform/workspace/jps/serialization/impl/LoadingResultKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,338:1\n44#2,2:339\n46#2:409\n44#2,2:415\n46#2:426\n17#3,5:341\n22#3:408\n17#3,5:417\n22#3:425\n21#4,11:346\n21#4,11:358\n21#4,11:379\n1#5:357\n1#5:390\n1#5:403\n1603#6,9:369\n1855#6:378\n1856#6:391\n1612#6:392\n1603#6,9:393\n1855#6:402\n1856#6:404\n1612#6:405\n288#6,2:406\n1855#6:410\n1856#6:412\n1855#6,2:413\n1045#6:422\n1855#6,2:423\n9#7:411\n*S KotlinDebug\n*F\n+ 1 JpsLibraryEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsLibraryEntitiesSerializer\n*L\n138#1:339,2\n138#1:409\n187#1:415,2\n187#1:426\n138#1:341,5\n138#1:408\n187#1:417,5\n187#1:425\n139#1:346,11\n142#1:358,11\n146#1:379,11\n145#1:390\n154#1:403\n145#1:369,9\n145#1:378\n145#1:391\n145#1:392\n154#1:393,9\n154#1:402\n154#1:404\n154#1:405\n155#1:406,2\n164#1:410\n164#1:412\n176#1:413,2\n191#1:422\n191#1:423,2\n166#1:411\n*E\n"})
public class JpsLibraryEntitiesSerializer
implements JpsFileEntitiesSerializer<LibraryEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFileUrl fileUrl;
    @NotNull
    private final JpsFileEntitySource internalEntitySource;
    @NotNull
    private final LibraryTableId libraryTableId;
    @NotNull
    private static final AtomicLong loadEntitiesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
    @NotNull
    private static final AtomicLong saveEntitiesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);

    public JpsLibraryEntitiesSerializer(@NotNull VirtualFileUrl fileUrl, @NotNull JpsFileEntitySource internalEntitySource, @NotNull LibraryTableId libraryTableId) {
        Intrinsics.checkNotNullParameter(fileUrl, "fileUrl");
        Intrinsics.checkNotNullParameter(internalEntitySource, "internalEntitySource");
        Intrinsics.checkNotNullParameter(libraryTableId, "libraryTableId");
        this.fileUrl = fileUrl;
        this.internalEntitySource = internalEntitySource;
        this.libraryTableId = libraryTableId;
    }

    @Override
    @NotNull
    public VirtualFileUrl getFileUrl() {
        return this.fileUrl;
    }

    @Override
    @NotNull
    public JpsFileEntitySource getInternalEntitySource() {
        return this.internalEntitySource;
    }

    @NotNull
    protected final LibraryTableId getLibraryTableId() {
        return this.libraryTableId;
    }

    public boolean isExternalStorage() {
        return false;
    }

    @Override
    @NotNull
    public Class<LibraryEntity> getMainEntityClass() {
        return LibraryEntity.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LoadingResult<Map<Class<? extends WorkspaceEntity>, Collection<WorkspaceEntity>>> loadEntities(@NotNull JpsFileContentReader reader, @NotNull ErrorReporter errorReporter, @NotNull VirtualFileUrlManager virtualFileManager) {
        LoadingResult<Object> loadingResult;
        Object object;
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(errorReporter, "errorReporter");
        Intrinsics.checkNotNullParameter(virtualFileManager, "virtualFileManager");
        AtomicLong arg0$iv = loadEntitiesTimeMs;
        boolean bl2 = false;
        LoadingResult<Object> value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        Object $this$runCatchingXmlIssues$iv = this;
        boolean $i$f$runCatchingXmlIssues = false;
        try {
            boolean bl5 = false;
            String string2 = this.getFileUrl().getUrl();
            Intrinsics.checkNotNullExpressionValue(string2, "getUrl(...)");
            object = Result.constructor-impl(JpsFileContentReader.loadComponent$default(reader, string2, "libraryTable", null, 4, null));
        }
        catch (JDOMException e$iv) {
            object = Result.constructor-impl(ResultKt.createFailure(e$iv));
        }
        catch (IOException e$iv) {
            object = Result.constructor-impl(ResultKt.createFailure(e$iv));
        }
        $this$runCatchingXmlIssues$iv = object;
        Throwable throwable = Result.exceptionOrNull-impl($this$runCatchingXmlIssues$iv);
        if (throwable != null) {
            Throwable it = $i$f$runCatchingXmlIssues = throwable;
            boolean bl6 = false;
            loadingResult = new LoadingResult<Object>(MapsKt.emptyMap(), null);
        } else {
            ResultKt.throwOnFailure($this$runCatchingXmlIssues$iv);
            Element element = (Element)$this$runCatchingXmlIssues$iv;
            if (element == null) {
                loadingResult = new LoadingResult<Object>(MapsKt.emptyMap(), null);
            } else {
                Object e$iv;
                Element libraryTableTag = element;
                Object $this$runCatchingXmlIssues$iv2 = this;
                boolean $i$f$runCatchingXmlIssues22 = false;
                try {
                    boolean bl7 = false;
                    e$iv = Result.constructor-impl(libraryTableTag.getChildren("library"));
                }
                catch (JDOMException e$iv2) {
                    e$iv = Result.constructor-impl(ResultKt.createFailure(e$iv2));
                }
                catch (IOException e$iv3) {
                    e$iv = Result.constructor-impl(ResultKt.createFailure(e$iv3));
                }
                $this$runCatchingXmlIssues$iv2 = e$iv;
                Throwable throwable2 = Result.exceptionOrNull-impl($this$runCatchingXmlIssues$iv2);
                if (throwable2 != null) {
                    Throwable it = $i$f$runCatchingXmlIssues22 = throwable2;
                    boolean bl8 = false;
                    loadingResult = new LoadingResult<Object>(MapsKt.emptyMap(), null);
                } else {
                    Object v7;
                    Object object2;
                    block20: {
                        void $this$firstOrNull$iv;
                        boolean bl9;
                        Object element$iv$iv;
                        Object element$iv$iv$iv;
                        Iterable $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv;
                        ResultKt.throwOnFailure($this$runCatchingXmlIssues$iv2);
                        Object object3 = $this$runCatchingXmlIssues$iv2;
                        Intrinsics.checkNotNullExpressionValue(object3, "getOrThrow(...)");
                        $this$runCatchingXmlIssues$iv = (Iterable)object3;
                        boolean $i$f$mapNotNull = false;
                        void $i$f$runCatchingXmlIssues22 = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            Result result2;
                            block19: {
                                Object object4;
                                element$iv$iv = element$iv$iv$iv = iterator2.next();
                                bl9 = false;
                                Element libraryTag = (Element)element$iv$iv;
                                boolean bl10 = false;
                                JpsFileEntitiesSerializer $this$runCatchingXmlIssues$iv3 = this;
                                boolean $i$f$runCatchingXmlIssues3 = false;
                                try {
                                    EntitySource source;
                                    boolean bl11 = false;
                                    Intrinsics.checkNotNull(libraryTag);
                                    if (this.createEntitySource(libraryTag) == null) {
                                        result2 = null;
                                        break block19;
                                    }
                                    String name2 = JpsProjectSerializersImplKt.getAttributeValueStrict(libraryTag, "name");
                                    object4 = Result.constructor-impl(Companion.loadLibrary(name2, libraryTag, this.libraryTableId, source, virtualFileManager));
                                }
                                catch (JDOMException e$iv4) {
                                    object4 = Result.constructor-impl(ResultKt.createFailure(e$iv4));
                                }
                                catch (IOException e$iv5) {
                                    object4 = Result.constructor-impl(ResultKt.createFailure(e$iv5));
                                }
                                result2 = Result.box-impl(object4);
                            }
                            if (result2 == null) continue;
                            Result it$iv$iv = result2;
                            boolean bl12 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List libs = (List)destination$iv$iv;
                        $this$mapNotNull$iv = libs;
                        object2 = LibraryEntity.class;
                        $i$f$mapNotNull = false;
                        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                        destination$iv$iv = new ArrayList();
                        $i$f$mapNotNullTo = false;
                        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        $i$f$forEach = false;
                        iterator2 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            LibraryEntity it$iv$iv;
                            element$iv$iv = element$iv$iv$iv = iterator2.next();
                            bl9 = false;
                            Object it = ((Result)element$iv$iv).unbox-impl();
                            boolean bl13 = false;
                            if ((LibraryEntity)(Result.isFailure-impl(it) ? null : it) == null) continue;
                            boolean bl14 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        Iterable $i$f$mapNotNull2 = libs;
                        object2 = MapsKt.mapOf(TuplesKt.to(object2, (List)destination$iv$iv));
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Object it = ((Result)element$iv).unbox-impl();
                            boolean bl15 = false;
                            if (!Result.isFailure-impl(it)) continue;
                            v7 = element$iv;
                            break block20;
                        }
                        v7 = null;
                    }
                    Result result3 = v7;
                    Throwable throwable3 = result3 != null ? Result.exceptionOrNull-impl(result3.unbox-impl()) : null;
                    Object object5 = object2;
                    loadingResult = new LoadingResult<Object>(object5, throwable3);
                }
            }
        }
        value$iv = loadingResult;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    @Override
    public void checkAndAddToBuilder(@NotNull MutableEntityStorage builder, @NotNull MutableEntityStorage orphanage, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity>> newEntities) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(orphanage, "orphanage");
        Intrinsics.checkNotNullParameter(newEntities, "newEntities");
        Collection<? extends WorkspaceEntity> collection = newEntities.get(LibraryEntity.class);
        List list2 = collection instanceof List ? (List)collection : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List libraries = list2;
        Iterable $this$forEach$iv = libraries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryEntity it = (LibraryEntity)element$iv;
            boolean bl2 = false;
            if (!builder.contains(it.getSymbolicId())) continue;
            JpsLibraryEntitiesSerializer $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JpsLibraryEntitiesSerializer.class);
            Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
            logger.error(StringsKt.trimMargin$default("Error during entities loading\n            |Entity with this library id already exists.\n            |Library id: " + it.getSymbolicId() + "\n            |fileUrl: " + this.getFileUrl().getPresentableUrl() + "\n            |library table id: " + it.getTableId() + "\n            |internal entity source: " + this.getInternalEntitySource() + "\n          ", null, 1, null));
        }
        $this$forEach$iv = newEntities.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection lists = (Collection)element$iv;
            boolean bl3 = false;
            Iterable $this$forEach$iv2 = lists;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                WorkspaceEntity it = (WorkspaceEntity)element$iv2;
                boolean bl4 = false;
                builder.addEntity(it);
            }
        }
    }

    @Nullable
    protected EntitySource createEntitySource(@NotNull Element libraryTag) {
        Intrinsics.checkNotNullParameter(libraryTag, "libraryTag");
        String externalSystemId = libraryTag.getAttributeValue("external-system-id");
        return externalSystemId == null ? (EntitySource)this.getInternalEntitySource() : (EntitySource)new JpsImportedEntitySource(this.getInternalEntitySource(), externalSystemId, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveEntities(@NotNull Collection<? extends LibraryEntity> mainEntities, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends List<? extends WorkspaceEntity>> entities2, @NotNull EntityStorage storage, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter(mainEntities, "mainEntities");
        Intrinsics.checkNotNullParameter(entities2, "entities");
        Intrinsics.checkNotNullParameter(storage, "storage");
        Intrinsics.checkNotNullParameter(writer, "writer");
        AtomicLong arg0$iv = saveEntitiesTimeMs;
        boolean bl2 = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!mainEntities.isEmpty()) {
            void $this$forEach$iv;
            Element componentTag = JDomSerializationUtil.createComponentElement("libraryTable");
            Iterable $this$sortedBy$iv = mainEntities;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a2, T b2) {
                    LibraryEntity it = (LibraryEntity)a2;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (LibraryEntity)b2;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LibraryEntity it = (LibraryEntity)element$iv;
                boolean bl5 = false;
                EntitySource entitySource = it.getEntitySource();
                JpsImportedEntitySource jpsImportedEntitySource = entitySource instanceof JpsImportedEntitySource ? (JpsImportedEntitySource)entitySource : null;
                String externalSystemId = jpsImportedEntitySource != null ? jpsImportedEntitySource.getExternalSystemId() : null;
                componentTag.addContent(Companion.saveLibrary(it, externalSystemId, this.isExternalStorage()));
            }
            String string2 = this.getFileUrl().getUrl();
            Intrinsics.checkNotNullExpressionValue(string2, "getUrl(...)");
            writer.saveComponent(string2, "libraryTable", componentTag);
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    @NotNull
    public String toString() {
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        return StringsKt.substringAfterLast$default(string2, '.', null, 2, null) + "(" + this.getFileUrl() + ")";
    }

    static {
        Meter meter = JpsMetrics.getInstance().getMeter();
        Intrinsics.checkNotNullExpressionValue(meter, "getMeter(...)");
        JpsLibraryEntitiesSerializer.Companion.setupOpenTelemetryReporting(meter);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0016\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsLibraryEntitiesSerializer$Companion;", "", "()V", "loadEntitiesTimeMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "saveEntitiesTimeMs", "loadLibrary", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "name", "", "libraryElement", "Lorg/jdom/Element;", "libraryTableId", "Lcom/intellij/platform/workspace/jps/entities/LibraryTableId;", "source", "Lcom/intellij/platform/workspace/storage/EntitySource;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "saveLibrary", "library", "externalSystemId", "isExternalStorage", "", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.platform.workspace.jps"})
    @SourceDebugExtension(value={"SMAP\nJpsLibraryEntitiesSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsLibraryEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsLibraryEntitiesSerializer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,338:1\n1502#2,3:339\n1505#2,3:349\n1855#2,2:352\n1855#2:354\n1855#2,2:355\n1855#2,2:357\n1856#2:359\n1855#2,2:360\n1855#2,2:362\n1208#2,2:364\n1238#2,4:366\n1549#2:370\n1620#2,3:371\n1549#2:374\n1620#2,3:375\n1549#2:378\n1620#2,3:379\n372#3,7:342\n*S KotlinDebug\n*F\n+ 1 JpsLibraryEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsLibraryEntitiesSerializer$Companion\n*L\n221#1:339,3\n221#1:349,3\n222#1:352,2\n226#1:354\n228#1:355,2\n231#1:357,2\n226#1:359\n248#1:360,2\n253#1:362,2\n263#1:364,2\n263#1:366,4\n280#1:370\n280#1:371,3\n281#1:374\n281#1:375,3\n303#1:378\n303#1:379,3\n221#1:342,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Element saveLibrary(@NotNull LibraryEntity library, @Nullable String externalSystemId, boolean isExternalStorage) {
            void $this$groupByTo$iv;
            LibraryPropertiesEntity customProperties;
            Intrinsics.checkNotNullParameter(library, "library");
            Element libraryTag = new Element("library");
            String legacyName = LibraryNameGenerator.INSTANCE.getLegacyLibraryName(library.getSymbolicId());
            if (legacyName != null) {
                libraryTag.setAttribute("name", legacyName);
            }
            if ((customProperties = Library_extensionsKt.getLibraryProperties(library)) != null) {
                libraryTag.setAttribute("type", customProperties.getLibraryType());
                String propertiesXmlTag = customProperties.getPropertiesXmlTag();
                if (propertiesXmlTag != null) {
                    libraryTag.addContent(JDOMUtil.load(propertiesXmlTag));
                }
            }
            if (externalSystemId != null) {
                String attributeName = isExternalStorage ? "__external-system-id" : "external-system-id";
                libraryTag.setAttribute(attributeName, externalSystemId);
            }
            Iterable iterable = library.getRoots();
            Map destination$iv = new HashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv : $this$groupByTo$iv) {
                Object object;
                LibraryRoot it = (LibraryRoot)element$iv;
                boolean bl2 = false;
                LibraryRootTypeId key$iv = it.getType();
                Map $this$getOrPut$iv$iv = destination$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
                if (value$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                List list$iv = (List)object;
                list$iv.add(element$iv);
            }
            HashMap rootsMap = (HashMap)destination$iv;
            Iterable $this$forEach$iv = JpsLibraryEntitiesSerializerKt.access$getROOT_TYPES_TO_WRITE_EMPTY_TAG$p();
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                LibraryRootTypeId it = (LibraryRootTypeId)element$iv;
                boolean bl4 = false;
                rootsMap.putIfAbsent(it, new ArrayList());
            }
            ArrayList<Element> jarDirectoriesTags = new ArrayList<Element>();
            Set set = rootsMap.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
            Comparator<String> $i$f$forEach22 = StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE);
            Iterable $this$forEach$iv2 = CollectionsKt.sortedWith(set, new Comparator($i$f$forEach22){
                final /* synthetic */ Comparator $comparator;
                {
                    this.$comparator = $comparator;
                }

                public final int compare(T a2, T b2) {
                    Map.Entry entry = (Map.Entry)a2;
                    Comparator comparator = this.$comparator;
                    boolean bl2 = false;
                    Map.Entry it = (Map.Entry)b2;
                    String string2 = ((LibraryRootTypeId)it.getKey()).getName();
                    bl2 = false;
                    String string3 = ((LibraryRootTypeId)it.getKey()).getName();
                    return comparator.compare(string2, string3);
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                LibraryRoot it;
                Object element$iv2;
                Map.Entry bl4 = (Map.Entry)element$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNull(bl4);
                LibraryRootTypeId rootType = (LibraryRootTypeId)bl4.getKey();
                List roots = (List)bl4.getValue();
                Element rootTypeTag = new Element(rootType.getName());
                Intrinsics.checkNotNull(roots);
                Object $this$forEach$iv3 = roots;
                boolean $i$f$forEach3 = false;
                Iterator iterator2 = $this$forEach$iv3.iterator();
                while (iterator2.hasNext()) {
                    element$iv2 = iterator2.next();
                    it = (LibraryRoot)element$iv2;
                    boolean bl6 = false;
                    rootTypeTag.addContent(new Element("root").setAttribute("url", it.getUrl().getUrl()));
                }
                $this$forEach$iv3 = StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE);
                $this$forEach$iv3 = CollectionsKt.sortedWith(roots, new Comparator((Comparator)$this$forEach$iv3){
                    final /* synthetic */ Comparator $comparator;
                    {
                        this.$comparator = $comparator;
                    }

                    public final int compare(T a2, T b2) {
                        LibraryRoot libraryRoot = (LibraryRoot)a2;
                        Comparator comparator = this.$comparator;
                        boolean bl2 = false;
                        LibraryRoot it = (LibraryRoot)b2;
                        String string2 = it.getUrl().getUrl();
                        bl2 = false;
                        String string3 = it.getUrl().getUrl();
                        return comparator.compare(string2, string3);
                    }
                });
                $i$f$forEach3 = false;
                iterator2 = $this$forEach$iv3.iterator();
                while (iterator2.hasNext()) {
                    element$iv2 = iterator2.next();
                    it = (LibraryRoot)element$iv2;
                    boolean bl7 = false;
                    if (it.getInclusionOptions() == LibraryRoot.InclusionOptions.ROOT_ITSELF) continue;
                    Element jarDirectoryTag = new Element("jarDirectory");
                    jarDirectoryTag.setAttribute("url", it.getUrl().getUrl());
                    jarDirectoryTag.setAttribute("recursive", String.valueOf(it.getInclusionOptions() == LibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT_RECURSIVELY));
                    if (!Intrinsics.areEqual(rootType.getName(), "CLASSES")) {
                        jarDirectoryTag.setAttribute("type", rootType.getName());
                    }
                    jarDirectoriesTags.add(jarDirectoryTag);
                }
                libraryTag.addContent(rootTypeTag);
            }
            List<ExcludeUrlEntity> excludedRoots = library.getExcludedRoots();
            if (!((Collection)excludedRoots).isEmpty()) {
                Element excludedTag = new Element("excluded");
                Iterable $this$forEach$iv4 = excludedRoots;
                boolean $i$f$forEach4 = false;
                for (Object element$iv : $this$forEach$iv4) {
                    ExcludeUrlEntity it = (ExcludeUrlEntity)element$iv;
                    boolean bl8 = false;
                    excludedTag.addContent(new Element("root").setAttribute("url", it.getUrl().getUrl()));
                }
                libraryTag.addContent(excludedTag);
            }
            Iterable $this$forEach$iv5 = jarDirectoriesTags;
            boolean $i$f$forEach5 = false;
            for (Object element$iv : $this$forEach$iv5) {
                Element it = (Element)element$iv;
                boolean bl9 = false;
                libraryTag.addContent(it);
            }
            return libraryTag;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final LibraryEntity loadLibrary(@NotNull String name2, @NotNull Element libraryElement, @NotNull LibraryTableId libraryTableId, @NotNull EntitySource source, @NotNull VirtualFileUrlManager virtualFileManager) {
            void $this$mapTo$iv$iv;
            LibraryPropertiesEntity libraryPropertiesEntity;
            Object object;
            Object object2;
            void $this$associateByTo$iv$iv;
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter(libraryElement, "libraryElement");
            Intrinsics.checkNotNullParameter(libraryTableId, "libraryTableId");
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(virtualFileManager, "virtualFileManager");
            ArrayList<LibraryRoot> roots = new ArrayList<LibraryRoot>();
            ArrayList excludedRoots = new ArrayList();
            List<Element> list2 = libraryElement.getChildren("jarDirectory");
            Intrinsics.checkNotNullExpressionValue(list2, "getChildren(...)");
            Iterable $this$associateBy$iv = list2;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            Iterable iterable = $this$associateBy$iv;
            Object destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                String string2;
                Element it;
                Element element = (Element)element$iv$iv;
                object2 = destination$iv$iv;
                boolean bl2 = false;
                Iterator iterator2 = it.getAttributeValue("type");
                String string3 = iterator2;
                if (string3 == null) {
                    string2 = "CLASSES";
                } else {
                    Intrinsics.checkNotNull(string3);
                    string2 = iterator2;
                }
                Intrinsics.checkNotNull(it);
                it = (Element)element$iv$iv;
                object = new Pair<String, String>(string2, JpsProjectSerializersImplKt.getAttributeValueStrict(it, "url"));
                boolean bl3 = false;
                String string4 = it.getAttributeValue("recursive");
                LibraryRoot.InclusionOptions inclusionOptions = (string4 != null ? Boolean.parseBoolean(string4) : false) ? LibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT_RECURSIVELY : LibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT;
                object2.put(object, inclusionOptions);
            }
            Map jarDirectories = destination$iv$iv;
            String type = libraryElement.getAttributeValue("type");
            Ref.ObjectRef<String> properties = new Ref.ObjectRef<String>();
            block11: for (Element childElement : libraryElement.getChildren()) {
                block24: {
                    destination$iv$iv = childElement.getName();
                    if (destination$iv$iv == null) break block24;
                    int n2 = -1;
                    switch (((String)destination$iv$iv).hashCode()) {
                        case 1994055114: {
                            if (((String)destination$iv$iv).equals("excluded")) {
                                n2 = 1;
                            }
                            break;
                        }
                        case -926053069: {
                            if (((String)destination$iv$iv).equals("properties")) {
                                n2 = 2;
                            }
                            break;
                        }
                        case -1594043758: {
                            if (((String)destination$iv$iv).equals("jarDirectory")) {
                                n2 = 3;
                            }
                            break;
                        }
                    }
                    switch (n2) {
                        case 3: {
                            continue block11;
                        }
                        case 1: {
                            String it;
                            Iterable $this$mapTo$iv$iv2;
                            Iterable $this$map$iv;
                            Object element$iv$iv;
                            List<Element> list3 = childElement.getChildren("root");
                            Intrinsics.checkNotNullExpressionValue(list3, "getChildren(...)");
                            Iterable $i$f$associateByTo2 = list3;
                            object2 = excludedRoots;
                            boolean $i$f$map = false;
                            element$iv$iv = $this$map$iv;
                            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            boolean $i$f$mapTo = false;
                            for (VirtualFileUrl item$iv$iv2 : $this$mapTo$iv$iv2) {
                                Element element = (Element)((Object)item$iv$iv2);
                                object = destination$iv$iv2;
                                boolean bl4 = false;
                                Intrinsics.checkNotNull(it);
                                object.add(JpsProjectSerializersImplKt.getAttributeValueStrict((Element)((Object)it), "url"));
                            }
                            $this$map$iv = (List)destination$iv$iv2;
                            $i$f$map = false;
                            $this$mapTo$iv$iv2 = $this$map$iv;
                            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            $i$f$mapTo = false;
                            for (VirtualFileUrl item$iv$iv2 : $this$mapTo$iv$iv2) {
                                it = (String)((Object)item$iv$iv2);
                                object = destination$iv$iv2;
                                boolean bl5 = false;
                                object.add(virtualFileManager.getOrCreateFromUri(it));
                            }
                            ((ArrayList)object2).addAll((List)destination$iv$iv2);
                            continue block11;
                        }
                        case 2: {
                            properties.element = JDOMUtil.write(childElement);
                            continue block11;
                        }
                    }
                }
                String rootType = childElement.getName();
                for (Element rootTag : childElement.getChildren("root")) {
                    Intrinsics.checkNotNull(rootTag);
                    String url = JpsProjectSerializersImplKt.getAttributeValueStrict(rootTag, "url");
                    LibraryRoot.InclusionOptions inclusionOptions = (LibraryRoot.InclusionOptions)((Object)jarDirectories.get(new Pair<String, String>(rootType, url)));
                    if (inclusionOptions == null) {
                        inclusionOptions = LibraryRoot.InclusionOptions.ROOT_ITSELF;
                    }
                    LibraryRoot.InclusionOptions inclusionOptions2 = inclusionOptions;
                    VirtualFileUrl virtualFileUrl = virtualFileManager.getOrCreateFromUri(url);
                    Object v2 = JpsLibraryEntitiesSerializerKt.access$getLibraryRootTypes$p().get(rootType);
                    Intrinsics.checkNotNull(v2);
                    roots.add(new LibraryRoot(virtualFileUrl, (LibraryRootTypeId)v2, inclusionOptions2));
                }
            }
            String string5 = type;
            if (string5 != null) {
                String it = string5;
                boolean bl6 = false;
                libraryPropertiesEntity = LibraryPropertiesEntity.Companion.create(type, source, (Function1<? super LibraryPropertiesEntity.Builder, Unit>)new Function1<LibraryPropertiesEntity.Builder, Unit>(properties){
                    final /* synthetic */ Ref.ObjectRef<String> $properties;
                    {
                        this.$properties = $properties;
                        super(1);
                    }

                    public final void invoke(@NotNull LibraryPropertiesEntity.Builder $this$invoke) {
                        Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                        $this$invoke.setPropertiesXmlTag((String)this.$properties.element);
                    }
                });
            } else {
                libraryPropertiesEntity = null;
            }
            LibraryPropertiesEntity libProperties2 = libraryPropertiesEntity;
            Iterable $this$map$iv = excludedRoots;
            boolean $i$f$map = false;
            Iterable $i$f$map2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFileUrl item$iv$iv2;
                item$iv$iv2 = (VirtualFileUrl)item$iv$iv;
                object2 = destination$iv$iv3;
                boolean bl7 = false;
                object2.add(ExcludeUrlEntity.Companion.create$default(ExcludeUrlEntity.Companion, (VirtualFileUrl)it, source, null, 4, null));
            }
            List excludes = (List)destination$iv$iv3;
            LibraryEntity libraryEntity2 = LibraryEntity.Companion.create(name2, libraryTableId, (List<LibraryRoot>)roots, source, (Function1<? super LibraryEntity.Builder, Unit>)new Function1<LibraryEntity.Builder, Unit>((List<? extends ExcludeUrlEntity>)excludes, libProperties2){
                final /* synthetic */ List<ExcludeUrlEntity> $excludes;
                final /* synthetic */ LibraryPropertiesEntity $libProperties;
                {
                    this.$excludes = $excludes;
                    this.$libProperties = $libProperties;
                    super(1);
                }

                public final void invoke(@NotNull LibraryEntity.Builder $this$invoke) {
                    Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                    $this$invoke.setExcludedRoots(this.$excludes);
                    DependenciesKt.setLibraryProperties($this$invoke, this.$libProperties);
                }
            });
            return libraryEntity2;
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement loadEntitiesTimeCounter = meter.counterBuilder("jps.library.entities.serializer.load.entities.ms").buildObserver();
            ObservableLongMeasurement saveEntitiesTimeCounter = meter.counterBuilder("jps.library.entities.serializer.save.entities.ms").buildObserver();
            ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{saveEntitiesTimeCounter};
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$15(loadEntitiesTimeCounter, saveEntitiesTimeCounter), loadEntitiesTimeCounter, observableMeasurementArray);
        }

        private static final void setupOpenTelemetryReporting$lambda$15(ObservableLongMeasurement $loadEntitiesTimeCounter, ObservableLongMeasurement $saveEntitiesTimeCounter) {
            $loadEntitiesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(loadEntitiesTimeMs));
            $saveEntitiesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(saveEntitiesTimeMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

