/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.platform.workspace.jps.CustomModuleEntitySource;
import com.intellij.platform.workspace.jps.JpsFileDependentEntitySource;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.util.PathUtilRt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010\b\u001a\u00020\u0007*\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\u000b\u001a\u00020\t*\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0000\u00a8\u0006\f"}, d2={"getInternalFileSource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "source", "Lcom/intellij/platform/workspace/storage/EntitySource;", "isExternalModuleFile", "", "filePath", "", "getAttributeValueStrict", "Lorg/jdom/Element;", "name", "getChildTagStrict", "intellij.platform.workspace.jps"})
public final class JpsProjectSerializersImplKt {
    @NotNull
    public static final String getAttributeValueStrict(@NotNull Element $this$getAttributeValueStrict, @NotNull String name2) {
        Intrinsics.checkNotNullParameter($this$getAttributeValueStrict, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        String string2 = $this$getAttributeValueStrict.getAttributeValue(name2);
        if (string2 == null) {
            throw new JDOMException("Expected attribute " + name2 + " under " + $this$getAttributeValueStrict.getName() + " element");
        }
        return string2;
    }

    @NotNull
    public static final Element getChildTagStrict(@NotNull Element $this$getChildTagStrict, @NotNull String name2) {
        Intrinsics.checkNotNullParameter($this$getChildTagStrict, "<this>");
        Intrinsics.checkNotNullParameter(name2, "name");
        Element element = $this$getChildTagStrict.getChild(name2);
        if (element == null) {
            throw new JDOMException("Expected tag " + name2 + " under " + $this$getChildTagStrict.getName() + " element");
        }
        return element;
    }

    public static final boolean isExternalModuleFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        String string2 = PathUtilRt.getParentPath(filePath);
        Intrinsics.checkNotNullExpressionValue(string2, "getParentPath(...)");
        String parentPath = string2;
        return StringsKt.endsWith$default(filePath, ".xml", false, 2, null) && Intrinsics.areEqual(PathUtilRt.getFileName(parentPath), "modules") && !Intrinsics.areEqual(PathUtilRt.getFileName(PathUtilRt.getParentPath(parentPath)), ".idea");
    }

    @Nullable
    public static final JpsFileEntitySource getInternalFileSource(@NotNull EntitySource source) {
        Intrinsics.checkNotNullParameter(source, "source");
        EntitySource entitySource = source;
        return entitySource instanceof JpsFileDependentEntitySource ? ((JpsFileDependentEntitySource)((Object)source)).getOriginalSource() : (entitySource instanceof CustomModuleEntitySource ? ((CustomModuleEntitySource)source).getInternalSource() : (entitySource instanceof JpsFileEntitySource ? (JpsFileEntitySource)source : null));
    }
}

