/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.ExternalMappingKey;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.impl.AbstractEntityStorage;
import com.intellij.platform.workspace.storage.impl.EntitiesKt;
import com.intellij.platform.workspace.storage.impl.EntityFamily;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.MutableStorageIndexes;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.platform.workspace.storage.impl.external.ExternalEntityMappingImpl;
import com.intellij.platform.workspace.storage.impl.external.MutableExternalEntityMappingImpl;
import com.intellij.platform.workspace.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.platform.workspace.storage.impl.indices.MultimapStorageIndex;
import com.intellij.platform.workspace.storage.impl.indices.SymbolicIdInternalIndex;
import com.intellij.platform.workspace.storage.impl.indices.VirtualFileIndex;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 #2\u00020\u0001:\u0001#B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bBG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u001a\u0010\f\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\r\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010!\u001a\u00020\"R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R(\u0010\f\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\rX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\t\u001a\u00020\nX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u0005X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lcom/intellij/platform/workspace/storage/impl/StorageIndexes;", "", "softLinks", "Lcom/intellij/platform/workspace/storage/impl/indices/MultimapStorageIndex;", "virtualFileIndex", "Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex;", "entitySourceIndex", "Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex;", "Lcom/intellij/platform/workspace/storage/EntitySource;", "symbolicIdIndex", "Lcom/intellij/platform/workspace/storage/impl/indices/SymbolicIdInternalIndex;", "(Lcom/intellij/platform/workspace/storage/impl/indices/MultimapStorageIndex;Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex;Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex;Lcom/intellij/platform/workspace/storage/impl/indices/SymbolicIdInternalIndex;)V", "externalMappings", "", "Lcom/intellij/platform/workspace/storage/ExternalMappingKey;", "Lcom/intellij/platform/workspace/storage/impl/external/ExternalEntityMappingImpl;", "(Lcom/intellij/platform/workspace/storage/impl/indices/MultimapStorageIndex;Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex;Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex;Lcom/intellij/platform/workspace/storage/impl/indices/SymbolicIdInternalIndex;Ljava/util/Map;)V", "getEntitySourceIndex$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex;", "getExternalMappings$intellij_platform_workspace_storage", "()Ljava/util/Map;", "getSoftLinks$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/indices/MultimapStorageIndex;", "getSymbolicIdIndex$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/indices/SymbolicIdInternalIndex;", "getVirtualFileIndex$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex;", "assertConsistency", "", "storage", "Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "assertEntitySourceIndex", "assertSymbolicIdIndex", "toMutable", "Lcom/intellij/platform/workspace/storage/impl/MutableStorageIndexes;", "Companion", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nStorageIndexes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageIndexes.kt\ncom/intellij/platform/workspace/storage/impl/StorageIndexes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n1864#2,2:289\n288#2,2:291\n1855#2:293\n1856#2:295\n1866#2:296\n1864#2,2:297\n1855#2,2:299\n1866#2:301\n1#3:294\n*S KotlinDebug\n*F\n+ 1 StorageIndexes.kt\ncom/intellij/platform/workspace/storage/impl/StorageIndexes\n*L\n113#1:289,2\n115#1:291,2\n117#1:293\n117#1:295\n113#1:296\n132#1:297,2\n136#1:299,2\n132#1:301\n*E\n"})
public class StorageIndexes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultimapStorageIndex softLinks;
    @NotNull
    private final VirtualFileIndex virtualFileIndex;
    @NotNull
    private final EntityStorageInternalIndex<EntitySource> entitySourceIndex;
    @NotNull
    private final SymbolicIdInternalIndex symbolicIdIndex;
    @NotNull
    private final Map<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>> externalMappings;
    @NotNull
    private static final StorageIndexes EMPTY = new StorageIndexes(new MultimapStorageIndex(), new VirtualFileIndex(), new EntityStorageInternalIndex<EntitySource>(false), new SymbolicIdInternalIndex(), new HashMap());

    public StorageIndexes(@NotNull MultimapStorageIndex softLinks, @NotNull VirtualFileIndex virtualFileIndex, @NotNull EntityStorageInternalIndex<EntitySource> entitySourceIndex, @NotNull SymbolicIdInternalIndex symbolicIdIndex, @NotNull Map<ExternalMappingKey<?>, ? extends ExternalEntityMappingImpl<?>> externalMappings) {
        Intrinsics.checkNotNullParameter(softLinks, "softLinks");
        Intrinsics.checkNotNullParameter(virtualFileIndex, "virtualFileIndex");
        Intrinsics.checkNotNullParameter(entitySourceIndex, "entitySourceIndex");
        Intrinsics.checkNotNullParameter(symbolicIdIndex, "symbolicIdIndex");
        Intrinsics.checkNotNullParameter(externalMappings, "externalMappings");
        this.softLinks = softLinks;
        this.virtualFileIndex = virtualFileIndex;
        this.entitySourceIndex = entitySourceIndex;
        this.symbolicIdIndex = symbolicIdIndex;
        this.externalMappings = externalMappings;
    }

    @NotNull
    public MultimapStorageIndex getSoftLinks$intellij_platform_workspace_storage() {
        return this.softLinks;
    }

    @NotNull
    public VirtualFileIndex getVirtualFileIndex$intellij_platform_workspace_storage() {
        return this.virtualFileIndex;
    }

    @NotNull
    public EntityStorageInternalIndex<EntitySource> getEntitySourceIndex$intellij_platform_workspace_storage() {
        return this.entitySourceIndex;
    }

    @NotNull
    public SymbolicIdInternalIndex getSymbolicIdIndex$intellij_platform_workspace_storage() {
        return this.symbolicIdIndex;
    }

    @NotNull
    public Map<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>> getExternalMappings$intellij_platform_workspace_storage() {
        return this.externalMappings;
    }

    public StorageIndexes(@NotNull MultimapStorageIndex softLinks, @NotNull VirtualFileIndex virtualFileIndex, @NotNull EntityStorageInternalIndex<EntitySource> entitySourceIndex, @NotNull SymbolicIdInternalIndex symbolicIdIndex) {
        Intrinsics.checkNotNullParameter(softLinks, "softLinks");
        Intrinsics.checkNotNullParameter(virtualFileIndex, "virtualFileIndex");
        Intrinsics.checkNotNullParameter(entitySourceIndex, "entitySourceIndex");
        Intrinsics.checkNotNullParameter(symbolicIdIndex, "symbolicIdIndex");
        this(softLinks, virtualFileIndex, entitySourceIndex, symbolicIdIndex, MapsKt.emptyMap());
    }

    @NotNull
    public final MutableStorageIndexes toMutable() {
        MultimapStorageIndex.MutableMultimapStorageIndex copiedSoftLinks = MultimapStorageIndex.MutableMultimapStorageIndex.Companion.from(this.getSoftLinks$intellij_platform_workspace_storage());
        VirtualFileIndex.MutableVirtualFileIndex copiedVirtualFileIndex = VirtualFileIndex.MutableVirtualFileIndex.Companion.from$intellij_platform_workspace_storage(this.getVirtualFileIndex$intellij_platform_workspace_storage());
        EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> copiedEntitySourceIndex = EntityStorageInternalIndex.MutableEntityStorageInternalIndex.Companion.from(this.getEntitySourceIndex$intellij_platform_workspace_storage());
        SymbolicIdInternalIndex.MutableSymbolicIdInternalIndex copiedSymbolicIdIndex = SymbolicIdInternalIndex.MutableSymbolicIdInternalIndex.Companion.from(this.getSymbolicIdIndex$intellij_platform_workspace_storage());
        Map<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> copiedExternalMappings = MutableExternalEntityMappingImpl.Companion.fromMap(this.getExternalMappings$intellij_platform_workspace_storage());
        return new MutableStorageIndexes(copiedSoftLinks, copiedVirtualFileIndex, copiedEntitySourceIndex, copiedSymbolicIdIndex, copiedExternalMappings);
    }

    public final void assertConsistency(@NotNull AbstractEntityStorage storage) {
        Intrinsics.checkNotNullParameter(storage, "storage");
        this.assertEntitySourceIndex(storage);
        this.assertSymbolicIdIndex(storage);
        this.getVirtualFileIndex$intellij_platform_workspace_storage().assertConsistency$intellij_platform_workspace_storage();
        Iterator<Map.Entry<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>>> iterator2 = this.getExternalMappings$intellij_platform_workspace_storage().entrySet().iterator();
        while (iterator2.hasNext()) {
            ExternalEntityMappingImpl<?> mappings = iterator2.next().getValue();
            mappings.getIndex$intellij_platform_workspace_storage().forEach(new Function2<Long, Object, Unit>(storage){
                final /* synthetic */ AbstractEntityStorage $storage;
                {
                    this.$storage = $storage;
                    super(2);
                }

                public final void invoke(long id2, @Nullable Object object) {
                    boolean bl2;
                    boolean bl3 = bl2 = this.$storage.entityDataById$intellij_platform_workspace_storage(id2) != null;
                    if (_Assertions.ENABLED && !bl2) {
                        boolean bl4 = false;
                        String string2 = "Missing entity by id: " + id2;
                        throw new AssertionError((Object)string2);
                    }
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assertSymbolicIdIndex(AbstractEntityStorage storage) {
        boolean bl2;
        int expectedSize = 0;
        Iterable $this$forEachIndexed$iv = storage.getEntitiesByType$intellij_platform_workspace_storage().getEntityFamilies$intellij_platform_workspace_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object v0;
            void family;
            int i2;
            block6: {
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                EntityFamily entityFamily = (EntityFamily)item$iv;
                i2 = n2;
                boolean bl3 = false;
                if (family == null) continue;
                Iterable $this$firstOrNull$iv = family.getEntities$intellij_platform_workspace_storage();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    WorkspaceEntityData it = (WorkspaceEntityData)element$iv;
                    boolean bl4 = false;
                    if (!(it != null)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            WorkspaceEntityData workspaceEntityData = v0;
            if ((workspaceEntityData != null ? EntitiesKt.symbolicId(workspaceEntityData) : null) == null) continue;
            long mutableId = 0L;
            mutableId = EntityIdKt.createEntityId(0, i2);
            Iterable $this$forEach$iv = family.getEntities$intellij_platform_workspace_storage();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorkspaceEntityData data = (WorkspaceEntityData)element$iv;
                boolean bl5 = false;
                if (data == null) continue;
                mutableId = EntityIdKt.copy$default(mutableId, data.getId(), 0, 2, null);
                SymbolicEntityId<?> expectedSymbolicId = this.getSymbolicIdIndex$intellij_platform_workspace_storage().getEntryById$intellij_platform_workspace_storage(mutableId);
                boolean bl6 = Intrinsics.areEqual(expectedSymbolicId, EntitiesKt.symbolicId(data));
                if (_Assertions.ENABLED && !bl6) {
                    boolean bl7 = false;
                    String string2 = "Entity " + data + " isn't found in persistent id index. SymbolicId: " + EntitiesKt.symbolicId(data) + ", Id: " + mutableId + ". Expected entity source: " + expectedSymbolicId;
                    throw new AssertionError((Object)string2);
                }
                ++expectedSize;
            }
        }
        boolean bl8 = bl2 = expectedSize == this.getSymbolicIdIndex$intellij_platform_workspace_storage().getIndex$intellij_platform_workspace_storage().size();
        if (_Assertions.ENABLED && !bl2) {
            boolean bl9 = false;
            String string3 = "Incorrect size of symbolic id index. Expected: " + expectedSize + ", actual: " + this.getSymbolicIdIndex$intellij_platform_workspace_storage().getIndex$intellij_platform_workspace_storage().size();
            throw new AssertionError((Object)string3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assertEntitySourceIndex(AbstractEntityStorage storage) {
        boolean bl2;
        int expectedSize = 0;
        Iterable $this$forEachIndexed$iv = storage.getEntitiesByType$intellij_platform_workspace_storage().getEntityFamilies$intellij_platform_workspace_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void family;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            EntityFamily entityFamily = (EntityFamily)item$iv;
            int i2 = n2;
            boolean bl3 = false;
            if (family == null) continue;
            long mutableId = 0L;
            mutableId = EntityIdKt.createEntityId(0, i2);
            Iterable $this$forEach$iv = family.getEntities$intellij_platform_workspace_storage();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorkspaceEntityData data = (WorkspaceEntityData)element$iv;
                boolean bl4 = false;
                if (data == null) continue;
                mutableId = EntityIdKt.copy$default(mutableId, data.getId(), 0, 2, null);
                EntitySource expectedEntitySource = this.getEntitySourceIndex$intellij_platform_workspace_storage().getEntryById$intellij_platform_workspace_storage(mutableId);
                boolean bl5 = Intrinsics.areEqual(expectedEntitySource, data.getEntitySource());
                if (_Assertions.ENABLED && !bl5) {
                    boolean bl6 = false;
                    String string2 = "Entity " + data + " isn't found in entity source index. Entity source: " + data.getEntitySource() + ", Id: " + mutableId + ". Expected entity source: " + expectedEntitySource;
                    throw new AssertionError((Object)string2);
                }
                ++expectedSize;
            }
        }
        boolean bl7 = bl2 = expectedSize == this.getEntitySourceIndex$intellij_platform_workspace_storage().getIndex$intellij_platform_workspace_storage().getSize();
        if (_Assertions.ENABLED && !bl2) {
            boolean bl8 = false;
            String string3 = "Incorrect size of entity source index. Expected: " + expectedSize + ", actual: " + this.getEntitySourceIndex$intellij_platform_workspace_storage().getIndex$intellij_platform_workspace_storage().getSize();
            throw new AssertionError((Object)string3);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/workspace/storage/impl/StorageIndexes$Companion;", "", "()V", "EMPTY", "Lcom/intellij/platform/workspace/storage/impl/StorageIndexes;", "getEMPTY", "()Lcom/intellij/platform/workspace/storage/impl/StorageIndexes;", "intellij.platform.workspace.storage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StorageIndexes getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

