/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.VersionedEntityStorage;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012 \u0010\u0007\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n0\b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0011H\u0016J,\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u000b0\n\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\tH\u0016R(\u0010\u0007\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/workspace/storage/impl/VersionedStorageChangeImpl;", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "entityStorage", "Lcom/intellij/platform/workspace/storage/VersionedEntityStorage;", "storageBefore", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "storageAfter", "changes", "", "Ljava/lang/Class;", "", "Lcom/intellij/platform/workspace/storage/EntityChange;", "(Lcom/intellij/platform/workspace/storage/VersionedEntityStorage;Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;Ljava/util/Map;)V", "getStorageAfter", "()Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "getStorageBefore", "getAllChanges", "Lkotlin/sequences/Sequence;", "getChanges", "T", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entityClass", "intellij.platform.workspace.storage"})
final class VersionedStorageChangeImpl
extends VersionedStorageChange {
    @NotNull
    private final ImmutableEntityStorage storageBefore;
    @NotNull
    private final ImmutableEntityStorage storageAfter;
    @NotNull
    private final Map<Class<?>, List<EntityChange<?>>> changes;

    public VersionedStorageChangeImpl(@NotNull VersionedEntityStorage entityStorage, @NotNull ImmutableEntityStorage storageBefore, @NotNull ImmutableEntityStorage storageAfter, @NotNull Map<Class<?>, ? extends List<? extends EntityChange<?>>> changes) {
        Intrinsics.checkNotNullParameter(entityStorage, "entityStorage");
        Intrinsics.checkNotNullParameter(storageBefore, "storageBefore");
        Intrinsics.checkNotNullParameter(storageAfter, "storageAfter");
        Intrinsics.checkNotNullParameter(changes, "changes");
        super(entityStorage);
        this.storageBefore = storageBefore;
        this.storageAfter = storageAfter;
        this.changes = changes;
    }

    @Override
    @NotNull
    public ImmutableEntityStorage getStorageBefore() {
        return this.storageBefore;
    }

    @Override
    @NotNull
    public ImmutableEntityStorage getStorageAfter() {
        return this.storageAfter;
    }

    @Override
    @NotNull
    public <T extends WorkspaceEntity> List<EntityChange<T>> getChanges(@NotNull Class<T> entityClass) {
        Intrinsics.checkNotNullParameter(entityClass, "entityClass");
        List<EntityChange<T>> list2 = this.changes.get(entityClass);
        List<EntityChange<T>> list3 = list2 instanceof List ? list2 : null;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    @Override
    @NotNull
    public Sequence<EntityChange<?>> getAllChanges() {
        return SequencesKt.flattenSequenceOfIterable(CollectionsKt.asSequence((Iterable)this.changes.values()));
    }
}

