/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.serialization;

import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityTypesResolver;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.impl.ClassToIntConverterKt;
import com.intellij.platform.workspace.storage.impl.ImmutableEntityFamily;
import com.intellij.platform.workspace.storage.impl.ImmutableEntityStorageImpl;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.platform.workspace.storage.impl.serialization.CacheMetadata;
import com.intellij.platform.workspace.storage.metadata.MetadataStorage;
import com.intellij.platform.workspace.storage.metadata.diff.ComparisonResult;
import com.intellij.platform.workspace.storage.metadata.diff.Equal;
import com.intellij.platform.workspace.storage.metadata.diff.NotEqual;
import com.intellij.platform.workspace.storage.metadata.diff.TypesMetadataComparator;
import com.intellij.platform.workspace.storage.metadata.model.StorageTypeMetadata;
import com.intellij.platform.workspace.storage.metadata.resolver.TypeMetadataResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\t"}, d2={"compareWithCurrentEntitiesMetadata", "Lcom/intellij/platform/workspace/storage/metadata/diff/ComparisonResult;", "cacheMetadata", "Lcom/intellij/platform/workspace/storage/impl/serialization/CacheMetadata;", "typesResolver", "Lcom/intellij/platform/workspace/storage/EntityTypesResolver;", "getCacheMetadata", "entityStorage", "Lcom/intellij/platform/workspace/storage/impl/ImmutableEntityStorageImpl;", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nCacheMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheMetadata.kt\ncom/intellij/platform/workspace/storage/impl/serialization/CacheMetadataKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1855#2,2:138\n1864#2,2:140\n1866#2:143\n1549#2:144\n1620#2,3:145\n1549#2:148\n1620#2,3:149\n1#3:142\n*S KotlinDebug\n*F\n+ 1 CacheMetadata.kt\ncom/intellij/platform/workspace/storage/impl/serialization/CacheMetadataKt\n*L\n21#1:138,2\n48#1:140,2\n48#1:143\n56#1:144\n56#1:145,3\n58#1:148\n58#1:149,3\n*E\n"})
public final class CacheMetadataKt {
    @NotNull
    public static final ComparisonResult compareWithCurrentEntitiesMetadata(@NotNull CacheMetadata cacheMetadata, @NotNull EntityTypesResolver typesResolver) {
        Intrinsics.checkNotNullParameter(cacheMetadata, "cacheMetadata");
        Intrinsics.checkNotNullParameter(typesResolver, "typesResolver");
        TypeMetadataResolver metadataResolver = TypeMetadataResolver.Companion.getInstance$intellij_platform_workspace_storage();
        Iterable $this$forEach$iv = cacheMetadata;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl2 = false;
            CacheMetadata.Id id2 = (CacheMetadata.Id)pair.component1();
            CacheMetadata.SerializableTypeMetadata cacheTypeMetadata = (CacheMetadata.SerializableTypeMetadata)pair.component2();
            String typeFqn = cacheTypeMetadata.getMetadata().getFqName();
            MetadataStorage metadataStorage = metadataResolver.resolveMetadataStorage(typesResolver, id2.getMetadataStorageFqn(), id2.getPluginId());
            Integer n2 = metadataResolver.resolveTypeMetadataHashOrNull(metadataStorage, typeFqn);
            if (n2 == null) {
                return new NotEqual("Failed to load existing metadata for type " + typeFqn);
            }
            int currentTypeMetadataHash = n2;
            if (cacheTypeMetadata.getMetadataHash() == currentTypeMetadataHash) continue;
            StorageTypeMetadata currentTypeMetadata = metadataResolver.resolveTypeMetadata(metadataStorage, typeFqn);
            ComparisonResult comparisonResult = new TypesMetadataComparator(cacheTypeMetadata.getMetadata(), currentTypeMetadata).areEquals(cacheTypeMetadata.getMetadata(), currentTypeMetadata);
            if (comparisonResult.getAreEquals()) {
                throw new IllegalStateException("Hashes of the type " + typeFqn + " differ in the cache (" + cacheTypeMetadata.getMetadataHash() + ") from the current one (" + currentTypeMetadataHash + "), although after comparison they are equal.");
            }
            return comparisonResult;
        }
        return Equal.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CacheMetadata getCacheMetadata(@NotNull ImmutableEntityStorageImpl entityStorage, @NotNull EntityTypesResolver typesResolver) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(entityStorage, "entityStorage");
        Intrinsics.checkNotNullParameter(typesResolver, "typesResolver");
        CacheMetadata.MutableCacheMetadata cacheMetadata = new CacheMetadata.MutableCacheMetadata(typesResolver);
        Iterable $this$forEachIndexed$iv = entityStorage.getEntitiesByType$intellij_platform_workspace_storage().getEntityFamilies$intellij_platform_workspace_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv22 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            WorkspaceEntityData entity;
            WorkspaceEntityData workspaceEntityData;
            int i2;
            block7: {
                void entityFamily;
                int n2;
                if ((n2 = index$iv22++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ImmutableEntityFamily immutableEntityFamily = (ImmutableEntityFamily)item$iv;
                i2 = n2;
                boolean bl2 = false;
                List list2 = entityFamily;
                if (list2 != null && (list2 = ((ImmutableEntityFamily)((Object)list2)).getEntities$intellij_platform_workspace_storage()) != null) {
                    for (WorkspaceEntityData it : (Iterable)list2) {
                        boolean bl3 = false;
                        WorkspaceEntityData workspaceEntityData2 = it;
                        if (workspaceEntityData2 == null) continue;
                        workspaceEntityData = workspaceEntityData2;
                        break block7;
                    }
                    workspaceEntityData = null;
                } else {
                    workspaceEntityData = null;
                }
            }
            if ((entity = workspaceEntityData) == null) continue;
            cacheMetadata.add(ClassToIntConverterKt.findWorkspaceEntity(i2));
        }
        $this$forEachIndexed$iv = entityStorage.getIndexes$intellij_platform_workspace_storage().getEntitySourceIndex$intellij_platform_workspace_storage().entries$intellij_platform_workspace_storage();
        CacheMetadata.MutableCacheMetadata mutableCacheMetadata = cacheMetadata;
        boolean $i$f$map = false;
        void index$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EntitySource i2 = (EntitySource)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(it.getClass());
        }
        mutableCacheMetadata.addAll((List)destination$iv$iv);
        $this$map$iv = entityStorage.getIndexes$intellij_platform_workspace_storage().getSymbolicIdIndex$intellij_platform_workspace_storage().entries$intellij_platform_workspace_storage();
        mutableCacheMetadata = cacheMetadata;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SymbolicEntityId it = (SymbolicEntityId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(it.getClass());
        }
        mutableCacheMetadata.addAll((List)destination$iv$iv);
        return cacheMetadata.toImmutable(typesResolver);
    }
}

