/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.url;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.workspace.storage.impl.IntIdGenerator;
import com.intellij.platform.workspace.storage.impl.VirtualFileNameStore;
import com.intellij.platform.workspace.storage.impl.url.VirtualFileUrlImpl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.containers.TreeNodeProcessingResult;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0016\u0018\u0000 A2\u00020\u0001:\u0002ABB\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0018\u00010\tR\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u0011J$\u0010\u0012\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0018\u00010\tR\u00020\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0002J\u001d\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0018J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000H\u0014J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\u0016\u0010 \u001a\b\u0018\u00010\tR\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010!\u001a\b\u0018\u00010\tR\u00020\u00002\u0006\u0010\"\u001a\u00020\u001bH\u0002J\u0016\u0010!\u001a\b\u0018\u00010\tR\u00020\u00002\u0006\u0010#\u001a\u00020\u000fH\u0002J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001b\u0010%\u001a\u00020\u00042\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0000\u00a2\u0006\u0002\b'J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014J\b\u0010)\u001a\u00020\u0004H\u0002J\u0010\u0010*\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\u0017\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010,\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b-J\u001b\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010,\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b/J\u000e\u00100\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u00101\u001a\u00020\u000fJ\"\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00042\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020706J\u0015\u00108\u001a\u0002092\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b:J\u0010\u0010;\u001a\u0002092\u0006\u0010\"\u001a\u00020\u001bH\u0002J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001d\u0010=\u001a\u0002092\u0006\u0010>\u001a\u00020\u000f2\u0006\u0010?\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b@R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl;", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "()V", "emptyUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "fileNameStore", "Lcom/intellij/platform/workspace/storage/impl/VirtualFileNameStore;", "id2NodeMapping", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode;", "idGenerator", "Lcom/intellij/platform/workspace/storage/impl/IntIdGenerator;", "rootNode", "add", "path", "", "parentNode", "add$intellij_platform_workspace_storage", "addSegments", "segments", "", "append", "parentVfu", "relativePath", "append$intellij_platform_workspace_storage", "createVirtualFileUrl", "id", "", "manager", "findBySegments", "findByUri", "uri", "findLatestFilePathNode", "findRootNode", "contentId", "segment", "fromPath", "fromUriSegments", "uriSegments", "fromUriSegments$intellij_platform_workspace_storage", "getCachedVirtualFileUrls", "getEmptyUrl", "getOrCreateFromUri", "getParentVirtualUrl", "vfu", "getParentVirtualUrl$intellij_platform_workspace_storage", "getSubtreeVirtualUrlsById", "getSubtreeVirtualUrlsById$intellij_platform_workspace_storage", "getUrlById", "print", "processChildrenRecursively", "", "url", "processor", "Lkotlin/Function1;", "Lcom/intellij/util/containers/TreeNodeProcessingResult;", "remove", "", "remove$intellij_platform_workspace_storage", "removeNameUsage", "splitNames", "update", "oldPath", "newPath", "update$intellij_platform_workspace_storage", "Companion", "FilePathNode", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nVirtualFileUrlManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileUrlManagerImpl.kt\ncom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,351:1\n1549#2:352\n1620#2,3:353\n1603#2,9:357\n1855#2:366\n1856#2:368\n1612#2:369\n1#3:356\n1#3:367\n*S KotlinDebug\n*F\n+ 1 VirtualFileUrlManagerImpl.kt\ncom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl\n*L\n53#1:352\n53#1:353,3\n103#1:357,9\n103#1:366\n103#1:368\n103#1:369\n103#1:367\n*E\n"})
public class VirtualFileUrlManagerImpl
implements VirtualFileUrlManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final IntIdGenerator idGenerator = new IntIdGenerator();
    @Nullable
    private VirtualFileUrl emptyUrl;
    @NotNull
    private final VirtualFileNameStore fileNameStore = new VirtualFileNameStore();
    @NotNull
    private final Int2ObjectOpenHashMap<FilePathNode> id2NodeMapping = new Int2ObjectOpenHashMap();
    @NotNull
    private final FilePathNode rootNode = new FilePathNode(this, 0, 0, null, 4, null);
    @NotNull
    private static final Hash.Strategy<FilePathNode> HASHING_STRATEGY = new Hash.Strategy<FilePathNode>(){

        public boolean equals(@Nullable FilePathNode node1, @Nullable FilePathNode node2) {
            if (node1 == node2) {
                return true;
            }
            if (node1 == null || node2 == null) {
                return false;
            }
            return node1.getContentId() == node2.getContentId();
        }

        public int hashCode(@Nullable FilePathNode node) {
            FilePathNode filePathNode = node;
            return filePathNode != null ? filePathNode.getContentId() : 0;
        }
    };

    @Override
    @NotNull
    public synchronized VirtualFileUrl getOrCreateFromUri(@NotNull String uri) {
        Intrinsics.checkNotNullParameter(uri, "uri");
        if (((CharSequence)uri).length() == 0) {
            return this.getEmptyUrl();
        }
        return VirtualFileUrlManagerImpl.add$intellij_platform_workspace_storage$default(this, uri, null, 2, null);
    }

    @Override
    @Nullable
    public VirtualFileUrl findByUri(@NotNull String uri) {
        Intrinsics.checkNotNullParameter(uri, "uri");
        return this.findBySegments(this.splitNames(uri));
    }

    @NotNull
    public final synchronized VirtualFileUrl fromUriSegments$intellij_platform_workspace_storage(@NotNull List<String> uriSegments) {
        Intrinsics.checkNotNullParameter(uriSegments, "uriSegments");
        if (uriSegments.isEmpty()) {
            return this.getEmptyUrl();
        }
        return this.addSegments(null, uriSegments);
    }

    @Override
    @NotNull
    public VirtualFileUrl fromPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        String url = "file://" + FileUtil.toSystemIndependentName(path);
        return this.getOrCreateFromUri(url);
    }

    @Nullable
    public final synchronized VirtualFileUrl getParentVirtualUrl$intellij_platform_workspace_storage(@NotNull VirtualFileUrl vfu) {
        Intrinsics.checkNotNullParameter(vfu, "vfu");
        VirtualFileUrlImpl cfr_ignored_0 = (VirtualFileUrlImpl)vfu;
        FilePathNode filePathNode = this.id2NodeMapping.get(((VirtualFileUrlImpl)vfu).getId());
        return filePathNode != null && (filePathNode = filePathNode.getParent()) != null ? filePathNode.getVirtualFileUrl(this) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized List<VirtualFileUrl> getSubtreeVirtualUrlsById$intellij_platform_workspace_storage(@NotNull VirtualFileUrl vfu) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(vfu, "vfu");
        VirtualFileUrlImpl cfr_ignored_0 = (VirtualFileUrlImpl)vfu;
        Iterable $this$map$iv = this.id2NodeMapping.get(((VirtualFileUrlImpl)vfu).getId()).getSubtreeNodes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FilePathNode filePathNode = (FilePathNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getVirtualFileUrl(this));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean processChildrenRecursively(@NotNull VirtualFileUrl url, @NotNull Function1<? super VirtualFileUrl, ? extends TreeNodeProcessingResult> processor) {
        FilePathNode filePathNode;
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(processor, "processor");
        VirtualFileUrlManagerImpl virtualFileUrlManagerImpl = this;
        synchronized (virtualFileUrlManagerImpl) {
            boolean bl2 = false;
            filePathNode = this.id2NodeMapping.get(((VirtualFileUrlImpl)url).getId());
        }
        FilePathNode node = filePathNode;
        return node.processChildrenRecursively((Function1<? super FilePathNode, ? extends TreeNodeProcessingResult>)new Function1<FilePathNode, TreeNodeProcessingResult>(this, processor){
            final /* synthetic */ VirtualFileUrlManagerImpl this$0;
            final /* synthetic */ Function1<VirtualFileUrl, TreeNodeProcessingResult> $processor;
            {
                this.this$0 = $receiver;
                this.$processor = $processor;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final TreeNodeProcessingResult invoke(@NotNull FilePathNode it) {
                VirtualFileUrl virtualFileUrl;
                Intrinsics.checkNotNullParameter(it, "it");
                VirtualFileUrlManagerImpl virtualFileUrlManagerImpl = this.this$0;
                VirtualFileUrlManagerImpl virtualFileUrlManagerImpl2 = this.this$0;
                VirtualFileUrlManagerImpl virtualFileUrlManagerImpl3 = virtualFileUrlManagerImpl;
                synchronized (virtualFileUrlManagerImpl3) {
                    boolean bl2 = false;
                    virtualFileUrl = it.getVirtualFileUrl(virtualFileUrlManagerImpl2);
                }
                VirtualFileUrl childUrl = virtualFileUrl;
                return this.$processor.invoke(childUrl);
            }
        });
    }

    @NotNull
    public final synchronized String getUrlById(int id2) {
        if (id2 <= 0) {
            return "";
        }
        IntArrayList contentIds = new IntArrayList();
        for (FilePathNode node = this.id2NodeMapping.get(id2); node != null; node = node.getParent()) {
            contentIds.add(node.getContentId());
        }
        if (contentIds.size() == 1) {
            String string2;
            String string3 = this.fileNameStore.getNameForId(contentIds.getInt(0));
            if (string3 != null) {
                CharSequence charSequence;
                String it = string3;
                boolean bl2 = false;
                CharSequence charSequence2 = it;
                if (charSequence2.length() == 0) {
                    boolean bl3 = false;
                    charSequence = "/";
                } else {
                    charSequence = charSequence2;
                }
                string2 = (String)charSequence;
            } else {
                string2 = "";
            }
            return string2;
        }
        StringBuilder builder = new StringBuilder();
        for (int index2 = contentIds.size() - 1; -1 < index2; --index2) {
            builder.append(this.fileNameStore.getNameForId(contentIds.getInt(index2)));
            if (index2 == 0) continue;
            builder.append("/");
        }
        String string4 = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "toString(...)");
        return string4;
    }

    @NotNull
    public final synchronized VirtualFileUrl append$intellij_platform_workspace_storage(@NotNull VirtualFileUrl parentVfu, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter(parentVfu, "parentVfu");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        VirtualFileUrlImpl cfr_ignored_0 = (VirtualFileUrlImpl)parentVfu;
        return this.add$intellij_platform_workspace_storage(relativePath, this.id2NodeMapping.get(((VirtualFileUrlImpl)parentVfu).getId()));
    }

    @NotNull
    protected VirtualFileUrl createVirtualFileUrl(int id2, @NotNull VirtualFileUrlManagerImpl manager) {
        Intrinsics.checkNotNullParameter(manager, "manager");
        return new VirtualFileUrlImpl(id2, manager);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized List<VirtualFileUrl> getCachedVirtualFileUrls() {
        void $this$mapNotNullTo$iv$iv;
        Collection collection = this.id2NodeMapping.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VirtualFileUrl it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            FilePathNode p0 = (FilePathNode)element$iv$iv;
            boolean bl3 = false;
            if (p0.getCachedVirtualFileUrl() == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final VirtualFileUrl add$intellij_platform_workspace_storage(@NotNull String path, @Nullable FilePathNode parentNode) {
        Intrinsics.checkNotNullParameter(path, "path");
        List<String> segments = this.splitNames(path);
        return this.addSegments(parentNode, segments);
    }

    public static /* synthetic */ VirtualFileUrl add$intellij_platform_workspace_storage$default(VirtualFileUrlManagerImpl virtualFileUrlManagerImpl, String string2, FilePathNode filePathNode, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
        }
        if ((n2 & 2) != 0) {
            filePathNode = null;
        }
        return virtualFileUrlManagerImpl.add$intellij_platform_workspace_storage(string2, filePathNode);
    }

    private final VirtualFileUrl addSegments(FilePathNode parentNode, List<String> segments) {
        FilePathNode filePathNode = parentNode;
        if (filePathNode == null) {
            filePathNode = this.findRootNode(CollectionsKt.first(segments));
        }
        FilePathNode latestNode = filePathNode;
        int latestElement = segments.size() - 1;
        int n2 = segments.size();
        for (int index2 = 0; index2 < n2; ++index2) {
            int nameId = this.fileNameStore.generateIdForName(segments.get(index2));
            if (latestNode == null) {
                int nodeId = this.idGenerator.generateId();
                FilePathNode newNode = new FilePathNode(this, nodeId, nameId, null, 4, null);
                Integer n3 = nodeId;
                ((Map)this.id2NodeMapping).put(n3, newNode);
                if (index2 == latestElement) {
                    this.rootNode.addChild(newNode);
                    return newNode.getVirtualFileUrl(this);
                }
                latestNode = newNode;
                this.rootNode.addChild(newNode);
                continue;
            }
            if (latestNode == this.findRootNode(latestNode.getContentId()) && index2 == 0 && latestNode.getContentId() == nameId) {
                if (latestElement != 0) continue;
                return latestNode.getVirtualFileUrl(this);
            }
            FilePathNode node = latestNode.findChild(nameId);
            if (node == null) {
                int nodeId = this.idGenerator.generateId();
                FilePathNode newNode = new FilePathNode(this, nodeId, nameId, latestNode);
                Integer n4 = nodeId;
                ((Map)this.id2NodeMapping).put(n4, newNode);
                latestNode.addChild(newNode);
                latestNode = newNode;
                if (index2 != latestElement) continue;
                return newNode.getVirtualFileUrl(this);
            }
            if (index2 == latestElement) {
                return node.getVirtualFileUrl(this);
            }
            latestNode = node;
        }
        return this.getEmptyUrl();
    }

    private final VirtualFileUrl findBySegments(List<String> segments) {
        FilePathNode currentNode = this.rootNode;
        for (String segment : segments) {
            Integer n2 = this.fileNameStore.getIdForName(segment);
            if (n2 == null) {
                return null;
            }
            int nameId = n2;
            if (currentNode.findChild(nameId) != null) continue;
            return null;
        }
        return currentNode.getCachedVirtualFileUrl();
    }

    public final void remove$intellij_platform_workspace_storage(@NotNull String path) {
        FilePathNode parent;
        Intrinsics.checkNotNullParameter(path, "path");
        FilePathNode node = this.findLatestFilePathNode(path);
        if (node == null) {
            System.out.println((Object)"File not found");
            return;
        }
        if (!node.isEmpty()) {
            return;
        }
        FilePathNode currentNode = node;
        do {
            if ((parent = currentNode.getParent()) == null) {
                if (currentNode == this.findRootNode(currentNode.getContentId()) && currentNode.isEmpty()) {
                    this.removeNameUsage(currentNode.getContentId());
                    this.id2NodeMapping.remove(currentNode.getNodeId());
                    this.rootNode.removeChild(currentNode);
                }
                return;
            }
            parent.removeChild(currentNode);
            this.removeNameUsage(currentNode.getContentId());
            this.id2NodeMapping.remove(currentNode.getNodeId());
        } while ((currentNode = parent).isEmpty());
    }

    public final void update$intellij_platform_workspace_storage(@NotNull String oldPath, @NotNull String newPath) {
        Intrinsics.checkNotNullParameter(oldPath, "oldPath");
        Intrinsics.checkNotNullParameter(newPath, "newPath");
        FilePathNode latestPathNode = this.findLatestFilePathNode(oldPath);
        if (latestPathNode == null) {
            return;
        }
        this.remove$intellij_platform_workspace_storage(oldPath);
        VirtualFileUrlManagerImpl.add$intellij_platform_workspace_storage$default(this, newPath, null, 2, null);
    }

    private final VirtualFileUrl getEmptyUrl() {
        if (this.emptyUrl == null) {
            this.emptyUrl = this.createVirtualFileUrl(0, this);
        }
        VirtualFileUrl virtualFileUrl = this.emptyUrl;
        Intrinsics.checkNotNull(virtualFileUrl);
        return virtualFileUrl;
    }

    private final void removeNameUsage(int contentId) {
        boolean bl2;
        String name2 = this.fileNameStore.getNameForId(contentId);
        boolean bl3 = bl2 = name2 != null;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        String string3 = name2;
        Intrinsics.checkNotNull(string3);
        this.fileNameStore.removeName(string3);
    }

    private final FilePathNode findLatestFilePathNode(String path) {
        List<String> segments = this.splitNames(path);
        FilePathNode latestNode = null;
        latestNode = this.findRootNode(CollectionsKt.first(segments));
        int latestElement = segments.size() - 1;
        int n2 = segments.size();
        for (int index2 = 0; index2 < n2; ++index2) {
            Unit unit;
            Integer n3 = this.fileNameStore.getIdForName(segments.get(index2));
            if (n3 == null) {
                return null;
            }
            int nameId = n3;
            if (latestNode == null) {
                return null;
            }
            if (latestNode == this.findRootNode(latestNode.getContentId()) && latestNode.getContentId() == nameId) {
                if (index2 != latestElement) continue;
                return latestNode;
            }
            if (latestNode.findChild(nameId) != null) {
                FilePathNode it;
                boolean bl2 = false;
                if (index2 == latestElement) {
                    return it;
                }
                latestNode = it;
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) continue;
            return null;
        }
        return null;
    }

    private final FilePathNode findRootNode(String segment) {
        Integer n2 = this.fileNameStore.getIdForName(segment);
        if (n2 == null) {
            return null;
        }
        int segmentId = n2;
        return this.rootNode.findChild(segmentId);
    }

    private final FilePathNode findRootNode(int contentId) {
        return this.rootNode.findChild(contentId);
    }

    private final List<String> splitNames(String path) {
        char[] cArray = new char[]{'/', '\\'};
        return StringsKt.split$default((CharSequence)path, cArray, false, 0, 6, null);
    }

    @NotNull
    public final String print() {
        return this.rootNode.print();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0005R\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl$Companion;", "", "()V", "HASHING_STRATEGY", "Lit/unimi/dsi/fastutil/Hash$Strategy;", "Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode;", "Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl;", "getHASHING_STRATEGY", "()Lit/unimi/dsi/fastutil/Hash$Strategy;", "intellij.platform.workspace.storage"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Hash.Strategy<FilePathNode> getHASHING_STRATEGY() {
            return HASHING_STRATEGY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0018\u00010\u0000R\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0000R\u00020\u0006J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\u0014\u0010\u0015\u001a\b\u0018\u00010\u0000R\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0003J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u0000R\u00020\u00060\u0019J$\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u0000R\u00020\u00060\u00192\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u0000R\u00020\u00060\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0006J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J$\u0010 \u001a\u00020\u00122\n\u0010\"\u001a\u00060#j\u0002`$2\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020!H\u0002J\u001e\u0010'\u001a\u00020\u001f2\u0016\u0010(\u001a\u0012\u0012\b\u0012\u00060\u0000R\u00020\u0006\u0012\u0004\u0012\u00020*0)J\u0012\u0010+\u001a\u00020\u00122\n\u0010,\u001a\u00060\u0000R\u00020\u0006R\u001a\u0010\b\u001a\u000e\u0012\b\u0012\u00060\u0000R\u00020\u0006\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0018\u00010\u0000R\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode;", "", "nodeId", "", "contentId", "parent", "Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl;", "(Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl;IILcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode;)V", "children", "Lit/unimi/dsi/fastutil/objects/ObjectOpenCustomHashSet;", "getContentId", "()I", "getNodeId", "getParent", "()Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode;", "virtualFileUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "addChild", "", "newNode", "createChildrenList", "findChild", "nameId", "getCachedVirtualFileUrl", "getSubtreeNodes", "", "subtreeNodes", "", "getVirtualFileUrl", "virtualFileUrlManager", "isEmpty", "", "print", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "prefix", "childrenPrefix", "processChildrenRecursively", "processor", "Lkotlin/Function1;", "Lcom/intellij/util/containers/TreeNodeProcessingResult;", "removeChild", "node", "intellij.platform.workspace.storage"})
    @SourceDebugExtension(value={"SMAP\nVirtualFileUrlManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileUrlManagerImpl.kt\ncom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,351:1\n1855#2,2:352\n1855#2,2:355\n1#3:354\n*S KotlinDebug\n*F\n+ 1 VirtualFileUrlManagerImpl.kt\ncom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode\n*L\n261#1:352,2\n270#1:355,2\n*E\n"})
    public final class FilePathNode {
        private final int nodeId;
        private final int contentId;
        @Nullable
        private final FilePathNode parent;
        @Nullable
        private VirtualFileUrl virtualFileUrl;
        @Nullable
        private ObjectOpenCustomHashSet<FilePathNode> children;
        final /* synthetic */ VirtualFileUrlManagerImpl this$0;

        public FilePathNode(VirtualFileUrlManagerImpl this$0, int nodeId, @Nullable int contentId, FilePathNode parent) {
            this.this$0 = this$0;
            this.nodeId = nodeId;
            this.contentId = contentId;
            this.parent = parent;
        }

        public /* synthetic */ FilePathNode(VirtualFileUrlManagerImpl virtualFileUrlManagerImpl, int n2, int n3, FilePathNode filePathNode, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 4) != 0) {
                filePathNode = null;
            }
            this(virtualFileUrlManagerImpl, n2, n3, filePathNode);
        }

        public final int getNodeId() {
            return this.nodeId;
        }

        public final int getContentId() {
            return this.contentId;
        }

        @Nullable
        public final FilePathNode getParent() {
            return this.parent;
        }

        @Nullable
        public final FilePathNode findChild(int nameId) {
            ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
            return objectOpenCustomHashSet != null ? objectOpenCustomHashSet.get(new FilePathNode(this.this$0, 0, nameId, null, 4, null)) : null;
        }

        @NotNull
        public final List<FilePathNode> getSubtreeNodes() {
            return this.getSubtreeNodes(new ArrayList());
        }

        private final List<FilePathNode> getSubtreeNodes(List<FilePathNode> subtreeNodes) {
            block1: {
                ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
                if (objectOpenCustomHashSet == null) break block1;
                Iterable $this$forEach$iv = objectOpenCustomHashSet;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FilePathNode it = (FilePathNode)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(it);
                    subtreeNodes.add(it);
                    it.getSubtreeNodes(subtreeNodes);
                }
            }
            return subtreeNodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean processChildrenRecursively(@NotNull Function1<? super FilePathNode, ? extends TreeNodeProcessingResult> processor) {
            block10: {
                Iterator childrenCopy;
                Iterator iterator2;
                Intrinsics.checkNotNullParameter(processor, "processor");
                VirtualFileUrlManagerImpl virtualFileUrlManagerImpl = this.this$0;
                synchronized (virtualFileUrlManagerImpl) {
                    boolean bl2 = false;
                    ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
                    iterator2 = objectOpenCustomHashSet != null ? objectOpenCustomHashSet.clone() : null;
                }
                Iterator iterator3 = childrenCopy = iterator2;
                if (iterator3 == null) break block10;
                Iterable $this$forEach$iv = (Iterable)((Object)iterator3);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FilePathNode child = (FilePathNode)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull(child);
                    switch (WhenMappings.$EnumSwitchMapping$0[processor.invoke(child).ordinal()]) {
                        case 1: {
                            if (child.processChildrenRecursively(processor)) break;
                            return false;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            return true;
                        }
                        case 4: {
                            return false;
                        }
                    }
                }
            }
            return true;
        }

        public final void addChild(@NotNull FilePathNode newNode) {
            Intrinsics.checkNotNullParameter(newNode, "newNode");
            this.createChildrenList();
            ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
            Intrinsics.checkNotNull(objectOpenCustomHashSet);
            objectOpenCustomHashSet.add(newNode);
        }

        public final void removeChild(@NotNull FilePathNode node) {
            block0: {
                Intrinsics.checkNotNullParameter(node, "node");
                ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
                if (objectOpenCustomHashSet == null) break block0;
                objectOpenCustomHashSet.remove(node);
            }
        }

        @NotNull
        public final VirtualFileUrl getVirtualFileUrl(@NotNull VirtualFileUrlManagerImpl virtualFileUrlManager) {
            VirtualFileUrl url;
            Intrinsics.checkNotNullParameter(virtualFileUrlManager, "virtualFileUrlManager");
            VirtualFileUrl cachedValue = this.virtualFileUrl;
            if (cachedValue != null) {
                return cachedValue;
            }
            this.virtualFileUrl = url = virtualFileUrlManager.createVirtualFileUrl(this.nodeId, virtualFileUrlManager);
            return url;
        }

        @Nullable
        public final VirtualFileUrl getCachedVirtualFileUrl() {
            return this.virtualFileUrl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isEmpty() {
            if (this.children == null) return true;
            ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
            Intrinsics.checkNotNull(objectOpenCustomHashSet);
            if (!objectOpenCustomHashSet.isEmpty()) return false;
            return true;
        }

        private final void createChildrenList() {
            if (this.children == null) {
                this.children = new ObjectOpenCustomHashSet<FilePathNode>(Companion.getHASHING_STRATEGY());
            }
        }

        @NotNull
        public final String print() {
            StringBuilder buffer = new StringBuilder();
            this.print(buffer, "", "");
            String string2 = buffer.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            return string2;
        }

        private final void print(StringBuilder buffer, String prefix, String childrenPrefix) {
            Object object;
            String name2 = this.this$0.fileNameStore.getNameForId(this.contentId);
            if (name2 != null) {
                buffer.append(prefix + " " + name2 + "\n");
            }
            if ((object = this.children) == null || (object = ((ObjectOpenCustomHashSet)object).iterator()) == null) {
                return;
            }
            Object iterator2 = object;
            while (iterator2.hasNext()) {
                FilePathNode next = (FilePathNode)iterator2.next();
                if (name2 == null) {
                    next.print(buffer, childrenPrefix, childrenPrefix);
                    continue;
                }
                if (iterator2.hasNext()) {
                    next.print(buffer, childrenPrefix + " |- ", childrenPrefix + " |   ");
                    continue;
                }
                next.print(buffer, childrenPrefix + " '- ", childrenPrefix + "     ");
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TreeNodeProcessingResult.values().length];
                try {
                    nArray[TreeNodeProcessingResult.CONTINUE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TreeNodeProcessingResult.SKIP_CHILDREN.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TreeNodeProcessingResult.SKIP_TO_PARENT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TreeNodeProcessingResult.STOP.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

