/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.metadata.diff;

import com.intellij.platform.workspace.storage.metadata.diff.ComparisonResult;
import com.intellij.platform.workspace.storage.metadata.diff.MetadataComparatorLog;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/workspace/storage/metadata/diff/EntitiesComparatorLog;", "Lcom/intellij/platform/workspace/storage/metadata/diff/MetadataComparatorLog;", "()V", "indent", "", "indentLevel", "", "log", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "comparisonResult", "", "output", "Lcom/intellij/platform/workspace/storage/metadata/diff/ComparisonResult;", "endComparing", "isCompared", "getIndent", "ignoreComparing", "isIgnored", "line", "string", "printLog", "startComparing", "toCompare", "Companion", "intellij.platform.workspace.storage"})
public final class EntitiesComparatorLog
implements MetadataComparatorLog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringBuilder log = new StringBuilder();
    @NotNull
    private final String indent;
    private int indentLevel;
    @NotNull
    private static EntitiesComparatorLog INSTANCE = new EntitiesComparatorLog();

    private EntitiesComparatorLog() {
        this.indent = "  ";
    }

    @Override
    public void startComparing(@NotNull String toCompare) {
        Intrinsics.checkNotNullParameter(toCompare, "toCompare");
        this.line("Start comparing " + toCompare);
        int n2 = this.indentLevel;
        this.indentLevel = n2 + 1;
    }

    @Override
    public void comparisonResult(@NotNull String output, @NotNull ComparisonResult comparisonResult) {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(comparisonResult, "comparisonResult");
        this.line(output + " " + this.indent + " Result: " + comparisonResult);
    }

    @Override
    public void endComparing(@NotNull String isCompared, @NotNull ComparisonResult comparisonResult) {
        Intrinsics.checkNotNullParameter(isCompared, "isCompared");
        Intrinsics.checkNotNullParameter(comparisonResult, "comparisonResult");
        int n2 = this.indentLevel;
        this.indentLevel = n2 + -1;
        this.line("End comparing " + isCompared + " " + this.indent + " Result: " + comparisonResult);
    }

    @Override
    public void ignoreComparing(@NotNull String isIgnored) {
        Intrinsics.checkNotNullParameter(isIgnored, "isIgnored");
        this.line(isIgnored + " was not compared");
    }

    private final void line(String string2) {
        StringBuilder stringBuilder = this.log.append(this.getIndent() + string2);
        Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(...)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder.append('\n'), "append(...)");
    }

    @Override
    @NotNull
    public String printLog() {
        String string2 = this.log.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    private final String getIndent() {
        return StringsKt.repeat(this.indent, this.indentLevel);
    }

    public /* synthetic */ EntitiesComparatorLog(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\u0004R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/workspace/storage/metadata/diff/EntitiesComparatorLog$Companion;", "", "()V", "<set-?>", "Lcom/intellij/platform/workspace/storage/metadata/diff/EntitiesComparatorLog;", "INSTANCE", "getINSTANCE", "()Lcom/intellij/platform/workspace/storage/metadata/diff/EntitiesComparatorLog;", "newInstance", "intellij.platform.workspace.storage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntitiesComparatorLog getINSTANCE() {
            return INSTANCE;
        }

        @NotNull
        public final EntitiesComparatorLog newInstance() {
            INSTANCE = new EntitiesComparatorLog(null);
            return this.getINSTANCE();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

