/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.jvm.types.JvmPrimitiveType;
import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiPrimitiveType
extends PsiType.Stub
implements JvmPrimitiveType {
    private static final Map<String, PsiPrimitiveType> ourQNameToUnboxed = new HashMap<String, PsiPrimitiveType>();
    private final JvmPrimitiveTypeKind myKind;
    private final String myName;

    PsiPrimitiveType(@Nullable(value="for NULL type") @Nullable(value="for NULL type") JvmPrimitiveTypeKind kind) {
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myKind = kind;
        if (kind != null) {
            ourQNameToUnboxed.put(kind.getBoxedFqn(), this);
        }
        this.myName = PsiPrimitiveType.getName(kind);
    }

    public PsiPrimitiveType(@Nullable(value="for NULL type") @Nullable(value="for NULL type") JvmPrimitiveTypeKind kind, PsiAnnotation @NotNull [] annotations) {
        if (annotations == null) {
            PsiPrimitiveType.$$$reportNull$$$0(0);
        }
        super(annotations);
        this.myKind = kind;
        this.myName = PsiPrimitiveType.getName(kind);
    }

    public PsiPrimitiveType(@Nullable(value="for NULL type") @Nullable(value="for NULL type") JvmPrimitiveTypeKind kind, @NotNull TypeAnnotationProvider provider) {
        if (provider == null) {
            PsiPrimitiveType.$$$reportNull$$$0(1);
        }
        super(provider);
        this.myKind = kind;
        this.myName = PsiPrimitiveType.getName(kind);
    }

    public PsiPrimitiveType(@NotNull String name2, @NotNull TypeAnnotationProvider provider) {
        if (name2 == null) {
            PsiPrimitiveType.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            PsiPrimitiveType.$$$reportNull$$$0(3);
        }
        super(provider);
        JvmPrimitiveTypeKind kind = JvmPrimitiveTypeKind.getKindByName(name2);
        if (kind == null) {
            throw new NoSuchElementException("Cannot find primitive type: " + name2);
        }
        this.myKind = kind;
        this.myName = name2;
    }

    @NotNull
    @Contract(pure=true)
    private static String getName(@Nullable JvmPrimitiveTypeKind kind) {
        String string2 = kind == null ? "null" : kind.getName();
        if (string2 == null) {
            PsiPrimitiveType.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Override
    @NotNull
    public JvmPrimitiveTypeKind getKind() {
        JvmPrimitiveTypeKind jvmPrimitiveTypeKind = Objects.requireNonNull(this.myKind, "getKind() called on PsiType.NULL\nIf your code works with JvmElement API then this should not happen unless some implementation improperly returns PsiType.NULL from JvmMethod.getReturnType() (or any other available methods).\nIf your code works with PsiType-s then you must check if this type is PsiType.NULL type before calling this method");
        if (jvmPrimitiveTypeKind == null) {
            PsiPrimitiveType.$$$reportNull$$$0(5);
        }
        return jvmPrimitiveTypeKind;
    }

    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            PsiPrimitiveType.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Override
    @NotNull
    public PsiPrimitiveType annotate(@NotNull TypeAnnotationProvider provider) {
        if (provider == null) {
            PsiPrimitiveType.$$$reportNull$$$0(7);
        }
        PsiPrimitiveType psiPrimitiveType = (PsiPrimitiveType)super.annotate(provider);
        if (psiPrimitiveType == null) {
            PsiPrimitiveType.$$$reportNull$$$0(8);
        }
        return psiPrimitiveType;
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        String string2 = this.getText(false, annotated);
        if (string2 == null) {
            PsiPrimitiveType.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string2 = this.getText(true, annotated);
        if (string2 == null) {
            PsiPrimitiveType.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string2 = this.getCanonicalText(true);
        if (string2 == null) {
            PsiPrimitiveType.$$$reportNull$$$0(11);
        }
        return string2;
    }

    private String getText(boolean qualified, boolean annotated) {
        PsiAnnotation[] annotations;
        PsiAnnotation[] psiAnnotationArray = annotations = annotated ? this.getAnnotations() : PsiAnnotation.EMPTY_ARRAY;
        if (annotations.length == 0) {
            return this.myName;
        }
        StringBuilder sb = new StringBuilder();
        PsiNameHelper.appendAnnotations(sb, annotations, qualified);
        sb.append(this.myName);
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        for (PsiAnnotation annotation : this.getAnnotations()) {
            if (annotation.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            PsiPrimitiveType.$$$reportNull$$$0(12);
        }
        return this.myName.equals(text);
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        if (visitor == null) {
            PsiPrimitiveType.$$$reportNull$$$0(13);
        }
        return visitor.visitPrimitiveType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return null;
    }

    @Override
    public PsiType @NotNull [] getSuperTypes() {
        if (EMPTY_ARRAY == null) {
            PsiPrimitiveType.$$$reportNull$$$0(14);
        }
        return EMPTY_ARRAY;
    }

    @Nullable
    public static PsiPrimitiveType getUnboxedType(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiUtil.ensureValidType(type);
        LanguageLevel languageLevel = ((PsiClassType)type).getLanguageLevel();
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return null;
        }
        PsiClass psiClass = ((PsiClassType)type).resolve();
        if (psiClass == null) {
            return null;
        }
        PsiPrimitiveType unboxed = ourQNameToUnboxed.get(psiClass.getQualifiedName());
        if (unboxed == null) {
            return null;
        }
        return unboxed.annotate(type.getAnnotationProvider());
    }

    @Nullable
    public static PsiPrimitiveType getOptionallyUnboxedType(PsiType type) {
        return type instanceof PsiPrimitiveType ? (PsiPrimitiveType)type : PsiPrimitiveType.getUnboxedType(type);
    }

    @Contract(pure=true)
    @Nullable
    public static PsiPrimitiveType fromJvmTypeDescriptor(char descriptor2) {
        switch (descriptor2) {
            case 'B': {
                return PsiTypes.byteType();
            }
            case 'C': {
                return PsiTypes.charType();
            }
            case 'D': {
                return PsiTypes.doubleType();
            }
            case 'F': {
                return PsiTypes.floatType();
            }
            case 'Z': {
                return PsiTypes.booleanType();
            }
            case 'I': {
                return PsiTypes.intType();
            }
            case 'J': {
                return PsiTypes.longType();
            }
            case 'S': {
                return PsiTypes.shortType();
            }
        }
        return null;
    }

    @Nullable
    public String getBoxedTypeName() {
        return this.myKind == null ? null : this.myKind.getBoxedFqn();
    }

    @Nullable
    public PsiClassType getBoxedType(@NotNull PsiElement context2) {
        PsiFile file2;
        if (context2 == null) {
            PsiPrimitiveType.$$$reportNull$$$0(15);
        }
        if ((file2 = context2.getContainingFile()) == null) {
            return null;
        }
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(file2);
        if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
            return null;
        }
        String boxedQName = this.getBoxedTypeName();
        if (boxedQName == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance(file2.getProject());
        PsiClass aClass = facade.findClass(boxedQName, file2.getResolveScope());
        if (aClass == null) {
            return null;
        }
        PsiElementFactory factory = facade.getElementFactory();
        return factory.createType(aClass, PsiSubstitutor.EMPTY, languageLevel).annotate(this.getAnnotationProvider());
    }

    @Nullable
    public PsiClassType getBoxedType(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        String boxedQName;
        if (manager == null) {
            PsiPrimitiveType.$$$reportNull$$$0(16);
        }
        if (resolveScope == null) {
            PsiPrimitiveType.$$$reportNull$$$0(17);
        }
        if ((boxedQName = this.getBoxedTypeName()) == null) {
            return null;
        }
        PsiClass aClass = JavaPsiFacade.getInstance(manager.getProject()).findClass(boxedQName, resolveScope);
        if (aClass == null) {
            return null;
        }
        return JavaPsiFacade.getElementFactory(manager.getProject()).createType(aClass);
    }

    public int hashCode() {
        return this.myKind == null ? 0 : this.myKind.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof PsiPrimitiveType && this.myKind == ((PsiPrimitiveType)obj).myKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiPrimitiveType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiPrimitiveType";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getBoxedType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

