/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLock;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.ReparseableASTNode;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class DiffLog
implements DiffTreeChangeBuilder<ASTNode, ASTNode> {
    private final List<LogEntry> myEntries = new ArrayList<LogEntry>();

    @NotNull
    public TreeChangeEventImpl performActualPsiChange(@NotNull PsiFile file2) {
        if (file2 == null) {
            DiffLog.$$$reportNull$$$0(0);
        }
        TreeAspect modelAspect = PomManager.getModel(file2.getProject()).getModelAspect(TreeAspect.class);
        TreeChangeEventImpl event = new TreeChangeEventImpl(modelAspect, file2.getNode());
        for (LogEntry entry : this.myEntries) {
            entry.doActualPsiChange(file2, event);
        }
        file2.subtreeChanged();
        TreeChangeEventImpl treeChangeEventImpl = event;
        if (treeChangeEventImpl == null) {
            DiffLog.$$$reportNull$$$0(1);
        }
        return treeChangeEventImpl;
    }

    @Override
    public void nodeReplaced(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        if (oldNode == null) {
            DiffLog.$$$reportNull$$$0(2);
        }
        if (newNode == null) {
            DiffLog.$$$reportNull$$$0(3);
        }
        if (oldNode instanceof FileASTNode && newNode instanceof FileASTNode) {
            this.appendReplaceFileElement((FileASTNode)oldNode, (FileASTNode)newNode);
        } else {
            this.myEntries.add(new ReplaceEntry(oldNode, newNode));
        }
    }

    void appendReplaceElementWithEvents(@NotNull CompositeElement oldRoot, @NotNull CompositeElement newRoot) {
        if (oldRoot == null) {
            DiffLog.$$$reportNull$$$0(4);
        }
        if (newRoot == null) {
            DiffLog.$$$reportNull$$$0(5);
        }
        this.myEntries.add(new ReplaceElementWithEvents(oldRoot, newRoot));
    }

    void appendReplaceFileElement(@NotNull FileASTNode oldNode, @NotNull FileASTNode newNode) {
        if (oldNode == null) {
            DiffLog.$$$reportNull$$$0(6);
        }
        if (newNode == null) {
            DiffLog.$$$reportNull$$$0(7);
        }
        this.myEntries.add(new ReplaceFileElement(oldNode, newNode));
    }

    @Override
    public void nodeDeleted(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
        if (oldParent == null) {
            DiffLog.$$$reportNull$$$0(8);
        }
        if (oldNode == null) {
            DiffLog.$$$reportNull$$$0(9);
        }
        this.myEntries.add(new DeleteEntry(oldParent, oldNode));
    }

    @Override
    public void nodeInserted(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
        if (oldParent == null) {
            DiffLog.$$$reportNull$$$0(10);
        }
        if (newNode == null) {
            DiffLog.$$$reportNull$$$0(11);
        }
        this.myEntries.add(new InsertEntry(oldParent, newNode, pos));
    }

    private static PsiElement getPsi(ASTNode node, PsiFile file2) {
        node.putUserData(TreeUtil.CONTAINING_FILE_KEY_AFTER_REPARSE, ((PsiFileImpl)file2).getTreeElement());
        PsiElement psiChild = file2.isPhysical() ? node.getPsi() : null;
        node.putUserData(TreeUtil.CONTAINING_FILE_KEY_AFTER_REPARSE, null);
        return psiChild;
    }

    public void doActualPsiChange(final @NotNull PsiFile file2) {
        if (file2 == null) {
            DiffLog.$$$reportNull$$$0(12);
        }
        CodeStyleManager.getInstance(file2.getProject()).performActionWithFormatterDisabled(() -> {
            FileViewProvider viewProvider = file2.getViewProvider();
            PsiLock psiLock = ((AbstractFileViewProvider)viewProvider).getFilePsiLock();
            synchronized (psiLock) {
                viewProvider.beforeContentsSynchronized();
                Document document = viewProvider.getDocument();
                PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(file2.getProject());
                PsiToDocumentSynchronizer.DocumentChangeTransaction transaction = documentManager.getSynchronizer().getTransaction(document);
                if (transaction == null) {
                    final PomModel model = PomManager.getModel(file2.getProject());
                    model.runTransaction(new PomTransactionBase(file2){

                        @Override
                        @NotNull
                        public PomModelEvent runInner() {
                            return new PomModelEvent(model, DiffLog.this.performActualPsiChange(file2));
                        }
                    });
                } else {
                    this.performActualPsiChange(file2);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/DiffLog";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldNode";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldParent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/DiffLog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "performActualPsiChange";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performActualPsiChange";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nodeReplaced";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendReplaceElementWithEvents";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendReplaceFileElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "nodeDeleted";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "nodeInserted";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doActualPsiChange";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class LogEntry {
        LogEntry() {
            ProgressIndicatorProvider.checkCanceled();
        }

        abstract void doActualPsiChange(@NotNull PsiFile var1, @NotNull TreeChangeEventImpl var2);
    }

    private static final class ReplaceEntry
    extends LogEntry {
        private final ASTNode myOldChild;
        private final ASTNode myNewChild;

        private ReplaceEntry(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
            if (oldNode == null) {
                ReplaceEntry.$$$reportNull$$$0(0);
            }
            if (newNode == null) {
                ReplaceEntry.$$$reportNull$$$0(1);
            }
            this.myOldChild = oldNode;
            this.myNewChild = newNode;
            this.ensureOldParent();
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull TreeChangeEventImpl changeEvent) {
            PsiElement psiOldChild;
            if (file2 == null) {
                ReplaceEntry.$$$reportNull$$$0(2);
            }
            if (changeEvent == null) {
                ReplaceEntry.$$$reportNull$$$0(3);
            }
            ASTNode parent = this.ensureOldParent();
            PsiElement psiParent = parent.getPsi();
            PsiElement psiElement = psiOldChild = file2.isPhysical() ? this.myOldChild.getPsi() : null;
            if (psiParent != null && psiOldChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file2.getManager());
                event.setParent(psiParent);
                event.setFile(file2);
                event.setOldChild(psiOldChild);
                PsiElement psiNewChild = DiffLog.getPsi(this.myNewChild, file2);
                event.setNewChild(psiNewChild);
                ((PsiManagerEx)file2.getManager()).beforeChildReplacement(event);
            }
            if (!(this.myOldChild instanceof FileElement) || !(this.myNewChild instanceof FileElement)) {
                changeEvent.addElementaryChange(this.myOldChild.getTreeParent());
            }
            ((ReparseableASTNode)((Object)this.myOldChild)).applyReplaceOnReparse(this.myNewChild);
            DebugUtil.checkTreeStructure(parent);
        }

        @NotNull
        private ASTNode ensureOldParent() {
            ASTNode parent = this.myOldChild.getTreeParent();
            if (parent == null) {
                throw PsiInvalidElementAccessException.createByNode(this.myOldChild, "new:" + this.myNewChild);
            }
            ASTNode aSTNode = parent;
            if (aSTNode == null) {
                ReplaceEntry.$$$reportNull$$$0(4);
            }
            return aSTNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 4: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeEvent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/DiffLog$ReplaceEntry";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/DiffLog$ReplaceEntry";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ensureOldParent";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doActualPsiChange";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ReplaceElementWithEvents
    extends LogEntry {
        @NotNull
        private final CompositeElement myOldRoot;
        @NotNull
        private final CompositeElement myNewRoot;

        private ReplaceElementWithEvents(@NotNull CompositeElement oldRoot, @NotNull CompositeElement newRoot) {
            if (oldRoot == null) {
                ReplaceElementWithEvents.$$$reportNull$$$0(0);
            }
            if (newRoot == null) {
                ReplaceElementWithEvents.$$$reportNull$$$0(1);
            }
            this.myOldRoot = oldRoot;
            this.myNewRoot = newRoot;
            TreeUtil.ensureParsed(this.myOldRoot.getFirstChildNode());
            TreeUtil.ensureParsed(this.myNewRoot.getFirstChildNode());
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull TreeChangeEventImpl event) {
            if (file2 == null) {
                ReplaceElementWithEvents.$$$reportNull$$$0(2);
            }
            if (event == null) {
                ReplaceElementWithEvents.$$$reportNull$$$0(3);
            }
            this.myOldRoot.replaceAllChildrenToChildrenOf(this.myNewRoot);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldRoot";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRoot";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/DiffLog$ReplaceElementWithEvents";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doActualPsiChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ReplaceFileElement
    extends LogEntry {
        @NotNull
        private final FileASTNode myOldNode;
        @NotNull
        private final FileASTNode myNewNode;

        private ReplaceFileElement(@NotNull FileASTNode oldNode, @NotNull FileASTNode newNode) {
            if (oldNode == null) {
                ReplaceFileElement.$$$reportNull$$$0(0);
            }
            if (newNode == null) {
                ReplaceFileElement.$$$reportNull$$$0(1);
            }
            this.myOldNode = oldNode;
            this.myNewNode = newNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull TreeChangeEventImpl event) {
            if (file2 == null) {
                ReplaceFileElement.$$$reportNull$$$0(2);
            }
            if (event == null) {
                ReplaceFileElement.$$$reportNull$$$0(3);
            }
            event.addElementaryChange(this.myOldNode);
            ((ReparseableASTNode)((Object)this.myOldNode)).applyReplaceFileOnReparse(file2, this.myNewNode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/DiffLog$ReplaceFileElement";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doActualPsiChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DeleteEntry
    extends LogEntry {
        @NotNull
        private final ASTNode myOldParent;
        @NotNull
        private final ASTNode myOldNode;

        private DeleteEntry(@NotNull ASTNode oldParent, @NotNull ASTNode oldNode) {
            if (oldParent == null) {
                DeleteEntry.$$$reportNull$$$0(0);
            }
            if (oldNode == null) {
                DeleteEntry.$$$reportNull$$$0(1);
            }
            this.myOldParent = oldParent;
            this.myOldNode = oldNode;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull TreeChangeEventImpl changeEvent) {
            PsiElement psiChild;
            if (file2 == null) {
                DeleteEntry.$$$reportNull$$$0(2);
            }
            if (changeEvent == null) {
                DeleteEntry.$$$reportNull$$$0(3);
            }
            PsiElement psiParent = this.myOldParent.getPsi();
            PsiElement psiElement = psiChild = file2.isPhysical() ? this.myOldNode.getPsi() : null;
            if (psiParent != null && psiChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file2.getManager());
                event.setParent(psiParent);
                event.setChild(psiChild);
                event.setFile(file2);
                ((PsiManagerEx)file2.getManager()).beforeChildRemoval(event);
            }
            changeEvent.addElementaryChange(this.myOldParent);
            ((ReparseableASTNode)((Object)this.myOldParent)).applyDeleteOnReparse(this.myOldNode);
            DebugUtil.checkTreeStructure(this.myOldParent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldParent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeEvent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/DiffLog$DeleteEntry";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doActualPsiChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class InsertEntry
    extends LogEntry {
        @NotNull
        private final ASTNode myOldParent;
        @NotNull
        private final ASTNode myNewNode;
        private final int myPos;

        private InsertEntry(@NotNull ASTNode oldParent, @NotNull ASTNode newNode, int pos) {
            if (oldParent == null) {
                InsertEntry.$$$reportNull$$$0(0);
            }
            if (newNode == null) {
                InsertEntry.$$$reportNull$$$0(1);
            }
            assert (pos >= 0) : pos;
            this.myOldParent = oldParent;
            this.myNewNode = newNode;
            this.myPos = pos;
        }

        @Override
        void doActualPsiChange(@NotNull PsiFile file2, @NotNull TreeChangeEventImpl changeEvent) {
            if (file2 == null) {
                InsertEntry.$$$reportNull$$$0(2);
            }
            if (changeEvent == null) {
                InsertEntry.$$$reportNull$$$0(3);
            }
            ASTNode anchor = null;
            ASTNode firstChildNode = this.myOldParent.getFirstChildNode();
            for (int i2 = 0; i2 < this.myPos; ++i2) {
                anchor = anchor == null ? firstChildNode : anchor.getTreeNext();
            }
            PsiElement psiParent = this.myOldParent.getPsi();
            PsiElement psiChild = DiffLog.getPsi(this.myNewNode, file2);
            if (psiParent != null && psiChild != null) {
                PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(file2.getManager());
                event.setParent(psiParent);
                event.setChild(psiChild);
                event.setFile(file2);
                ((PsiManagerEx)file2.getManager()).beforeChildAddition(event);
            }
            changeEvent.addElementaryChange(this.myOldParent);
            ((ReparseableASTNode)((Object)this.myOldParent)).applyInsertOnReparse(this.myNewNode, anchor);
            DebugUtil.checkTreeStructure(this.myOldParent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldParent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeEvent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/DiffLog$InsertEntry";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doActualPsiChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

