/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.cache.TypeAnnotationContainer;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.BitUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeInfo {
    private static final int HAS_TYPE_ANNOTATIONS = 128;
    public static final TypeInfo[] EMPTY_ARRAY = new TypeInfo[0];
    private static final String[] ourIndexFrequentType;
    private static final Object2IntMap<String> ourFrequentTypeIndex;
    private static final int ourTypeLengthMask;
    private static final TypeKind[] ALL_KINDS;
    private static final Map<String, TypeKind> TEXT_TO_KIND;
    @NotNull
    private final TypeKind kind;
    private TypeAnnotationContainer myTypeAnnotations;
    private static final TokenSet PRIMITIVE_TYPES;

    private TypeInfo(@NotNull TypeKind kind) {
        if (kind == null) {
            TypeInfo.$$$reportNull$$$0(0);
        }
        this.kind = kind;
    }

    String text(boolean isShort) {
        return isShort && this.kind.text == null ? "" : this.kind.text;
    }

    public final String text() {
        return this.text(false);
    }

    @NotNull
    public final TypeKind getKind() {
        TypeKind typeKind = this.kind;
        if (typeKind == null) {
            TypeInfo.$$$reportNull$$$0(1);
        }
        return typeKind;
    }

    public int innerDepth() {
        return 0;
    }

    public boolean isEllipsis() {
        return this.kind == TypeKind.ELLIPSIS;
    }

    public TypeInfo withEllipsis() {
        throw new UnsupportedOperationException();
    }

    public void setTypeAnnotations(@NotNull TypeAnnotationContainer typeAnnotations) {
        if (typeAnnotations == null) {
            TypeInfo.$$$reportNull$$$0(2);
        }
        if (this == SimpleTypeInfo.NULL) {
            return;
        }
        if (this.myTypeAnnotations != null) {
            throw new IllegalStateException();
        }
        this.myTypeAnnotations = typeAnnotations;
    }

    @NotNull
    public TypeAnnotationContainer getTypeAnnotations() {
        TypeAnnotationContainer typeAnnotationContainer = this.myTypeAnnotations == null ? TypeAnnotationContainer.EMPTY : this.myTypeAnnotations;
        if (typeAnnotationContainer == null) {
            TypeInfo.$$$reportNull$$$0(3);
        }
        return typeAnnotationContainer;
    }

    @NotNull
    public String getShortTypeText() {
        String string2 = this.text(true);
        if (string2 == null) {
            TypeInfo.$$$reportNull$$$0(4);
        }
        return string2;
    }

    public String toString() {
        String text = this.text();
        return text != null ? text : "null";
    }

    @NotNull
    public static TypeInfo createConstructorType() {
        SimpleTypeInfo simpleTypeInfo = SimpleTypeInfo.NULL;
        if (simpleTypeInfo == null) {
            TypeInfo.$$$reportNull$$$0(5);
        }
        return simpleTypeInfo;
    }

    @NotNull
    public static TypeInfo create(@NotNull LighterAST tree, @NotNull LighterASTNode element, StubElement<?> parentStub) {
        if (tree == null) {
            TypeInfo.$$$reportNull$$$0(6);
        }
        if (element == null) {
            TypeInfo.$$$reportNull$$$0(7);
        }
        int arrayCount = 0;
        LighterASTNode typeElement = null;
        if (element.getTokenType() == JavaElementType.ENUM_CONSTANT) {
            TypeInfo typeInfo = ((PsiClassStubImpl)parentStub).getQualifiedNameTypeInfo();
            if (typeInfo == null) {
                TypeInfo.$$$reportNull$$$0(8);
            }
            return typeInfo;
        }
        for (LighterASTNode child : tree.getChildren(element)) {
            IElementType type = child.getTokenType();
            if (type == JavaElementType.TYPE) {
                typeElement = child;
                continue;
            }
            if (type != JavaTokenType.LBRACKET) continue;
            ++arrayCount;
        }
        if (typeElement == null && element.getTokenType() == JavaElementType.FIELD) {
            LighterASTNode parent = tree.getParent(element);
            assert (parent != null) : element;
            List<LighterASTNode> fields2 = LightTreeUtil.getChildrenOfType(tree, parent, JavaElementType.FIELD);
            int idx = fields2.indexOf(element);
            for (int i2 = idx - 1; i2 >= 0 && typeElement == null; --i2) {
                typeElement = LightTreeUtil.firstChildOfType(tree, fields2.get(i2), JavaElementType.TYPE);
            }
        }
        assert (typeElement != null) : element + " in " + parentStub;
        TypeInfo typeInfo = TypeInfo.fromTypeElement(tree, typeElement);
        for (int i3 = 0; i3 < arrayCount; ++i3) {
            typeInfo = typeInfo.arrayOf();
        }
        byte[] prefix = new byte[arrayCount];
        Arrays.fill(prefix, (byte)0);
        TypeAnnotationContainer.Collector collector2 = new TypeAnnotationContainer.Collector(typeInfo);
        TypeInfo.collectAnnotations(typeInfo, collector2, tree, typeElement, prefix);
        collector2.install();
        TypeInfo typeInfo2 = typeInfo;
        if (typeInfo2 == null) {
            TypeInfo.$$$reportNull$$$0(9);
        }
        return typeInfo2;
    }

    private static void collectAnnotations(@NotNull TypeInfo info, @NotNull TypeAnnotationContainer.Collector collector2, @NotNull LighterAST tree, @NotNull LighterASTNode element, byte @NotNull [] prefix) {
        if (info == null) {
            TypeInfo.$$$reportNull$$$0(10);
        }
        if (collector2 == null) {
            TypeInfo.$$$reportNull$$$0(11);
        }
        if (tree == null) {
            TypeInfo.$$$reportNull$$$0(12);
        }
        if (element == null) {
            TypeInfo.$$$reportNull$$$0(13);
        }
        if (prefix == null) {
            TypeInfo.$$$reportNull$$$0(14);
        }
        int arrayCount = 0;
        List<LighterASTNode> children2 = tree.getChildren(element);
        for (LighterASTNode child : children2) {
            IElementType tokenType = child.getTokenType();
            if (tokenType != JavaTokenType.LBRACKET) continue;
            ++arrayCount;
        }
        int nestingLevel = 0;
        boolean bound = false;
        for (LighterASTNode child : children2) {
            IElementType tokenType = child.getTokenType();
            if (tokenType == JavaTokenType.EXTENDS_KEYWORD || tokenType == JavaTokenType.SUPER_KEYWORD) {
                bound = true;
            }
            if (tokenType == JavaElementType.TYPE && info instanceof DerivedTypeInfo) {
                byte[] newPrefix;
                if (bound) {
                    newPrefix = Arrays.copyOf(prefix, prefix.length + 1);
                    newPrefix[prefix.length] = 2;
                } else {
                    newPrefix = Arrays.copyOf(prefix, prefix.length + arrayCount);
                    Arrays.fill(newPrefix, prefix.length, newPrefix.length, (byte)0);
                }
                TypeInfo.collectAnnotations(((DerivedTypeInfo)info).child(), collector2, tree, child, newPrefix);
                continue;
            }
            if (tokenType == JavaTokenType.LBRACKET) {
                ++nestingLevel;
                continue;
            }
            if (tokenType != JavaElementType.ANNOTATION) continue;
            String anno = LightTreeUtil.toFilteredString(tree, child, null);
            byte[] typePath = Arrays.copyOf(prefix, prefix.length + nestingLevel);
            Arrays.fill(typePath, prefix.length, typePath.length, (byte)0);
            collector2.add(typePath, anno);
        }
    }

    @NotNull
    private static TypeInfo fromTypeElement(@NotNull LighterAST tree, @NotNull LighterASTNode typeElement) {
        if (tree == null) {
            TypeInfo.$$$reportNull$$$0(15);
        }
        if (typeElement == null) {
            TypeInfo.$$$reportNull$$$0(16);
        }
        TypeInfo info = null;
        TypeKind derivedKind = null;
        for (LighterASTNode child : tree.getChildren(typeElement)) {
            IElementType tokenType = child.getTokenType();
            if (PRIMITIVE_TYPES.contains(tokenType)) {
                info = new SimpleTypeInfo(TEXT_TO_KIND.get(((LighterASTTokenNode)child).getText().toString()));
            } else if (tokenType == JavaElementType.TYPE) {
                info = TypeInfo.fromTypeElement(tree, child);
            } else if (tokenType == JavaElementType.DUMMY_ELEMENT) {
                info = TypeInfo.fromString(LightTreeUtil.toFilteredString(tree, child, null));
            } else if (tokenType == JavaElementType.JAVA_CODE_REFERENCE) {
                info = TypeInfo.fromCodeReference(tree, child);
            } else if (tokenType == JavaTokenType.EXTENDS_KEYWORD) {
                derivedKind = TypeKind.EXTENDS;
            } else if (tokenType == JavaTokenType.SUPER_KEYWORD) {
                derivedKind = TypeKind.SUPER;
            } else if (tokenType == JavaTokenType.QUEST) {
                info = new SimpleTypeInfo(TypeKind.WILDCARD);
            }
            if (tokenType == JavaTokenType.LBRACKET) {
                info = ((TypeInfo)Objects.requireNonNull(info)).arrayOf();
                continue;
            }
            if (tokenType != JavaTokenType.ELLIPSIS) continue;
            info = ((TypeInfo)Objects.requireNonNull(info)).arrayOf().withEllipsis();
        }
        if (info == null) {
            throw new IllegalArgumentException("Malformed type: " + LightTreeUtil.toFilteredString(tree, typeElement, null));
        }
        if (derivedKind != null) {
            info = new DerivedTypeInfo(derivedKind, info);
        }
        DerivedTypeInfo derivedTypeInfo = info;
        if (derivedTypeInfo == null) {
            TypeInfo.$$$reportNull$$$0(17);
        }
        return derivedTypeInfo;
    }

    private static RefTypeInfo fromCodeReference(@NotNull LighterAST tree, @NotNull LighterASTNode ref) {
        if (tree == null) {
            TypeInfo.$$$reportNull$$$0(18);
        }
        if (ref == null) {
            TypeInfo.$$$reportNull$$$0(19);
        }
        RefTypeInfo info = null;
        for (LighterASTNode child : tree.getChildren(ref)) {
            IElementType tokenType = child.getTokenType();
            if (tokenType == JavaElementType.JAVA_CODE_REFERENCE) {
                info = TypeInfo.fromCodeReference(tree, child);
                continue;
            }
            if (tokenType == JavaTokenType.IDENTIFIER) {
                String text = ((LighterASTTokenNode)child).getText().toString();
                info = new RefTypeInfo(text, info);
                continue;
            }
            if (tokenType != JavaElementType.REFERENCE_PARAMETER_LIST) continue;
            if (info == null) {
                throw new IllegalArgumentException("Malformed type: " + LightTreeUtil.toFilteredString(tree, ref, null));
            }
            ArrayList<TypeInfo> components = new ArrayList<TypeInfo>();
            for (LighterASTNode component : tree.getChildren(child)) {
                if (component.getTokenType() != JavaElementType.TYPE) continue;
                components.add(TypeInfo.fromTypeElement(tree, component));
            }
            info = info.withComponents(components);
        }
        return info;
    }

    @NotNull
    public DerivedTypeInfo arrayOf() {
        return new DerivedTypeInfo(TypeKind.ARRAY, this);
    }

    @Deprecated
    @NotNull
    public static TypeInfo fromString(@Nullable String text, boolean ellipsis) {
        TypeInfo typeInfo = TypeInfo.fromString(text);
        TypeInfo typeInfo2 = ellipsis ? typeInfo.withEllipsis() : typeInfo;
        if (typeInfo2 == null) {
            TypeInfo.$$$reportNull$$$0(20);
        }
        return typeInfo2;
    }

    @NotNull
    public static TypeInfo fromString(@Nullable String text) {
        if (text == null) {
            SimpleTypeInfo simpleTypeInfo = SimpleTypeInfo.NULL;
            if (simpleTypeInfo == null) {
                TypeInfo.$$$reportNull$$$0(21);
            }
            return simpleTypeInfo;
        }
        TypeKind kind = TEXT_TO_KIND.get(text);
        if (kind != null) {
            return kind.isReference() ? new RefTypeInfo(text) : new SimpleTypeInfo(kind);
        }
        if (text.startsWith("? extends ")) {
            return new DerivedTypeInfo(TypeKind.EXTENDS, TypeInfo.fromString(text.substring("? extends ".length())));
        }
        if (text.startsWith("? super ")) {
            return new DerivedTypeInfo(TypeKind.SUPER, TypeInfo.fromString(text.substring("? super ".length())));
        }
        if (text.endsWith("[]")) {
            DerivedTypeInfo derivedTypeInfo = TypeInfo.fromString(text.substring(0, text.length() - 2)).arrayOf();
            if (derivedTypeInfo == null) {
                TypeInfo.$$$reportNull$$$0(22);
            }
            return derivedTypeInfo;
        }
        if (text.endsWith("...")) {
            return new DerivedTypeInfo(TypeKind.ELLIPSIS, TypeInfo.fromString(text.substring(0, text.length() - 3)));
        }
        if (text.endsWith(">")) {
            int depth = 1;
            int end = text.length() - 1;
            ArrayList<TypeInfo> components = new ArrayList<TypeInfo>();
            for (int pos = end - 1; pos > 0; --pos) {
                String name2;
                RefTypeInfo outer;
                String component;
                char ch = text.charAt(pos);
                if (ch == '>') {
                    ++depth;
                    continue;
                }
                if (ch == ',' && depth == 1) {
                    component = text.substring(pos + 1, end);
                    end = pos;
                    components.add(TypeInfo.fromString(component));
                    continue;
                }
                if (ch != '<' || --depth != 0) continue;
                component = text.substring(pos + 1, end);
                components.add(TypeInfo.fromString(component));
                Collections.reverse(components);
                int prevGeneric = text.lastIndexOf(62, pos);
                if (prevGeneric > 0) {
                    if (text.charAt(prevGeneric + 1) != '.') {
                        throw new IllegalArgumentException("Malformed type: " + text);
                    }
                    outer = (RefTypeInfo)TypeInfo.fromString(text.substring(0, prevGeneric + 1));
                    name2 = text.substring(prevGeneric + 2, pos);
                } else {
                    name2 = text.substring(0, pos);
                    outer = null;
                }
                return new RefTypeInfo(name2, outer, components.toArray(EMPTY_ARRAY));
            }
            throw new IllegalArgumentException("Malformed type: " + text);
        }
        return new RefTypeInfo(text);
    }

    @NotNull
    public static TypeInfo readTYPE(@NotNull StubInputStream record) throws IOException {
        TypeInfo info;
        if (record == null) {
            TypeInfo.$$$reportNull$$$0(23);
        }
        int flags = record.readByte() & 0xFF;
        boolean hasTypeAnnotations = BitUtil.isSet(flags, 128);
        int kindOrdinal = BitUtil.clear(flags, 128);
        if (kindOrdinal >= ALL_KINDS.length) {
            throw new IOException("Unexpected TypeKind: " + flags);
        }
        TypeKind kind = ALL_KINDS[kindOrdinal];
        RefTypeInfo outer = null;
        switch (kind) {
            case REF: {
                info = new RefTypeInfo(Objects.requireNonNull(record.readNameString()));
                break;
            }
            case INNER_SIMPLE: {
                outer = new RefTypeInfo(Objects.requireNonNull(record.readNameString()));
                info = new RefTypeInfo(Objects.requireNonNull(record.readNameString()), outer);
                break;
            }
            case INNER: {
                outer = (RefTypeInfo)TypeInfo.readTYPE(record);
                info = new RefTypeInfo(Objects.requireNonNull(record.readNameString()), outer);
                break;
            }
            case INNER_GENERIC: {
                outer = (RefTypeInfo)TypeInfo.readTYPE(record);
            }
            case GENERIC: {
                String name2 = Objects.requireNonNull(record.readNameString());
                int count2 = record.readByte();
                TypeInfo[] components = new TypeInfo[count2];
                for (int i2 = 0; i2 < count2; ++i2) {
                    components[i2] = TypeInfo.readTYPE(record);
                }
                info = new RefTypeInfo(name2, outer, components);
                break;
            }
            case ELLIPSIS: 
            case ARRAY: 
            case EXTENDS: 
            case SUPER: {
                info = new DerivedTypeInfo(kind, TypeInfo.readTYPE(record));
                break;
            }
            default: {
                info = kind.isReference() ? new RefTypeInfo(Objects.requireNonNull(kind.text)) : new SimpleTypeInfo(kind);
            }
        }
        info.setTypeAnnotations(hasTypeAnnotations ? TypeAnnotationContainer.readTypeAnnotations(record) : TypeAnnotationContainer.EMPTY);
        TypeInfo typeInfo = info;
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(24);
        }
        return typeInfo;
    }

    public static void writeTYPE(@NotNull StubOutputStream dataStream, @NotNull TypeInfo typeInfo) throws IOException {
        if (dataStream == null) {
            TypeInfo.$$$reportNull$$$0(25);
        }
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(26);
        }
        boolean hasTypeAnnotations = typeInfo.myTypeAnnotations != null && !typeInfo.myTypeAnnotations.isEmpty();
        dataStream.writeByte(typeInfo.kind.ordinal() | (hasTypeAnnotations ? 128 : 0));
        if (typeInfo instanceof DerivedTypeInfo) {
            TypeInfo.writeTYPE(dataStream, ((DerivedTypeInfo)typeInfo).myChild);
        } else if (typeInfo instanceof RefTypeInfo && typeInfo.kind.text == null) {
            if (typeInfo.kind == TypeKind.INNER_SIMPLE) {
                dataStream.writeName(Objects.requireNonNull(((RefTypeInfo)typeInfo).myOuter).myName);
            }
            if (typeInfo.kind == TypeKind.INNER || typeInfo.kind == TypeKind.INNER_GENERIC) {
                TypeInfo.writeTYPE(dataStream, Objects.requireNonNull(((RefTypeInfo)typeInfo).myOuter));
            }
            dataStream.writeName(((RefTypeInfo)typeInfo).myName);
            if (typeInfo.kind == TypeKind.INNER_GENERIC || typeInfo.kind == TypeKind.GENERIC) {
                TypeInfo[] components = ((RefTypeInfo)typeInfo).myComponents;
                dataStream.writeByte(components.length);
                for (TypeInfo component : components) {
                    TypeInfo.writeTYPE(dataStream, component);
                }
            }
        }
        if (hasTypeAnnotations) {
            TypeAnnotationContainer.writeTypeAnnotations(dataStream, typeInfo.myTypeAnnotations);
        }
    }

    @Deprecated
    @Nullable
    public static String createTypeText(@NotNull TypeInfo typeInfo) {
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(27);
        }
        return typeInfo.text();
    }

    @NotNull
    public static String internFrequentType(@NotNull String type) {
        if (type == null) {
            TypeInfo.$$$reportNull$$$0(28);
        }
        int frequentIndex = type.length() < 32 && (ourTypeLengthMask & 1 << type.length()) != 0 ? ourFrequentTypeIndex.getInt(type) : 0;
        String string2 = frequentIndex == 0 ? StringUtil.internEmptyString(type) : ourIndexFrequentType[frequentIndex];
        if (string2 == null) {
            TypeInfo.$$$reportNull$$$0(29);
        }
        return string2;
    }

    static {
        int typeLengthMask = 0;
        ourIndexFrequentType = new String[]{"", "boolean", "byte", "char", "double", "float", "int", "long", "null", "short", "void", "Object", "java.lang.Object", "String", "java.lang.String"};
        ourFrequentTypeIndex = new Object2IntOpenHashMap<String>();
        for (int i2 = 0; i2 < ourIndexFrequentType.length; ++i2) {
            String type = ourIndexFrequentType[i2];
            ourFrequentTypeIndex.put(type, i2);
            assert (type.length() < 32);
            typeLengthMask |= 1 << type.length();
        }
        assert (ourFrequentTypeIndex.size() == ourIndexFrequentType.length);
        ourTypeLengthMask = typeLengthMask;
        ALL_KINDS = TypeKind.values();
        TEXT_TO_KIND = StreamEx.of(ALL_KINDS).mapToEntry(kind -> ((TypeKind)kind).text, kind -> kind).nonNullKeys().toImmutableMap();
        PRIMITIVE_TYPES = TokenSet.create(JavaTokenType.INT_KEYWORD, JavaTokenType.CHAR_KEYWORD, JavaTokenType.LONG_KEYWORD, JavaTokenType.DOUBLE_KEYWORD, JavaTokenType.FLOAT_KEYWORD, JavaTokenType.SHORT_KEYWORD, JavaTokenType.BOOLEAN_KEYWORD, JavaTokenType.BYTE_KEYWORD, JavaTokenType.VOID_KEYWORD);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 29: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 29: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/TypeInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAnnotations";
                break;
            }
            case 6: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/TypeInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAnnotations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortTypeText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTypeElement";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "readTYPE";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "internFrequentType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 29: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTypeAnnotations";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectAnnotations";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fromTypeElement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fromCodeReference";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "readTYPE";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "writeTYPE";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createTypeText";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "internFrequentType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 29: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TypeKind {
        NULL,
        REF,
        GENERIC,
        JAVA_LANG_OBJECT("java.lang.Object"),
        JAVA_LANG_STRING("java.lang.String"),
        JAVA_LANG_THROWABLE("java.lang.Throwable"),
        JAVA_LANG_EXCEPTION("java.lang.Exception"),
        JAVA_UTIL_COLLECTION("java.util.Collection"),
        JAVA_UTIL_LIST("java.util.List"),
        JAVA_LANG_ITERABLE("java.lang.Iterable"),
        JAVA_UTIL_ITERATOR("java.util.Iterator"),
        JAVA_UTIL_MAP("java.util.Map"),
        JAVA_LANG_ANNOTATION_ANNOTATION("java.lang.annotation.Annotation"),
        INNER,
        INNER_SIMPLE,
        INNER_GENERIC,
        EXTENDS,
        SUPER,
        ARRAY,
        ELLIPSIS,
        BOOLEAN("boolean"),
        BYTE("byte"),
        CHAR("char"),
        DOUBLE("double"),
        FLOAT("float"),
        INT("int"),
        LONG("long"),
        SHORT("short"),
        VOID("void"),
        OBJECT("Object"),
        STRING("String"),
        WILDCARD("?");

        @Nullable
        private final String text;

        private TypeKind() {
            this(null);
        }

        private TypeKind(String text) {
            this.text = text;
        }

        boolean isReference() {
            return this.ordinal() >= REF.ordinal() && this.ordinal() <= INNER_GENERIC.ordinal();
        }

        boolean isDerived() {
            return this.ordinal() >= EXTENDS.ordinal() && this.ordinal() <= ELLIPSIS.ordinal();
        }
    }

    public static final class SimpleTypeInfo
    extends TypeInfo {
        public static final SimpleTypeInfo NULL = new SimpleTypeInfo(TypeKind.NULL);

        public SimpleTypeInfo(@NotNull TypeKind kind) {
            if (kind == null) {
                SimpleTypeInfo.$$$reportNull$$$0(0);
            }
            super(kind);
            if (kind.isDerived() || kind.isReference()) {
                throw new IllegalArgumentException(kind.toString());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/psi/impl/cache/TypeInfo$SimpleTypeInfo", "<init>"));
        }
    }

    public static final class DerivedTypeInfo
    extends TypeInfo {
        private final TypeInfo myChild;

        public DerivedTypeInfo(@NotNull TypeKind kind, @NotNull TypeInfo child) {
            if (kind == null) {
                DerivedTypeInfo.$$$reportNull$$$0(0);
            }
            if (child == null) {
                DerivedTypeInfo.$$$reportNull$$$0(1);
            }
            super(kind);
            assert (kind.isDerived());
            this.myChild = child;
        }

        public TypeInfo child() {
            return this.myChild;
        }

        @Override
        public TypeInfo withEllipsis() {
            switch (this.getKind()) {
                case ELLIPSIS: {
                    return this;
                }
                case ARRAY: {
                    return new DerivedTypeInfo(TypeKind.ELLIPSIS, this.myChild);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        String text(boolean isShort) {
            switch (this.getKind()) {
                case EXTENDS: {
                    return "? extends " + this.myChild.text(isShort);
                }
                case SUPER: {
                    return "? super " + this.myChild.text(isShort);
                }
                case ARRAY: {
                    return this.myChild.text(isShort) + "[]";
                }
                case ELLIPSIS: {
                    return this.myChild.text(isShort) + "...";
                }
            }
            throw new IllegalStateException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "child";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/cache/TypeInfo$DerivedTypeInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class RefTypeInfo
    extends TypeInfo {
        private final String myName;
        @Nullable
        private final RefTypeInfo myOuter;
        @NotNull
        private final @NotNull TypeInfo @NotNull [] myComponents;

        public RefTypeInfo(@NotNull String name2) {
            if (name2 == null) {
                RefTypeInfo.$$$reportNull$$$0(0);
            }
            this(name2, null, EMPTY_ARRAY);
        }

        public RefTypeInfo(@NotNull String name2, @Nullable RefTypeInfo outer) {
            if (name2 == null) {
                RefTypeInfo.$$$reportNull$$$0(1);
            }
            this(name2, outer, EMPTY_ARRAY);
        }

        public RefTypeInfo(@NotNull String name2, @Nullable RefTypeInfo outer, @NotNull @NotNull TypeInfo @NotNull [] components) {
            if (name2 == null) {
                RefTypeInfo.$$$reportNull$$$0(2);
            }
            if (components == null) {
                RefTypeInfo.$$$reportNull$$$0(3);
            }
            super(outer != null ? (components.length == 0 ? (outer.getKind() == TypeKind.REF ? TypeKind.INNER_SIMPLE : TypeKind.INNER) : TypeKind.INNER_GENERIC) : (components.length == 0 ? TEXT_TO_KIND.getOrDefault(name2, TypeKind.REF) : TypeKind.GENERIC));
            this.myName = name2;
            this.myComponents = components;
            this.myOuter = outer;
        }

        @Override
        public String text(boolean isShort) {
            if (isShort) {
                return StringUtil.getShortName(this.myName);
            }
            if (this.myComponents.length == 0) {
                return this.myOuter != null ? this.myOuter.text(isShort) + "." + this.myName : this.myName;
            }
            StringBuilder sb = new StringBuilder();
            if (this.myOuter != null) {
                sb.append(this.myOuter.text(isShort));
                sb.append(".");
            }
            sb.append(this.myName);
            sb.append("<");
            for (int i2 = 0; i2 < this.myComponents.length; ++i2) {
                if (i2 > 0) {
                    sb.append(",");
                }
                sb.append(this.myComponents[i2].text());
            }
            sb.append(">");
            return sb.toString();
        }

        @Override
        public int innerDepth() {
            return this.myOuter != null ? this.myOuter.innerDepth() + 1 : 0;
        }

        @NotNull
        public RefTypeInfo withComponents(@NotNull List<TypeInfo> components) {
            if (components == null) {
                RefTypeInfo.$$$reportNull$$$0(4);
            }
            return new RefTypeInfo(this.myName, this.myOuter, components.toArray(EMPTY_ARRAY));
        }

        @NotNull
        public RefTypeInfo withOuter(@Nullable RefTypeInfo outer) {
            if (this.myOuter != null) {
                return new RefTypeInfo(this.myName, this.myOuter.withOuter(outer), this.myComponents);
            }
            return new RefTypeInfo(this.myName, outer, this.myComponents);
        }

        @Nullable
        public TypeInfo genericComponent(int index2) {
            return index2 >= this.myComponents.length ? null : this.myComponents[index2];
        }

        @Nullable
        public TypeInfo outerType() {
            return this.myOuter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/cache/TypeInfo$RefTypeInfo";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withComponents";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

