/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiParameterListImpl
extends JavaStubPsiElement<PsiParameterListStub>
implements PsiParameterList {
    private static final Logger LOG = Logger.getInstance(PsiParameterListImpl.class);

    public PsiParameterListImpl(@NotNull PsiParameterListStub stub) {
        if (stub == null) {
            PsiParameterListImpl.$$$reportNull$$$0(0);
        }
        super(stub, (IStubElementType)JavaStubElementTypes.PARAMETER_LIST);
    }

    public PsiParameterListImpl(@NotNull ASTNode node) {
        if (node == null) {
            PsiParameterListImpl.$$$reportNull$$$0(1);
        }
        super(node);
    }

    @Override
    public PsiParameter @NotNull [] getParameters() {
        PsiParameter[] psiParameterArray = (PsiParameter[])this.getStubOrPsiChildren(JavaStubElementTypes.PARAMETER, PsiParameter.ARRAY_FACTORY);
        if (psiParameterArray == null) {
            PsiParameterListImpl.$$$reportNull$$$0(2);
        }
        return psiParameterArray;
    }

    @Override
    public int getParameterIndex(@NotNull PsiParameter parameter) {
        PsiElement parent;
        if (parameter == null) {
            PsiParameterListImpl.$$$reportNull$$$0(3);
        }
        if ((parent = parameter.getParent()) != this) {
            LOG.error("Not my parameter; parameter class = " + parameter.getClass() + "; this class = " + this.getClass() + "; parameter parent class = " + (parent == null ? null : parent.getClass()));
        }
        return PsiImplUtil.getParameterIndex(parameter, this);
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            PsiParameterListImpl.$$$reportNull$$$0(4);
        }
        return compositeElement;
    }

    @Override
    public int getParametersCount() {
        PsiParameterListStub stub = (PsiParameterListStub)this.getGreenStub();
        if (stub != null) {
            int count2 = 0;
            for (StubElement child : stub.getChildrenStubs()) {
                if (child.getStubType() != JavaStubElementTypes.PARAMETER) continue;
                ++count2;
            }
            return count2;
        }
        return this.getNode().countChildren(Constants.PARAMETER_BIT_SET);
    }

    @Override
    @Nullable
    public PsiParameter getParameter(int index2) {
        if (index2 < 0) {
            throw new IllegalArgumentException("index is negative: " + index2);
        }
        PsiParameterListStub stub = (PsiParameterListStub)this.getGreenStub();
        if (stub != null) {
            int count2 = 0;
            for (StubElement child : stub.getChildrenStubs()) {
                if (child.getStubType() != JavaStubElementTypes.PARAMETER) continue;
                if (count2 == index2) {
                    return (PsiParameter)child.getPsi();
                }
                ++count2;
            }
        } else {
            CompositeElement node = this.getNode();
            int count3 = 0;
            for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (child.getElementType() != JavaStubElementTypes.PARAMETER) continue;
                if (count3 == index2) {
                    return (PsiParameter)child.getPsi();
                }
                ++count3;
            }
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        PsiParameterListStub stub = (PsiParameterListStub)this.getGreenStub();
        if (stub != null) {
            for (StubElement child : stub.getChildrenStubs()) {
                if (child.getStubType() != JavaStubElementTypes.PARAMETER) continue;
                return false;
            }
            return true;
        }
        return this.getNode().findChildByType(Constants.PARAMETER_BIT_SET) == null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiParameterListImpl.$$$reportNull$$$0(5);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitParameterList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiParameterList:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiParameterListImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiParameterListImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParameterIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

