/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowOptions;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PatternResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiIfStatementImpl
extends CompositePsiElement
implements PsiIfStatement,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiIfStatementImpl.class);

    public PsiIfStatementImpl() {
        super(IF_STATEMENT);
    }

    @Override
    public PsiExpression getCondition() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(32);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        ASTNode elseKeyword;
        if (child == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(0);
        }
        if (child == this.getThenBranch()) {
            this.replaceChildInternal(child, (TreeElement)((Object)JavaPsiFacade.getElementFactory(this.getProject()).createStatementFromText("{}", null)));
            return;
        }
        if (child == this.getElseBranch() && (elseKeyword = this.findChildByRole(31)) != null) {
            super.deleteChildInternal(elseKeyword);
        }
        super.deleteChildInternal(child);
    }

    @Override
    public PsiStatement getThenBranch() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(33);
    }

    @Override
    public PsiStatement getElseBranch() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(34);
    }

    @Override
    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
    }

    @Override
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    @Override
    public PsiKeyword getElseElement() {
        return (PsiKeyword)this.findChildByRoleAsPsiElement(31);
    }

    @Override
    public void setElseBranch(@NotNull PsiStatement statement) throws IncorrectOperationException {
        PsiKeyword elseElement;
        PsiStatement elseBranch;
        if (statement == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(1);
        }
        if ((elseBranch = this.getElseBranch()) != null) {
            elseBranch.delete();
        }
        if ((elseElement = this.getElseElement()) != null) {
            elseElement.delete();
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.getProject());
        PsiIfStatement ifStatement = (PsiIfStatement)elementFactory.createStatementFromText("if (true) {} else {}", this);
        ifStatement.getElseBranch().replace(statement);
        this.addRange(ifStatement.getElseElement(), ifStatement.getLastChild());
    }

    @Override
    public void setThenBranch(@NotNull PsiStatement statement) throws IncorrectOperationException {
        PsiStatement thenBranch;
        if (statement == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(2);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.getProject());
        ASTNode keyword = this.findChildByRole(30);
        LOG.assertTrue(keyword != null);
        PsiIfStatement ifStatementPattern = (PsiIfStatement)elementFactory.createStatementFromText("if (){}", this);
        if (this.getLParenth() == null) {
            this.addAfter(ifStatementPattern.getLParenth(), keyword.getPsi());
        }
        if (this.getRParenth() == null) {
            PsiElement anchor = this.getCondition() == null ? this.getLParenth() : this.getCondition();
            this.addAfter(ifStatementPattern.getRParenth(), anchor);
        }
        if ((thenBranch = this.getThenBranch()) == null) {
            this.addAfter(statement, this.getRParenth());
        } else {
            thenBranch.replace(statement);
        }
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 30: {
                return this.findChildByType(IF_KEYWORD);
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 32: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 33: {
                return PsiImplUtil.findStatementChild(this);
            }
            case 31: {
                return this.findChildByType(ELSE_KEYWORD);
            }
            case 34: 
        }
        ASTNode elseKeyword = this.findChildByRole(31);
        if (elseKeyword == null) {
            return null;
        }
        for (ASTNode child = elseKeyword.getTreeNext(); child != null; child = child.getTreeNext()) {
            if (!(child.getPsi() instanceof PsiStatement)) continue;
            return child;
        }
        return null;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == IF_KEYWORD) {
            return 30;
        }
        if (i2 == ELSE_KEYWORD) {
            return 31;
        }
        if (i2 == LPARENTH) {
            return 24;
        }
        if (i2 == RPARENTH) {
            return 25;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 32;
        }
        if (child.getPsi() instanceof PsiStatement) {
            if (this.findChildByRoleAsPsiElement(33) == child) {
                return 33;
            }
            return 34;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(4);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitIfStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        ElementClassHint elementClassHint;
        if (processor == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(5);
        }
        if (state == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(6);
        }
        if (place == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(7);
        }
        if ((elementClassHint = processor.getHint(ElementClassHint.KEY)) != null && !elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        PsiExpression condition2 = this.getCondition();
        if (condition2 != null) {
            PsiStatement thenBranch = this.getThenBranch();
            PsiStatement elseBranch = this.getElseBranch();
            if (lastParent == null) {
                if (state.get(PatternResolveState.KEY) == PatternResolveState.WHEN_NONE) {
                    return true;
                }
                PsiScopeProcessor conditionProcessor = state.get(PatternResolveState.KEY) == PatternResolveState.WHEN_BOTH ? processor : (element, s2) -> {
                    ControlFlow flow;
                    LOG.assertTrue(element instanceof PsiPatternVariable);
                    NameHint hint = processor.getHint(NameHint.KEY);
                    if (hint != null && !((PsiPatternVariable)element).getName().equals(hint.getName(s2))) {
                        return true;
                    }
                    try {
                        flow = ControlFlowFactory.getControlFlow(this, new LocalsControlFlowPolicy(this), ControlFlowOptions.NO_CONST_EVALUATE);
                    }
                    catch (AnalysisCanceledException e2) {
                        return true;
                    }
                    boolean thenCompletesNormally = PsiIfStatementImpl.canCompleteNormally(thenBranch, flow);
                    boolean elseCompletesNormally = PsiIfStatementImpl.canCompleteNormally(elseBranch, flow);
                    if (thenCompletesNormally == elseCompletesNormally || PatternResolveState.fromBoolean(thenCompletesNormally) != PatternResolveState.stateAtParent((PsiPatternVariable)element, condition2)) {
                        return true;
                    }
                    return processor.execute(element, s2);
                };
                return condition2.processDeclarations(conditionProcessor, PatternResolveState.WHEN_BOTH.putInto(state), null, place);
            }
            if (lastParent == thenBranch) {
                return condition2.processDeclarations(processor, PatternResolveState.WHEN_TRUE.putInto(state), null, place);
            }
            if (lastParent == elseBranch) {
                return condition2.processDeclarations(processor, PatternResolveState.WHEN_FALSE.putInto(state), null, place);
            }
        }
        return true;
    }

    private static boolean canCompleteNormally(PsiStatement branch, ControlFlow flow) {
        if (branch == null) {
            return true;
        }
        int startOffset = flow.getStartOffset(branch);
        int endOffset = flow.getEndOffset(branch);
        return startOffset != -1 && endOffset != -1 && ControlFlowUtil.canCompleteNormally(flow, startOffset, endOffset);
    }

    @Override
    public String toString() {
        return "PsiIfStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiIfStatementImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteChildInternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setElseBranch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setThenBranch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

