/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiLocalVariableImpl
extends CompositePsiElement
implements PsiLocalVariable,
PsiVariableEx {
    private static final Logger LOG = Logger.getInstance(PsiLocalVariableImpl.class);
    private volatile String myCachedName;

    public PsiLocalVariableImpl() {
        this(JavaElementType.LOCAL_VARIABLE);
    }

    PsiLocalVariableImpl(@NotNull IElementType type) {
        if (type == null) {
            PsiLocalVariableImpl.$$$reportNull$$$0(0);
        }
        super(type);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedName = null;
    }

    @Override
    @NotNull
    public final PsiIdentifier getNameIdentifier() {
        PsiElement element = this.findChildByRoleAsPsiElement(9);
        assert (element instanceof PsiIdentifier) : this.getText();
        PsiIdentifier psiIdentifier = (PsiIdentifier)element;
        if (psiIdentifier == null) {
            PsiLocalVariableImpl.$$$reportNull$$$0(1);
        }
        return psiIdentifier;
    }

    @Override
    @NotNull
    public final String getName() {
        String cachedName = this.myCachedName;
        if (cachedName == null) {
            this.myCachedName = cachedName = this.getNameIdentifier().getText();
        }
        String string2 = cachedName;
        if (string2 == null) {
            PsiLocalVariableImpl.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        JavaSharedImplUtil.setInitializer(this, initializer);
    }

    @Override
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            PsiLocalVariableImpl.$$$reportNull$$$0(3);
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name2);
        return this;
    }

    @Override
    @NotNull
    public final PsiType getType() {
        PsiType psiType = JavaSharedImplUtil.getType(this.getTypeElement(), this.getNameIdentifier());
        if (psiType == null) {
            PsiLocalVariableImpl.$$$reportNull$$$0(4);
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiTypeElement getTypeElement() {
        PsiTypeElement typeElement = PsiTreeUtil.getChildOfType(this, PsiTypeElement.class);
        if (typeElement != null) {
            PsiTypeElement psiTypeElement = typeElement;
            if (psiTypeElement == null) {
                PsiLocalVariableImpl.$$$reportNull$$$0(5);
            }
            return psiTypeElement;
        }
        PsiElement parent = this.getParent();
        assert (parent != null) : "no parent; " + this + "; [" + this.getText() + "]";
        PsiLocalVariable localVariable = PsiTreeUtil.getChildOfType(parent, PsiLocalVariable.class);
        assert (localVariable != null) : "no local variable in " + Arrays.toString(parent.getChildren());
        typeElement = PsiTreeUtil.getChildOfType(localVariable, PsiTypeElement.class);
        assert (typeElement != null) : "no type element in " + Arrays.toString(localVariable.getChildren());
        PsiTypeElement psiTypeElement = typeElement;
        if (psiTypeElement == null) {
            PsiLocalVariableImpl.$$$reportNull$$$0(6);
        }
        return psiTypeElement;
    }

    @Override
    public PsiModifierList getModifierList() {
        CompositeElement parent = this.getTreeParent();
        if (parent == null) {
            return null;
        }
        CompositeElement first2 = (CompositeElement)parent.findChildByType(JavaElementType.LOCAL_VARIABLE);
        return first2 != null ? (PsiModifierList)first2.findChildByRoleAsPsiElement(8) : null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name2) {
        PsiModifierList modifierList;
        if (name2 == null) {
            PsiLocalVariableImpl.$$$reportNull$$$0(7);
        }
        return (modifierList = this.getModifierList()) != null && modifierList.hasModifierProperty(name2);
    }

    @Override
    public PsiExpression getInitializer() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(21);
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Override
    public Object computeConstantValue() {
        return this.computeConstantValue(new HashSet<PsiVariable>());
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        PsiType type = this.getType();
        if (!(type instanceof PsiPrimitiveType) && !type.equalsToText("java.lang.String")) {
            return null;
        }
        PsiExpression initializer = this.getInitializer();
        if (initializer == null) {
            return null;
        }
        return PsiConstantEvaluationHelperImpl.computeCastTo(initializer, this.getType(), visitedVars);
    }

    @Override
    public int getTextOffset() {
        return this.getNameIdentifier().getTextOffset();
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
        PsiElement[] variables;
        CheckUtil.checkWritable(this);
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
        CompositeElement statement = this.getTreeParent();
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(statement);
        PsiElement[] psiElementArray = variables = psiElement instanceof PsiDeclarationStatement ? ((PsiDeclarationStatement)psiElement).getDeclaredElements() : PsiElement.EMPTY_ARRAY;
        if (variables.length > 1) {
            PsiModifierList modifierList = this.getModifierList();
            PsiTypeElement typeElement = this.getTypeElement();
            assert (modifierList != null) : this.getText();
            CompositeElement last2 = statement;
            for (int i2 = 1; i2 < variables.length; ++i2) {
                ASTNode typeCopy = typeElement.copy().getNode();
                ASTNode modifierListCopy = modifierList.copy().getNode();
                CompositeElement variable = (CompositeElement)SourceTreeToPsiMap.psiToTreeNotNull(variables[i2]);
                ASTNode comma = PsiImplUtil.skipWhitespaceAndCommentsBack(variable.getTreePrev());
                if (comma != null && comma.getElementType() == JavaTokenType.COMMA) {
                    PsiElement nextSibling;
                    PsiElement lastWhitespaceAfterComma = comma.getPsi();
                    while ((nextSibling = lastWhitespaceAfterComma.getNextSibling()) instanceof PsiWhiteSpace) {
                        lastWhitespaceAfterComma = nextSibling;
                    }
                    CodeEditUtil.removeChildren(statement, comma, lastWhitespaceAfterComma.getNode());
                }
                CodeEditUtil.removeChild(statement, variable);
                CharTable charTableByTree = SharedImplUtil.findCharTableByTree(statement);
                CompositeElement statement1 = Factory.createCompositeElement(JavaElementType.DECLARATION_STATEMENT, charTableByTree, this.getManager());
                statement1.addChild(variable, null);
                LeafElement space = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, " ", 0, 1, treeCharTab, this.getManager());
                variable.addChild(space, variable.getFirstChildNode());
                variable.addChild(typeCopy, variable.getFirstChildNode());
                if (modifierListCopy.getTextLength() > 0) {
                    space = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, " ", 0, 1, treeCharTab, this.getManager());
                    variable.addChild(space, variable.getFirstChildNode());
                }
                variable.addChild(modifierListCopy, variable.getFirstChildNode());
                LeafElement semicolon = Factory.createSingleLeafElement(JavaTokenType.SEMICOLON, ";", 0, 1, treeCharTab, this.getManager());
                SourceTreeToPsiMap.psiToTreeNotNull(variables[i2 - 1]).addChild(semicolon, null);
                CodeEditUtil.addChild(statement.getTreeParent(), statement1, last2.getTreeNext());
                last2 = statement1;
            }
        }
        JavaSharedImplUtil.normalizeBrackets(this);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        ASTNode eq;
        if (child == null) {
            PsiLocalVariableImpl.$$$reportNull$$$0(8);
        }
        if (this.getChildRole(child) == 21 && (eq = this.findChildByRole(20)) != null) {
            this.deleteChildInternal(eq);
        }
        super.deleteChildInternal(child);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 8: {
                return this.findChildByType(JavaElementType.MODIFIER_LIST);
            }
            case 10: {
                return this.findChildByType(JavaElementType.TYPE);
            }
            case 9: {
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 20: {
                return this.findChildByType(JavaTokenType.EQ);
            }
            case 21: {
                return this.findChildByType(ElementType.EXPRESSION_BIT_SET);
            }
            case 22: 
        }
        return TreeUtil.findChildBackward(this, JavaTokenType.SEMICOLON);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiLocalVariableImpl.$$$reportNull$$$0(9);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == JavaElementType.MODIFIER_LIST) {
            return 8;
        }
        if (i2 == JavaElementType.TYPE) {
            return this.getChildRole(child, 10);
        }
        if (i2 == JavaTokenType.IDENTIFIER) {
            return this.getChildRole(child, 9);
        }
        if (i2 == JavaTokenType.EQ) {
            return this.getChildRole(child, 20);
        }
        if (i2 == JavaTokenType.SEMICOLON) {
            return this.getChildRole(child, 22);
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 21;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiLocalVariableImpl.$$$reportNull$$$0(10);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitLocalVariable(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiLocalVariableImpl.$$$reportNull$$$0(11);
        }
        if (state == null) {
            PsiLocalVariableImpl.$$$reportNull$$$0(12);
        }
        if (place == null) {
            PsiLocalVariableImpl.$$$reportNull$$$0(13);
        }
        if (lastParent == null) {
            return true;
        }
        if (lastParent.getContext() instanceof JavaDummyHolder) {
            return processor.execute(this, state);
        }
        if (lastParent.getParent() != this) {
            return true;
        }
        ASTNode lastParentTree = SourceTreeToPsiMap.psiElementToTree(lastParent);
        return this.getChildRole(lastParentTree) != 21 || processor.execute(this, state);
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public String toString() {
        return "PsiLocalVariable:" + this.getName();
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        if (this.isUnnamed()) {
            LocalSearchScope localSearchScope = LocalSearchScope.EMPTY;
            if (localSearchScope == null) {
                PsiLocalVariableImpl.$$$reportNull$$$0(14);
            }
            return localSearchScope;
        }
        PsiElement parentElement = this.getParent();
        if (parentElement instanceof PsiDeclarationStatement) {
            return new LocalSearchScope(parentElement.getParent());
        }
        GlobalSearchScope globalSearchScope = ResolveScopeManager.getElementUseScope(this);
        if (globalSearchScope == null) {
            PsiLocalVariableImpl.$$$reportNull$$$0(15);
        }
        return globalSearchScope;
    }

    @Override
    public Icon getElementIcon(int flags) {
        IconManager iconManager = IconManager.getInstance();
        RowIcon baseIcon = iconManager.createLayeredIcon(this, iconManager.getPlatformIcon(PlatformIcons.Variable), ElementPresentationUtil.getFlags(this, false));
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiLocalVariableImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeElement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

