/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Query;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageScope
extends GlobalSearchScope {
    private final Set<VirtualFile> myDirs;
    private final PsiPackage myPackage;
    private final boolean myIncludeSubpackages;
    private final boolean myIncludeLibraries;
    private final boolean myPartOfPackagePrefix;
    private final String myPackageQualifiedName;
    private final String myPackageQNamePrefix;

    public PackageScope(@NotNull PsiPackage aPackage, boolean includeSubpackages, boolean includeLibraries) {
        if (aPackage == null) {
            PackageScope.$$$reportNull$$$0(0);
        }
        this(aPackage, includeSubpackages, includeLibraries, null);
    }

    private PackageScope(@NotNull PsiPackage aPackage, boolean includeSubpackages, boolean includeLibraries, @Nullable GlobalSearchScope packageScope) {
        if (aPackage == null) {
            PackageScope.$$$reportNull$$$0(1);
        }
        super(aPackage.getProject());
        this.myPackage = aPackage;
        this.myIncludeSubpackages = includeSubpackages;
        Project project = this.myPackage.getProject();
        this.myPackageQualifiedName = this.myPackage.getQualifiedName();
        PackageIndex packageIndex = PackageIndex.getInstance(project);
        Query<VirtualFile> dirs = packageScope != null ? packageIndex.getDirsByPackageName(this.myPackageQualifiedName, packageScope) : packageIndex.getDirsByPackageName(this.myPackageQualifiedName, true);
        this.myDirs = VfsUtilCore.createCompactVirtualFileSet();
        dirs.forEach(e2 -> {
            this.myDirs.add((VirtualFile)e2);
            return true;
        });
        this.myIncludeLibraries = includeLibraries;
        this.myPartOfPackagePrefix = JavaPsiFacade.getInstance(project).isPartOfPackagePrefix(this.myPackageQualifiedName);
        this.myPackageQNamePrefix = this.myPackageQualifiedName + ".";
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        String packageName;
        PsiFile psiFile;
        VirtualFile dir;
        if (file2 == null) {
            PackageScope.$$$reportNull$$$0(2);
        }
        VirtualFile virtualFile = dir = file2.isDirectory() ? file2 : file2.getParent();
        if (!this.myIncludeSubpackages) {
            if (this.myDirs.contains(dir)) {
                return true;
            }
        } else {
            while (dir != null) {
                if (this.myDirs.contains(dir)) {
                    return true;
                }
                dir = dir.getParent();
            }
        }
        return this.myPartOfPackagePrefix && this.myIncludeSubpackages && (psiFile = this.myPackage.getManager().findFile(file2)) instanceof PsiClassOwner && (this.myPackageQualifiedName.equals(packageName = ((PsiClassOwner)psiFile).getPackageName()) || packageName.startsWith(this.myPackageQNamePrefix));
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            PackageScope.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.myIncludeLibraries;
    }

    public String toString() {
        return "package scope: " + this.myPackage + ", includeSubpackages = " + this.myIncludeSubpackages;
    }

    @NotNull
    public static GlobalSearchScope packageScope(@NotNull PsiPackage aPackage, boolean includeSubpackages) {
        if (aPackage == null) {
            PackageScope.$$$reportNull$$$0(4);
        }
        return new PackageScope(aPackage, includeSubpackages, true);
    }

    @NotNull
    public static GlobalSearchScope packageScope(@NotNull PsiPackage aPackage, boolean includeSubpackages, @NotNull GlobalSearchScope packageScope) {
        if (aPackage == null) {
            PackageScope.$$$reportNull$$$0(5);
        }
        if (packageScope == null) {
            PackageScope.$$$reportNull$$$0(6);
        }
        return new PackageScope(aPackage, includeSubpackages, true, packageScope);
    }

    @NotNull
    public static GlobalSearchScope packageScopeWithoutLibraries(@NotNull PsiPackage aPackage, boolean includeSubpackages) {
        if (aPackage == null) {
            PackageScope.$$$reportNull$$$0(7);
        }
        return new PackageScope(aPackage, includeSubpackages, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageScope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/search/PackageScope";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSearchInModuleContent";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "packageScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "packageScopeWithoutLibraries";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

