/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreStubTreeLoader
extends StubTreeLoader {
    @Override
    public ObjectStubTree<?> readOrBuild(@NotNull Project project, @NotNull VirtualFile vFile, @Nullable PsiFile psiFile) {
        if (project == null) {
            CoreStubTreeLoader.$$$reportNull$$$0(0);
        }
        if (vFile == null) {
            CoreStubTreeLoader.$$$reportNull$$$0(1);
        }
        if (!this.canHaveStub(vFile)) {
            return null;
        }
        return this.build(project, vFile, psiFile);
    }

    @Override
    @Nullable
    public ObjectStubTree<?> build(@Nullable Project project, @NotNull VirtualFile vFile, @Nullable PsiFile psiFile) {
        if (vFile == null) {
            CoreStubTreeLoader.$$$reportNull$$$0(2);
        }
        try {
            FileContent fc = FileContentImpl.createByFile(vFile, project);
            Stub element = StubTreeBuilder.buildStubTree(fc);
            if (element instanceof PsiFileStub) {
                return new StubTree((PsiFileStub)element);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        return null;
    }

    @Override
    public ObjectStubTree<?> readFromVFile(@NotNull Project project, @NotNull VirtualFile vFile) {
        if (project == null) {
            CoreStubTreeLoader.$$$reportNull$$$0(3);
        }
        if (vFile == null) {
            CoreStubTreeLoader.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    public void rebuildStubTree(VirtualFile virtualFile) {
    }

    @Override
    public boolean canHaveStub(VirtualFile file2) {
        FileType fileType = file2.getFileType();
        if (fileType instanceof LanguageFileType) {
            Language l2 = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l2);
            if (parserDefinition == null) {
                return false;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            return elementType instanceof IStubFileElementType && ((IStubFileElementType)elementType).shouldBuildStubFor(file2);
        }
        if (fileType.isBinary()) {
            BinaryFileStubBuilder builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
            return builder != null && builder.acceptsFile(file2);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/stubs/CoreStubTreeLoader";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readOrBuild";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readFromVFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

