/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.diagnostic.LoadingState;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class IElementType {
    public static final IElementType[] EMPTY_ARRAY = new IElementType[0];
    public static final ArrayFactory<IElementType> ARRAY_FACTORY = count2 -> count2 == 0 ? EMPTY_ARRAY : new IElementType[count2];
    public static final Predicate TRUE = type -> true;
    public static final short FIRST_TOKEN_INDEX = 1;
    private static final short MAX_INDEXED_TYPES = 15000;
    private static short size;
    private static volatile IElementType @NotNull [] ourRegistry;
    @NonNls
    private static final Object lock;
    private final short myIndex;
    @NonNls
    @NotNull
    private final String myDebugName;
    @NotNull
    private final Language myLanguage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static IElementType @NotNull [] push(IElementType @NotNull [] types) {
        if (types == null) {
            IElementType.$$$reportNull$$$0(0);
        }
        Object object = lock;
        // MONITORENTER : object
        IElementType[] oldRegistry = ourRegistry;
        ourRegistry = types;
        size = (short)ContainerUtil.skipNulls(Arrays.asList(ourRegistry)).size();
        // MONITOREXIT : object
        if (oldRegistry != null) return oldRegistry;
        IElementType.$$$reportNull$$$0(1);
        return oldRegistry;
    }

    public static void unregisterElementTypes(@NotNull ClassLoader loader2, @NotNull PluginDescriptor pluginDescriptor) {
        if (loader2 == null) {
            IElementType.$$$reportNull$$$0(2);
        }
        if (pluginDescriptor == null) {
            IElementType.$$$reportNull$$$0(3);
        }
        for (int i2 = 0; i2 < ourRegistry.length; ++i2) {
            IElementType type = ourRegistry[i2];
            if (type == null || type.getClass().getClassLoader() != loader2) continue;
            IElementType.ourRegistry[i2] = TombstoneElementType.create(type, pluginDescriptor);
        }
    }

    public static void unregisterElementTypes(@NotNull Language language, @NotNull PluginDescriptor pluginDescriptor) {
        if (language == null) {
            IElementType.$$$reportNull$$$0(4);
        }
        if (pluginDescriptor == null) {
            IElementType.$$$reportNull$$$0(5);
        }
        if (language == Language.ANY) {
            throw new IllegalArgumentException("Trying to unregister Language.ANY");
        }
        for (int i2 = 0; i2 < ourRegistry.length; ++i2) {
            IElementType type = ourRegistry[i2];
            if (type == null || !type.getLanguage().equals(language)) continue;
            IElementType.ourRegistry[i2] = TombstoneElementType.create(type, pluginDescriptor);
        }
    }

    public IElementType(@NonNls @NotNull String debugName, @Nullable Language language) {
        if (debugName == null) {
            IElementType.$$$reportNull$$$0(6);
        }
        this(debugName, language, true);
        if (!(this instanceof IFileElementType)) {
            LoadingState.COMPONENTS_REGISTERED.checkOccurred();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IElementType(@NonNls @NotNull String debugName, @Nullable Language language, boolean register) {
        if (debugName == null) {
            IElementType.$$$reportNull$$$0(7);
        }
        this.myDebugName = debugName;
        Language language2 = this.myLanguage = language == null ? Language.ANY : language;
        if (register) {
            Object object = lock;
            synchronized (object) {
                short s2 = size;
                size = (short)(s2 + 1);
                this.myIndex = s2;
                if (this.myIndex >= 15000) {
                    Map<Language, List<IElementType>> byLang = Stream.of(ourRegistry).filter(Objects::nonNull).collect(Collectors.groupingBy(ie -> ie.myLanguage));
                    Map.Entry max = Collections.max(byLang.entrySet(), Comparator.comparingInt(e2 -> ((List)e2.getValue()).size()));
                    List types = (List)max.getValue();
                    Logger.getInstance(IElementType.class).error("Too many element types registered. Out of (short) range. Most of element types (" + types.size() + ") were registered for '" + max.getKey() + "': " + StringUtil.first(StringUtil.join(types, ", "), 300, true));
                }
                IElementType[] newRegistry = this.myIndex >= ourRegistry.length ? ArrayUtil.realloc(ourRegistry, ourRegistry.length * 3 / 2 + 1, ARRAY_FACTORY) : ourRegistry;
                newRegistry[this.myIndex] = this;
                ourRegistry = newRegistry;
            }
        } else {
            this.myIndex = (short)-1;
        }
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            IElementType.$$$reportNull$$$0(8);
        }
        return language;
    }

    public final short getIndex() {
        return this.myIndex;
    }

    public int hashCode() {
        return this.myIndex >= 0 ? this.myIndex : super.hashCode();
    }

    public String toString() {
        return this.getDebugName();
    }

    @ApiStatus.Internal
    @NonNls
    @NotNull
    public String getDebugName() {
        String string2 = this.myDebugName;
        if (string2 == null) {
            IElementType.$$$reportNull$$$0(9);
        }
        return string2;
    }

    public boolean isLeftBound() {
        return false;
    }

    public static IElementType find(short idx) {
        IElementType type = ourRegistry[idx];
        if (type instanceof TombstoneElementType) {
            throw new IllegalArgumentException("Trying to access element type from unloaded plugin: " + type);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    static short getAllocatedTypesCount() {
        Object object = lock;
        synchronized (object) {
            return size;
        }
    }

    public static IElementType @NotNull [] enumerate(@NotNull Predicate p2) {
        if (p2 == null) {
            IElementType.$$$reportNull$$$0(10);
        }
        ArrayList<IElementType> matches2 = new ArrayList<IElementType>();
        for (IElementType value : ourRegistry) {
            if (value == null || !p2.matches(value)) continue;
            matches2.add(value);
        }
        IElementType[] iElementTypeArray = matches2.toArray(new IElementType[0]);
        if (iElementTypeArray == null) {
            IElementType.$$$reportNull$$$0(11);
        }
        return iElementTypeArray;
    }

    static {
        ourRegistry = EMPTY_ARRAY;
        lock = new String("registry lock");
        IElementType[] init = new IElementType[137];
        init[0] = new IElementType("NULL", Language.ANY, false);
        IElementType.push(init);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/tree/IElementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/tree/IElementType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "push";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "enumerate";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unregisterElementTypes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TombstoneElementType
    extends IElementType {
        private TombstoneElementType(@NotNull @NonNls String debugName) {
            if (debugName == null) {
                TombstoneElementType.$$$reportNull$$$0(0);
            }
            super(debugName, Language.ANY);
        }

        private static TombstoneElementType create(@NotNull IElementType type, @NotNull PluginDescriptor pluginDescriptor) {
            if (type == null) {
                TombstoneElementType.$$$reportNull$$$0(1);
            }
            if (pluginDescriptor == null) {
                TombstoneElementType.$$$reportNull$$$0(2);
            }
            return new TombstoneElementType("tombstone of " + type + " (" + type.getClass() + ") belonged to unloaded " + pluginDescriptor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/tree/IElementType$TombstoneElementType";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    public static interface Predicate {
        public boolean matches(@NotNull IElementType var1);
    }
}

