/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaMultiReleaseUtil {
    public static final LanguageLevel MAX_NON_MULTI_RELEASE_VERSION = LanguageLevel.JDK_1_8;
    public static final LanguageLevel MIN_MULTI_RELEASE_VERSION = LanguageLevel.JDK_1_9;

    @Nullable
    private static VersionRootInfo getVersionRootInfo(@NotNull VirtualFile file2) {
        VirtualFile root;
        if (file2 == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(0);
        }
        if (!((root = VfsUtilCore.getRootFile(file2)).getFileType() instanceof ArchiveFileType)) {
            return null;
        }
        for (VirtualFile parent = file2.getParent(); parent != null && !parent.equals(root); parent = parent.getParent()) {
            LanguageLevel level = JavaMultiReleaseUtil.getVersionForVersionRoot(root, parent);
            if (level == null) continue;
            return new VersionRootInfo(level, parent, root);
        }
        return null;
    }

    @Contract(value="null, _ -> null; !null, null -> null")
    @Nullable
    public static LanguageLevel getVersionForVersionRoot(@Nullable VirtualFile root, @Nullable VirtualFile directory) {
        VirtualFile grandParent;
        if (root == null || directory == null) {
            return null;
        }
        VirtualFile parent = directory.getParent();
        if (parent == null) {
            return null;
        }
        if (parent.getName().equals("versions") && (grandParent = parent.getParent()) != null && grandParent.getName().equals("META-INF") && root.equals(grandParent.getParent())) {
            try {
                LanguageLevel level = LanguageLevel.forFeature(Integer.parseInt(directory.getName()));
                return level != null && level.isAtLeast(MIN_MULTI_RELEASE_VERSION) ? level : null;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static VirtualFile findBaseFile(@NotNull VirtualFile file2) {
        VersionRootInfo info;
        if (file2 == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(1);
        }
        if ((info = JavaMultiReleaseUtil.getVersionRootInfo(file2)) == null) {
            return null;
        }
        VirtualFile versionRoot = info.versionRoot;
        VirtualFile classRoot = info.classRoot;
        String relativePath = VfsUtilCore.getRelativePath(file2, versionRoot);
        if (relativePath == null) {
            return null;
        }
        return classRoot.findFileByRelativePath(relativePath);
    }

    @NotNull
    public static VirtualFile findVersionSpecificFile(@NotNull VirtualFile file2, @NotNull LanguageLevel level) {
        VirtualFile root;
        if (file2 == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(2);
        }
        if (level == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(3);
        }
        if (!((root = VfsUtilCore.getRootFile(file2)).getFileType() instanceof ArchiveFileType)) {
            VirtualFile virtualFile = file2;
            if (virtualFile == null) {
                JavaMultiReleaseUtil.$$$reportNull$$$0(4);
            }
            return virtualFile;
        }
        String relativePath = VfsUtilCore.getRelativePath(file2, root);
        if (relativePath == null) {
            VirtualFile virtualFile = file2;
            if (virtualFile == null) {
                JavaMultiReleaseUtil.$$$reportNull$$$0(5);
            }
            return virtualFile;
        }
        VirtualFile versions = root.findFileByRelativePath("META-INF/versions");
        if (versions == null) {
            VirtualFile virtualFile = file2;
            if (virtualFile == null) {
                JavaMultiReleaseUtil.$$$reportNull$$$0(6);
            }
            return virtualFile;
        }
        int minFeature = MIN_MULTI_RELEASE_VERSION.feature();
        for (int feature = level.feature(); feature >= minFeature; --feature) {
            VirtualFile target;
            VirtualFile versionRoot = versions.findChild(String.valueOf(feature));
            if (versionRoot == null || (target = versionRoot.findFileByRelativePath(relativePath)) == null) continue;
            VirtualFile virtualFile = target;
            if (virtualFile == null) {
                JavaMultiReleaseUtil.$$$reportNull$$$0(7);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = file2;
        if (virtualFile == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    @Nullable
    public static LanguageLevel getVersion(@NotNull PsiFile file2) {
        VirtualFile virtualFile;
        if (file2 == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(9);
        }
        return (virtualFile = file2.getVirtualFile()) == null ? null : JavaMultiReleaseUtil.getVersion(virtualFile);
    }

    @Nullable
    public static LanguageLevel getVersion(@NotNull VirtualFile file2) {
        VersionRootInfo version;
        if (file2 == null) {
            JavaMultiReleaseUtil.$$$reportNull$$$0(10);
        }
        return (version = JavaMultiReleaseUtil.getVersionRootInfo(file2)) == null ? null : version.level;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/JavaMultiReleaseUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/JavaMultiReleaseUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findVersionSpecificFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVersionRootInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findBaseFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findVersionSpecificFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VersionRootInfo {
        @NotNull
        final LanguageLevel level;
        @NotNull
        final VirtualFile versionRoot;
        @NotNull
        final VirtualFile classRoot;

        private VersionRootInfo(@NotNull LanguageLevel level, @NotNull VirtualFile versionRoot, @NotNull VirtualFile classRoot) {
            if (level == null) {
                VersionRootInfo.$$$reportNull$$$0(0);
            }
            if (versionRoot == null) {
                VersionRootInfo.$$$reportNull$$$0(1);
            }
            if (classRoot == null) {
                VersionRootInfo.$$$reportNull$$$0(2);
            }
            this.level = level;
            this.versionRoot = versionRoot;
            this.classRoot = classRoot;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "level";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "versionRoot";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "classRoot";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/util/JavaMultiReleaseUtil$VersionRootInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

