/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFragment;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class JavaPsiStringTemplateUtil {
    @Contract(value="null -> false")
    public static boolean isStrTemplate(@Nullable PsiExpression processor) {
        PsiField field;
        PsiElement target;
        if ((processor = PsiUtil.skipParenthesizedExprDown(processor)) instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)processor).resolve()) instanceof PsiField && (field = (PsiField)target).getName().equals("STR")) {
            PsiClass containingClass = field.getContainingClass();
            return containingClass != null && "java.lang.StringTemplate".equals(containingClass.getQualifiedName());
        }
        return false;
    }

    public static TextRange getContentRange(PsiFragment fragment) {
        IElementType tokenType = fragment.getTokenType();
        if (tokenType == JavaTokenType.STRING_TEMPLATE_BEGIN || tokenType == JavaTokenType.STRING_TEMPLATE_MID) {
            TextRange fragmentRange = fragment.getTextRange();
            return new TextRange(fragmentRange.getStartOffset() + 1, fragmentRange.getEndOffset() - 2);
        }
        if (tokenType == JavaTokenType.STRING_TEMPLATE_END) {
            TextRange fragmentRange = fragment.getTextRange();
            return new TextRange(fragmentRange.getStartOffset() + 1, fragmentRange.getEndOffset() - 1);
        }
        if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN) {
            TextRange fragmentRange = fragment.getTextRange();
            String text = fragment.getText();
            int index2 = 3;
            while (PsiLiteralUtil.isTextBlockWhiteSpace(text.charAt(index2))) {
                ++index2;
            }
            return new TextRange(fragmentRange.getStartOffset() + ++index2, fragmentRange.getEndOffset() - 2);
        }
        if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_MID) {
            TextRange fragmentRange = fragment.getTextRange();
            return new TextRange(fragmentRange.getStartOffset() + 1, fragmentRange.getEndOffset() - 2);
        }
        if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_END) {
            TextRange fragmentRange = fragment.getTextRange();
            return new TextRange(fragmentRange.getStartOffset() + 1, fragmentRange.getEndOffset() - 3);
        }
        throw new AssertionError();
    }
}

