/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QualifiedName
implements Comparable<QualifiedName> {
    @NotNull
    private final List<String> myComponents;

    private QualifiedName(int count2) {
        this.myComponents = new ArrayList<String>(count2);
    }

    public static QualifiedName fromComponents(Collection<String> components) {
        for (String component : components) {
            QualifiedName.assertNoDots(component);
        }
        QualifiedName qName = new QualifiedName(components.size());
        qName.myComponents.addAll(components);
        return qName;
    }

    @NotNull
    public static QualifiedName fromComponents(String ... components) {
        for (String component : components) {
            QualifiedName.assertNoDots(component);
        }
        QualifiedName result2 = new QualifiedName(components.length);
        Collections.addAll(result2.myComponents, components);
        QualifiedName qualifiedName = result2;
        if (qualifiedName == null) {
            QualifiedName.$$$reportNull$$$0(0);
        }
        return qualifiedName;
    }

    public QualifiedName append(String name2) {
        QualifiedName result2 = new QualifiedName(this.myComponents.size() + 1);
        result2.myComponents.addAll(this.myComponents);
        result2.myComponents.add(name2);
        return result2;
    }

    public QualifiedName append(QualifiedName qName) {
        QualifiedName result2 = new QualifiedName(this.myComponents.size() + qName.getComponentCount());
        result2.myComponents.addAll(this.myComponents);
        result2.myComponents.addAll(qName.getComponents());
        return result2;
    }

    @NotNull
    public QualifiedName removeLastComponent() {
        QualifiedName qualifiedName = this.removeTail(1);
        if (qualifiedName == null) {
            QualifiedName.$$$reportNull$$$0(1);
        }
        return qualifiedName;
    }

    @NotNull
    public QualifiedName removeTail(int count2) {
        int size = this.myComponents.size();
        QualifiedName result2 = new QualifiedName(size);
        result2.myComponents.addAll(this.myComponents);
        for (int i2 = 0; i2 < count2 && !result2.myComponents.isEmpty(); ++i2) {
            result2.myComponents.remove(result2.myComponents.size() - 1);
        }
        QualifiedName qualifiedName = result2;
        if (qualifiedName == null) {
            QualifiedName.$$$reportNull$$$0(2);
        }
        return qualifiedName;
    }

    @NotNull
    public QualifiedName removeHead(int count2) {
        int size = this.myComponents.size();
        QualifiedName result2 = new QualifiedName(size);
        result2.myComponents.addAll(this.myComponents);
        for (int i2 = 0; i2 < count2 && !result2.myComponents.isEmpty(); ++i2) {
            result2.myComponents.remove(0);
        }
        QualifiedName qualifiedName = result2;
        if (qualifiedName == null) {
            QualifiedName.$$$reportNull$$$0(3);
        }
        return qualifiedName;
    }

    @NotNull
    public List<String> getComponents() {
        List<String> list2 = Collections.unmodifiableList(this.myComponents);
        if (list2 == null) {
            QualifiedName.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public int getComponentCount() {
        return this.myComponents.size();
    }

    public boolean matches(String ... components) {
        if (this.myComponents.size() != components.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.myComponents.size(); ++i2) {
            if (this.myComponents.get(i2).equals(components[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean matchesPrefix(@NotNull QualifiedName prefix) {
        if (prefix == null) {
            QualifiedName.$$$reportNull$$$0(5);
        }
        if (this.getComponentCount() < prefix.getComponentCount()) {
            return false;
        }
        for (int i2 = 0; i2 < prefix.getComponentCount(); ++i2) {
            String component = this.getComponents().get(i2);
            if (component != null && component.equals(prefix.getComponents().get(i2))) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(@NotNull String suffix) {
        if (suffix == null) {
            QualifiedName.$$$reportNull$$$0(6);
        }
        return suffix.equals(this.getLastComponent());
    }

    public static void serialize(@Nullable QualifiedName qName, StubOutputStream dataStream) throws IOException {
        if (qName == null) {
            dataStream.writeVarInt(0);
        } else {
            dataStream.writeVarInt(qName.getComponentCount());
            for (String s2 : qName.myComponents) {
                dataStream.writeName(s2);
            }
        }
    }

    @Nullable
    public static QualifiedName deserialize(StubInputStream dataStream) throws IOException {
        QualifiedName qName;
        int size = dataStream.readVarInt();
        if (size == 0) {
            qName = null;
        } else {
            qName = new QualifiedName(size);
            for (int i2 = 0; i2 < size; ++i2) {
                qName.myComponents.add(dataStream.readNameString());
            }
        }
        return qName;
    }

    @Nullable
    public String getFirstComponent() {
        if (this.myComponents.isEmpty()) {
            return null;
        }
        return this.myComponents.get(0);
    }

    @Nullable
    public String getLastComponent() {
        if (this.myComponents.isEmpty()) {
            return null;
        }
        return this.myComponents.get(this.myComponents.size() - 1);
    }

    public String toString() {
        return this.join(".");
    }

    public String join(String separator) {
        return StringUtil.join(this.myComponents, separator);
    }

    @NotNull
    public static QualifiedName fromDottedString(@NotNull String refName) {
        if (refName == null) {
            QualifiedName.$$$reportNull$$$0(7);
        }
        return QualifiedName.fromComponents(refName.split("\\."));
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o2;
        return this.myComponents.equals(that.myComponents);
    }

    public int hashCode() {
        return this.myComponents.hashCode();
    }

    public QualifiedName subQualifiedName(int fromIndex, int toIndex) {
        return QualifiedName.fromComponents(this.myComponents.subList(fromIndex, toIndex));
    }

    @Override
    public int compareTo(@NotNull QualifiedName other) {
        if (other == null) {
            QualifiedName.$$$reportNull$$$0(8);
        }
        return this.toString().compareTo(other.toString());
    }

    private static void assertNoDots(@NotNull String component) {
        if (component == null) {
            QualifiedName.$$$reportNull$$$0(9);
        }
        if (component.contains(".")) {
            throw new IllegalArgumentException("Components of QualifiedName cannot contain dots inside them, but got: " + component);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/QualifiedName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fromComponents";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLastComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "removeTail";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "removeHead";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/QualifiedName";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matchesPrefix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromDottedString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "assertNoDots";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

